/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.util.Collection;
import java.util.Set;
import merlin.data.AMerlinObj;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.LinkedIdentityHashSet;

public class Proxy<T extends ICompElement>
extends AMerlinObj
implements ICompElement {
    static final long serialVersionUID = -3893471045648835311L;
    private T d_obj;
    private boolean d_enabled = true;

    public Proxy(T obj) {
        this.d_obj = obj;
    }

    @Override
    public String getName() {
        return this.d_obj.getName();
    }

    @Override
    public void setName(String name) {
        this.d_obj.setName(name);
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return this.d_obj.getChildren();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return this.d_obj.getPropTypes(options);
    }

    public <U> void setProperty(Object property, U value) {
        if (property == MerlinData.ENABLED) {
            this.setEnabled((Boolean)value);
        } else {
            this.d_obj.setProperty(property, value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == MerlinData.ENABLED) {
            return this.isEnabled();
        }
        return this.d_obj.getProperty(property);
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL);
            this.d_obj.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL);
        }
    }

    public T getObj() {
        return this.d_obj;
    }

    @Override
    public void setDomain(MerlinData domain, IMerlinObj parent) {
        this.updateDomainProxy(domain);
        super.setDomain(domain, parent);
        if (this.d_obj != null && this.d_obj instanceof EgressAgent) {
            ((EgressAgent)this.d_obj).updateProps();
        }
    }

    @Override
    public void setDomain(MerlinData owner) {
        this.updateDomainProxy(owner);
        super.setDomain(owner);
    }

    private void updateDomainProxy(MerlinData domain) {
        MerlinData curDomain;
        if (domain != null) {
            domain.proxies.add(this);
        }
        if ((curDomain = (MerlinData)this.getDomain()) != null) {
            curDomain.proxies.remove(this);
        }
    }

    public static Collection<Object> getProxyParents(ICompElement obj, boolean includeDisabledProxies) {
        Set<Proxy<? extends ICompElement>> allProxies;
        MerlinData md = (MerlinData)obj.getDomain();
        if (md == null) {
            return null;
        }
        Set<Proxy<? extends ICompElement>> set = allProxies = md.proxies != null ? md.proxies.getProxies(obj) : null;
        if (allProxies == null || allProxies.isEmpty()) {
            return null;
        }
        LinkedIdentityHashSet<Object> allParents = new LinkedIdentityHashSet<Object>();
        for (Proxy<? extends ICompElement> p : allProxies) {
            Object parent;
            if (!includeDisabledProxies && !p.isEnabled() || (parent = ((MerlinData)obj.getDomain()).hierarchy.getParent(p)) == null) continue;
            allParents.add(parent);
        }
        return allParents;
    }
}

