/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.OccGroupTypeObj;
import merlin.data.Proxy;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypeFilter;

public class OccGroupObj
extends GeomComposite<Proxy<EgressAgent>>
implements Serializable,
ICompElement,
IRestorable {
    static final long serialVersionUID = 1L;
    public static final IPropertySet.Prop<String> PROP_NAME = new IPropertySet.Prop<String>("OccGroupObj.NAME", "");
    public static final IPropertySet.Prop<String> PROP_DESC = new IPropertySet.Prop<String>("OccGroupObj.DESC", "");
    public static final IPropertySet.Prop<Boolean> PROP_REQUIRES_GROUP_LEADER = new IPropertySet.Prop<Boolean>("OccGroupObj.REQUIRES_GROUP_LEADER", false);
    public static final IPropertySet.Prop<EgressAgent> PROP_GROUP_LEADER = new IPropertySet.Prop<Object>("OccGroupObj.GROUP_LEADER", null);
    public static final IPropertySet.Prop<UnitDouble> PROP_MAX_DISTANCE = new IPropertySet.Prop<UnitDouble>("OccGroupObj.MAX_DISTANCE", new UnitDouble(2.0, SI.METER));
    public static final IPropertySet.Prop<UnitDouble> PROP_SLOWDOWN_TIME = new IPropertySet.Prop<UnitDouble>("OccGroupObj.SLOWDOWN_TIME", new UnitDouble(3.0, SI.SECOND));
    public static final IPropertySet.Prop<Boolean> PROP_SOCIAL_DIST_IN_GROUP = new IPropertySet.Prop<Boolean>("OccGroupObj.SOCIAL_DIST_IN_GROUP", false);
    public static final IPropertySet.Prop<Color> PROP_COLOR = new IPropertySet.Prop<Color>("OccGroupObj.COLOR", Color.BLUE);
    public static final IPropertySet.Prop<Color> PROP_TEMPLATE_COLOR = new IPropertySet.Prop<Color>("OccGroupObj.TEMPLATE_COLOR", Color.BLUE);
    public static final Set<Object> PROP_TYPES = new HashSet(IPropertySet.getAllDeclaredPublicStaticProps(OccGroupObj.class));
    private PropertySet d_props = new PropertySet();
    private static final Predicate<ICompElement> s_filter = new APredicate<ICompElement>(){

        @Override
        public boolean test(ICompElement t) {
            if (!(t instanceof Proxy)) {
                return false;
            }
            Proxy p = (Proxy)t;
            Object obj = p.getObj();
            return obj instanceof EgressAgent;
        }
    };

    public OccGroupObj() {
        super("OccGroupObj");
    }

    @Override
    public String getName() {
        return this.getProperty(PROP_NAME);
    }

    @Override
    public void setName(String name) {
        this.setProperty(PROP_NAME, name);
    }

    public void setRandomColor() {
        this.setProperty(PROP_COLOR, MerlinUtil.newRandomOccColor());
    }

    public void setColor(Color color) {
        if (color != null) {
            this.setProperty(PROP_COLOR, color);
        } else {
            this.setRandomColor();
        }
    }

    public void setTemplateColor(Color color) {
        this.setProperty(PROP_TEMPLATE_COLOR, color);
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof OccGroupObj)) {
            return;
        }
        OccGroupObj occGroup = (OccGroupObj)obj;
        this.d_props = occGroup.d_props;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public OccGroupObj clone() {
        OccGroupObj clone = (OccGroupObj)super.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        if (MerlinUtil.test(options, 1)) {
            return PROP_TYPES;
        }
        return super.getPropTypes(options);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (this.getPropTypes(1).contains(property) && property instanceof IPropertySet.Prop) {
            this.setProperty((IPropertySet.Prop)property, value);
        } else {
            super.setProperty(property, value);
        }
    }

    public <T> void setProperty(IPropertySet.Prop<T> prop, T value) {
        this.d_props.set(prop, value);
        this.changedEvt(prop);
        if (prop == PROP_COLOR || prop == PROP_TEMPLATE_COLOR) {
            for (IMerlinObj child : this.getChildren()) {
                Object obj;
                if (!(child instanceof Proxy) || (obj = ((Proxy)child).getObj()) == null || !(obj instanceof EgressAgent)) continue;
                ((EgressAgent)obj).updateProps();
            }
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (this.getPropTypes(1).contains(property) && property instanceof IPropertySet.Prop) {
            return this.getProperty((IPropertySet.Prop)property);
        }
        return super.getProperty(property);
    }

    public <T> T getProperty(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    @Override
    public boolean canAddGroup() {
        return false;
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return s_filter;
    }

    public static void removeAgentsFromGroupLeaderReferences(MerlinData md, IFilteredCollection<Proxy> proxies) {
        for (Proxy proxy : proxies) {
            EgressAgent agent;
            Object obj;
            OccGroupObj group;
            EgressAgent leader;
            Object parent = md.hierarchy.getParent(proxy);
            if (parent == null || !(parent instanceof OccGroupObj) || (leader = (group = (OccGroupObj)parent).getProperty(PROP_GROUP_LEADER)) == null || (obj = proxy.getObj()) == null || !(obj instanceof EgressAgent) || (agent = (EgressAgent)obj) != leader) continue;
            Undo.insertUndoEntry_propRestore(md, Collections.singleton(group), PROP_GROUP_LEADER);
            group.setProperty(PROP_GROUP_LEADER, null);
        }
    }

    public static OccGroupObj newGroup(String name, Collection<EgressAgent> agents, Color templateColor, Color color) {
        OccGroupObj newGroup = new OccGroupObj();
        newGroup.setName(name);
        for (EgressAgent a : agents) {
            newGroup.add(new Proxy<EgressAgent>(a));
        }
        newGroup.setColor(color);
        newGroup.setTemplateColor(templateColor);
        return newGroup;
    }

    public void loadTemplate(OccGroupTypeObj groupTemplate, List<EgressAgent> members) {
        this.setProperty(PROP_MAX_DISTANCE, groupTemplate.getProperty(PROP_MAX_DISTANCE));
        this.setProperty(PROP_SLOWDOWN_TIME, groupTemplate.getProperty(PROP_SLOWDOWN_TIME));
        this.setProperty(PROP_SOCIAL_DIST_IN_GROUP, groupTemplate.getProperty(PROP_SOCIAL_DIST_IN_GROUP));
        boolean requiresLeader = groupTemplate.getProperty(PROP_REQUIRES_GROUP_LEADER);
        this.setProperty(PROP_REQUIRES_GROUP_LEADER, Boolean.valueOf(requiresLeader));
        if (requiresLeader) {
            OccProfile leaderProfile = groupTemplate.getProperty(OccGroupTypeObj.PROP_LEADER_PROFILE);
            if (leaderProfile == null) {
                this.setProperty(PROP_GROUP_LEADER, members.get(0));
            } else {
                for (EgressAgent a : members) {
                    if (a.getProfile().getProfParent() != leaderProfile) continue;
                    this.setProperty(PROP_GROUP_LEADER, a);
                    break;
                }
            }
            assert (this.getProperty(PROP_GROUP_LEADER) != null) : "Failed to assign a group leader";
        }
    }

    public static class OccGroupComp
    extends Composite<OccGroupObj>
    implements Serializable {
        static final long serialVersionUID = 3553758720985786240L;
        private static final Predicate<ICompElement> s_filter = new TypeFilter<ICompElement>(OccGroupObj.class, OccGroupComp.class);

        public OccGroupComp() {
            this(Intl.intl("Movement Groups"));
        }

        public OccGroupComp(String name) {
            super(name);
        }

        @Override
        public Predicate<ICompElement> getFilter() {
            return s_filter;
        }

        @Override
        public Composite<?> newGroup(String name) {
            return new OccGroupComp(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Movement Group Group");
        }
    }
}

