/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import merlin.data.MerlinData;
import thunderheadeng.gui.ADomainObject;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;

public class DisplayFilter
extends ADomainObject<MerlinData> {
    public static final Predicate<?> FILTER_ALL = Filters.alwaysFalse();
    private final Map<Class<?>, Predicate<?>> d_filters = new HashMap();
    private final Map<Class<?>, Predicate<?>> d_cachedFilters = new HashMap();

    public DisplayFilter(MerlinData md) {
        this.setDomain(md);
    }

    protected void changed(Class<?> type) {
        this.d_cachedFilters.clear();
        this.changedEvt(type);
    }

    public <T> void registerFilter(Class<T> clazz, Predicate<? extends T> filter) {
        assert (filter != null) : "Filter must not be null. To remove a filter, use the method, removeFilter.";
        if (filter.equals(FILTER_ALL) && !filter.equals(this.d_filters.put(clazz, filter))) {
            this.changed(clazz);
            return;
        }
        Predicate<?> oldFilter = this.d_filters.get(clazz);
        if (oldFilter instanceof CompositeFilter) {
            if (((CompositeFilter)oldFilter).add(filter)) {
                this.changed(clazz);
            }
        } else if (oldFilter != null && !filter.equals(oldFilter)) {
            CompositeFilter newFilter = new CompositeFilter(oldFilter, filter);
            this.d_filters.put(clazz, newFilter);
            this.changed(clazz);
        } else {
            this.d_filters.put(clazz, filter);
            this.changed(clazz);
        }
    }

    public <T> boolean isRegisteredFilter(Class<T> clazz, Predicate<? extends T> filter) {
        Predicate<?> existing = this.d_filters.get(clazz);
        if (existing instanceof CompositeFilter) {
            CompositeFilter cf = (CompositeFilter)existing;
            return cf.contains(filter);
        }
        return filter.equals(existing);
    }

    public <T> void filterAllOfType(Class<T> type) {
        this.registerFilter(type, Filters.alwaysFalse());
    }

    public <T> void removeFilter(Class<T> clazz, Predicate<T> filter) {
        Predicate<?> existing = this.d_filters.get(clazz);
        if (existing instanceof CompositeFilter) {
            CompositeFilter cf = (CompositeFilter)existing;
            if (cf.remove(filter)) {
                if (cf.d_filters.size() == 1) {
                    this.d_filters.put(clazz, (Predicate<?>)cf.d_filters.get(0));
                }
                this.changed(clazz);
            }
        } else if (filter.equals(existing)) {
            this.d_filters.remove(clazz);
            this.changed(clazz);
        }
    }

    public boolean isFilteringAllOf(Class<?> type) {
        return Predicates.alwaysFalse(this.getFilter(type));
    }

    public boolean filter(Object obj) {
        Predicate<?> filter = this.getFilter(obj.getClass());
        if (filter == null) {
            return false;
        }
        return !filter.test(obj);
    }

    private Predicate<?> getFilter(Class<?> clazz) {
        if (this.d_cachedFilters.containsKey(clazz)) {
            return this.d_cachedFilters.get(clazz);
        }
        Predicate<?> filter = this.calculateFilter(clazz);
        this.d_cachedFilters.put(clazz, filter);
        return filter;
    }

    private Predicate<?> calculateFilter(Class<?> clazz) {
        Predicate<?> filter = this.d_filters.get(clazz);
        if (filter != null) {
            return filter;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && (filter = this.calculateFilter(superClass)) != null) {
            return filter;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            filter = this.calculateFilter(iface);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }

    public void reset() {
        this.d_filters.clear();
        this.d_cachedFilters.clear();
        this.changedEvt(new Object[0]);
    }

    private static class CompositeFilter<T>
    implements Predicate<T> {
        private final List<Predicate<T>> d_filters;

        public CompositeFilter(Predicate<T> ... filters) {
            this.d_filters = new ArrayList<Predicate<T>>(Arrays.asList(filters));
        }

        public boolean add(Predicate<T> filter) {
            int ix = this.d_filters.indexOf(filter);
            if (ix < 0) {
                this.d_filters.add(filter);
                return true;
            }
            return false;
        }

        public boolean contains(Predicate<? extends T> filter) {
            return this.d_filters.contains(filter);
        }

        public boolean remove(Predicate<T> filter) {
            return this.d_filters.remove(filter);
        }

        @Override
        public boolean test(T o) {
            for (Predicate<T> filter : this.d_filters) {
                if (filter.test(o)) continue;
                return false;
            }
            return true;
        }
    }
}

