/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import inferno.data2.ai.AssistOccupantsOrder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import merlin.MerlinApp;
import merlin.actions.Undo;
import merlin.data.AMerlinObj;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.PropertySet;

public class AssistedEvacTeam
extends AMerlinObj
implements Serializable,
ICompElement,
IRestorable {
    private static final long serialVersionUID = -1921363056388890558L;
    public static final IPropertySet.Prop<String> PROP_NAME = new IPropertySet.Prop<String>("AssistedEvacTeam.NAME", "");
    public static final IPropertySet.Prop<String> PROP_DESC = new IPropertySet.Prop<String>("AssistedEvacTeam.DESC", "");
    public static final IPropertySet.Prop<List<EgressAgent>> PROP_OCC_ASSIST_ORDER = new IPropertySet.Prop("AssistedEvacTeam.OCCS_TO_ASSIST", new ArrayList());
    public static final IPropertySet.Prop<List<EgressAgent>> PROP_OCCS_TO_ASSIST = new IPropertySet.Prop("AssistedEvacTeam.OCCS_TO_ASSIST", new ArrayList());
    public static final IPropertySet.Prop<Boolean> PROP_ASSIST_ALL = new IPropertySet.Prop<Boolean>("AssistedEvacTeam.ASSIST_ALL", true);
    public static final IPropertySet.Prop<AssistOccupantsOrder> PROP_ASSIST_ORDER = new IPropertySet.Prop<AssistOccupantsOrder>("AssistedEvacTeam.ASSIST_ORDER", AssistOccupantsOrder.DISTANCE);
    public static final List<IPropertySet.Prop<?>> ALL_PROPS = IPropertySet.getAllDeclaredPublicStaticProps(AssistedEvacTeam.class).stream().filter(Filters.reject(PROP_OCCS_TO_ASSIST, PROP_ASSIST_ORDER, PROP_ASSIST_ALL)).collect(Collectors.toList());
    public static final Set<Object> PROP_TYPES = new HashSet(ALL_PROPS);
    private PropertySet d_props = new PropertySet();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public String getName() {
        return this.getProperty(PROP_NAME);
    }

    @Override
    public void setName(String name) {
        this.setProperty(PROP_NAME, name);
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof AssistedEvacTeam)) {
            return;
        }
        AssistedEvacTeam aeTeam = (AssistedEvacTeam)obj;
        this.d_props = aeTeam.d_props;
        this.changedEvt(new Object[0]);
    }

    @Override
    public AssistedEvacTeam clone() {
        AssistedEvacTeam clone = (AssistedEvacTeam)super.clone();
        clone.d_props = this.d_props.clone();
        List<EgressAgent> occsToAssist = this.getProperty(PROP_OCC_ASSIST_ORDER);
        clone.setProperty(PROP_OCC_ASSIST_ORDER, new ArrayList<EgressAgent>(occsToAssist));
        return clone;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            this.setProperty((IPropertySet.Prop)property, value);
        }
    }

    public <T> void setProperty(IPropertySet.Prop<T> prop, T value) {
        this.d_props.set(prop, value);
        this.changedEvt(prop);
    }

    @Override
    public Object getProperty(Object property) {
        if (property instanceof IPropertySet.Prop) {
            return this.getProperty((IPropertySet.Prop)property);
        }
        return NOT_SUPPORTED;
    }

    public <T> T getProperty(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    public <T> T removeProperty(IPropertySet.Prop<T> prop) {
        T val = this.getProperty(prop);
        this.d_props.remove(prop);
        return val;
    }

    public String toString() {
        return this.getName();
    }

    public static void removeAgentsFromAssistedEvacTeams() {
        MerlinData md = MerlinApp.getApp().getData();
        Collection<AssistedEvacTeam> teams = md.assistedEvacTeams.getDeepMembers(AssistedEvacTeam.class);
        Undo.insertUndoEntry_restore(md, teams);
        teams.forEach(team -> {
            List<EgressAgent> occsToAssist = team.getProperty(PROP_OCC_ASSIST_ORDER);
            List filteredOccs = occsToAssist.stream().filter(occ -> occ.getAssistanceDesired()).collect(Collectors.toList());
            team.setProperty(PROP_OCC_ASSIST_ORDER, filteredOccs);
        });
    }

    public static void removeAgentsFromAssistedEvacTeams(Collection<EgressAgent> selectedAgents, boolean removeAll) {
        Consumer<List> remove;
        MerlinData md = MerlinApp.getApp().getData();
        Collection<AssistedEvacTeam> teams = md.assistedEvacTeams.getDeepMembers(AssistedEvacTeam.class);
        Undo.insertUndoEntry_restore(md, teams);
        if (removeAll) {
            remove = occsToAssist -> occsToAssist.clear();
        } else {
            Predicate filter = Filters.accept(selectedAgents instanceof Set ? selectedAgents : new IdentityHashSet(selectedAgents));
            remove = occsToAssist -> occsToAssist.removeIf(filter);
        }
        teams.forEach(team -> {
            List<EgressAgent> occsToAssist = team.getProperty(PROP_OCC_ASSIST_ORDER);
            remove.accept(occsToAssist);
            team.setProperty(PROP_OCC_ASSIST_ORDER, occsToAssist);
        });
    }

    public void addOccsToAssist(List<EgressAgent> occs) {
        List<EgressAgent> occList = this.getProperty(PROP_OCC_ASSIST_ORDER);
        occs.forEach(occ -> {
            if (!occList.contains(occ)) {
                occList.add((EgressAgent)occ);
            }
        });
        this.setProperty(PROP_OCC_ASSIST_ORDER, occList);
    }
}

