/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.geomops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressRoom;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class SubtractGeom
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SubtractGeom(), Intl.intl("&Subtract,T,Subtract the Selected Rooms...,Subtract the last selected rooms from the first in the selection."));

    public SubtractGeom() {
        SelectionObserver.add(this, EgressRoom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        Set rooms = md.selection.getDeepSelected(EgressRoom.class);
        this.setEnabled(rooms.size() >= 2);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Set<EgressRoom> subtractFrom = md.selection.getDeepSelected(EgressRoom.class);
        if (subtractFrom.size() < 2) {
            return;
        }
        int selOption = JOptionPane.showConfirmDialog(app.getMainFrame(), Intl.intl("Would you like to delete the subtracted rooms?"), Intl.intl("Delete subtracted rooms?"), 1);
        if (selOption != 0 && selOption != 1) {
            return;
        }
        boolean deleteSubtracted = selOption == 0;
        EgressRoom first = (EgressRoom)subtractFrom.iterator().next();
        subtractFrom.remove(first);
        this.subtract(md, Arrays.asList(first), subtractFrom, deleteSubtracted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subtract(MerlinData md, Collection<EgressRoom> subtractFrom, Set<EgressRoom> toSubtract, boolean deleteSubtracted) {
        toSubtract.removeAll(subtractFrom);
        if (toSubtract.isEmpty()) {
            return;
        }
        md.beginWrite();
        try {
            Undo.begin(Intl.intl("Subtract"));
            ArrayList<EgressRoom> toClean = new ArrayList<EgressRoom>();
            for (EgressRoom subtract : subtractFrom) {
                if (!subtract.getModificationsAllowed()) continue;
                Object momento = subtract.getRestoreObj();
                Undo.insertUndoEntry_restore(md, subtract, momento, false);
                boolean modified = false;
                for (EgressRoom toSub : toSubtract) {
                    modified |= subtract.sub(toSub);
                }
                if (!modified) continue;
                toClean.add(subtract);
            }
            if (deleteSubtracted) {
                Undo.insertUndoEntry_add(md, toSubtract);
                for (EgressRoom toSub : toSubtract) {
                    Composite parent = (Composite)md.hierarchy.getParent(toSub);
                    parent.remove(toSub);
                }
            }
            EgressRoom.cleanup(md, toClean);
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }
}

