/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.floorextract;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.CancelledException;
import merlin.actions.SubtractAction;
import merlin.actions.Undo;
import merlin.data.GeomComposite;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.geom.EgressRoom;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.guiInputDlg;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theUtil;

public class ExtractFloor2DSel
extends AMerlinOp {
    private static final int STEP_ADDING_CURVES = 0;
    private static final int STEP_ADDING_ROOMS = 1;
    private final TaskProgress d_progress = new TaskProgress();
    private int d_step = 0;

    public ExtractFloor2DSel() {
        this.setEnabled(false);
    }

    public TaskProgress getProgress() {
        return this.d_progress;
    }

    protected void updateProgress(int curr) throws CancelledException {
        TaskProgress prog = this.getProgress();
        prog.setProgress(curr);
        int[] progress = prog.getProgress();
        String msg = "";
        if (progress != null) {
            switch (this.d_step) {
                case 0: {
                    msg = String.format(Intl.intl("Step 1: Adding curve %d / %d"), progress[0], progress[1]);
                    break;
                }
                case 1: {
                    msg = String.format(Intl.intl("Step 2: Adding room %d / %d"), progress[0], progress[1]);
                }
            }
        }
        prog.setMessage(msg);
        super.checkCancelled(prog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        UnitDouble zLoc = guiInputDlg.getUnitDouble(app.getMainFrame(), Intl.intl("Enter Z Location"), Intl.intl("Enter the z location on which to place the extracted rooms."), new UnitDouble(0.0, SI.METER));
        if (zLoc == null) {
            return;
        }
        long begin = System.nanoTime();
        this.d_progress.reset();
        guiProgressMonitor pm = new guiProgressMonitor(app.getMainFrame(), Intl.intl("Extracting Room"), true, this.d_progress);
        pm.begin();
        try {
            this.extract(app, md, zLoc);
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            pm.end();
        }
        long end = System.nanoTime();
        System.out.println("Extraction took " + (double)(end - begin) * 1.0E-9 + " s");
    }

    private static Collection<ImportedGeom> getSelGeom(MerlinData md, boolean searchHidden) {
        Set<ImportedGeom> selected = md.selection.getDeepSelected(ImportedGeom.class);
        if (selected.isEmpty()) {
            return selected;
        }
        IFilteredCollection<ImportedGeom> geom = theUtil.filter(selected, new ObjFilter(md, searchHidden));
        return geom;
    }

    private void extract(MerlinApp app, MerlinData md, UnitDouble zLoc) throws CancelledException {
        boolean searchHidden = true;
        this.d_step = 0;
        Collection<ImportedGeom> geom = ExtractFloor2DSel.getSelGeom(md, true);
        Model model = this.extractModel(md, geom, true, zLoc);
        if (model == null) {
            return;
        }
        this.d_step = 1;
        this.addRooms(app, md, model, zLoc);
    }

    public static Model getStartModel(AABox bounds, double zLoc, int faceid) {
        if (!bounds.isValid()) {
            return null;
        }
        Point3d min = bounds.getMin();
        Point3d max = bounds.getMax();
        double dist = new Point2d(min.x, min.y).distance(new Point2d(max.x, max.y));
        if (dist == 0.0) {
            return null;
        }
        Quad poly = new Quad(new Point3d(min.x - (dist *= 0.05), min.y - dist, zLoc), new Point3d(max.x + dist, min.y - dist, zLoc), new Point3d(max.x + dist, max.y + dist, zLoc), new Point3d(min.x - dist, max.y + dist, zLoc));
        Model model = new Model();
        GeomUtil.addFaceToModel(poly, model, faceid, 0.0, 0.0);
        return model;
    }

    private Model extractModel(MerlinData md, Collection<ImportedGeom> geom, boolean searchHidden, UnitDouble z) throws CancelledException {
        if (geom.isEmpty()) {
            return null;
        }
        double zLoc = z.getValue(Geometry.LENGTH_UNIT);
        AABox bounds = new AABox();
        for (ImportedGeom obj : geom) {
            bounds.add(obj.getBounds());
        }
        Model model = ExtractFloor2DSel.getStartModel(bounds, zLoc, 0);
        if (model == null) {
            return null;
        }
        ITransform projectionXform = TransformUtil.translate(0.0, 0.0, zLoc).concatenate(TransformUtil.scale(1.0, 1.0, 0.0));
        TransformInfo ti = projectionXform.getInfo();
        this.getProgress().setMax(geom.size());
        int ix = 1;
        for (ImportedGeom obj : geom) {
            this.updateProgress(ix++);
            if (!searchHidden && !md.isVisible(obj)) continue;
            for (LineSeg ls : thunderheadeng.geometry.objs.GeomUtil.convertToLineSegs(md.simParams.edgeError, obj.getGeom().flatten().getLocalGeom())) {
                ls = ls.transform(ti, 0);
                GeomUtil.addCurveToModel(ls, model, 0, 0.0);
            }
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRooms(MerlinApp app, MerlinData md, Model model, UnitDouble zLoc) throws CancelledException {
        if (model.getFaces().isEmpty()) {
            return;
        }
        md.beginWrite();
        try {
            Undo.begin(Intl.intl("Extract Room"));
            int[] boundGroup = new int[]{1};
            int[] nonBoundGroup = new int[]{0};
            for (Edge edge : model.getEdges()) {
                edge.groups = ExtractFloor2DSel.isBoundaryEdge(edge) ? boundGroup : nonBoundGroup;
            }
            for (Vertex vert : model.getVerts()) {
                vert.groups = nonBoundGroup;
            }
            LinkedIdentityHashSet<EgressRoom> newRooms = new LinkedIdentityHashSet<EgressRoom>(model.getFaces().size());
            GeomComposite group = new GeomComposite(Intl.intl("2D Room Extraction"));
            this.getProgress().setMax(model.getFaces().size());
            int faceix = 1;
            for (Face face : model.getFaces()) {
                this.updateProgress(faceix++);
                face.groups = nonBoundGroup;
                Model roomMod = new Model();
                roomMod.addFace(face, new int[0]);
                EgressRoom room = new EgressRoom(md.roomNameGen.getCurrentName(), roomMod);
                room.setColor(theUtil.newRandomColor());
                md.roomNameGen.nextName();
                newRooms.add(room);
            }
            ArrayList toClean = new ArrayList(newRooms);
            SubtractAction.subtract(app, md, 0, toClean::add, newRooms);
            group.addAll(newRooms);
            Floor floor = md.floors.getFloor(zLoc);
            if (floor == null) {
                floor = new Floor(zLoc);
                floor.add(group);
                Undo.insertUndoEntry_delete(md, md.floors, floor);
                md.floors.add(floor);
            } else {
                Undo.insertUndoEntry_delete(md, floor, group);
                floor.add(group);
            }
            EgressRoom.cleanup(md, toClean);
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }

    private static boolean isBoundaryEdge(Edge edge) {
        return edge.partOfGroup(0) && !edge.faces.isEmpty() || !edge.partOfGroup(0) && edge.faces.size() == 1;
    }

    private static Collection<Edge> getBoundaryEdges(Model model) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : model.getEdges()) {
            if (!ExtractFloor2DSel.isBoundaryEdge(edge)) continue;
            edges.add(edge);
        }
        return edges;
    }

    private static void createEdgeTestGeom(MerlinData md, String name, Collection<Edge> edges) {
        ArrayList<ImportedGeom> lines = new ArrayList<ImportedGeom>(edges.size());
        for (Edge edge : edges) {
            LineSeg line = new LineSeg(edge.v1.loc, edge.v2.loc);
            UniformProps src = new UniformProps(new IPrimProps.Edge(Color.RED, 2.0, IPrimProps.DEF_STIPPLE, 0));
            lines.add(new ImportedGeom("", new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(line), src)));
        }
        ExtractFloor2DSel.addTestGeom(md, name, lines);
    }

    private static void addTestGeom(MerlinData md, String name, Collection<? extends ImportedGeom> geom) {
        if (!geom.isEmpty()) {
            GeomComposite geomGroup = new GeomComposite(name);
            geomGroup.addAll(geom);
            TransformInfo xform = TransformUtil.translate(0.0, 0.0, 0.01).getInfo();
            for (ImportedGeom importedGeom : geom) {
                importedGeom.transform(xform);
            }
            Undo.begin(Intl.intl("Extract Room"));
            Undo.insertUndoEntry_delete(md, md.sceneGeom, geomGroup);
            md.sceneGeom.add(geomGroup);
            Undo.end(md);
        }
    }

    private static class ObjFilter
    implements Predicate<ImportedGeom> {
        public final MerlinData d_md;
        public final boolean d_searchHidden;

        public ObjFilter(MerlinData md, boolean searchHidden) {
            this.d_md = md;
            this.d_searchHidden = searchHidden;
        }

        @Override
        public boolean test(ImportedGeom o) {
            if (o.isIgnoredInModelGeneration()) {
                return false;
            }
            int numCurves = o.getGeom().getNumPrims(2);
            boolean keep = numCurves > 0 && (this.d_searchHidden || this.d_md.isVisible(o));
            return keep;
        }
    }
}

