/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.copypaste.DefaultPasteHandler;
import merlin.actions.copypaste.FloorPasteHandler;
import merlin.actions.copypaste.GeomPasteHandler;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHints;
import merlin.actions.copypaste.PthCopyDataContainer;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.camera.CameraList;
import merlin.data.egress.FloorComposite;
import merlin.mv.gui.LocationPanel;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class Paste
extends AMerlinOp
implements IEventObserver {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Paste16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Paste(), Intl.intl("&Paste...,V,Paste selected objects"), ICON);

    public Paste() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
        Toolkit.getDefaultToolkit().getSystemClipboard().addFlavorListener(flavorEvent -> this.update(null));
    }

    public boolean canPaste(Map<IDomainObject, String> payload) {
        return !payload.isEmpty() && !payload.entrySet().stream().allMatch(entry -> Paste.isUnsupported((IDomainObject)entry.getKey(), (String)entry.getValue()));
    }

    public static boolean isUnsupported(IDomainObject obj, String mdRootClassName) {
        List<String> supportedRoots = Arrays.asList(CameraList.class.getName(), FloorComposite.class.getName(), GeomComposite.class.getName());
        return obj == null || !supportedRoots.contains(mdRootClassName);
    }

    private Map<IDomainObject, String> getClipboardPayload(MerlinApp app, MerlinData md) {
        block5: {
            Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
            Clipboard systemClipboard = defaultToolkit.getSystemClipboard();
            try {
                if (systemClipboard.isDataFlavorAvailable(PthCopyDataContainer.DATAFLAVOR_BINARY)) {
                    try {
                        Object clipboardData = systemClipboard.getData(PthCopyDataContainer.DATAFLAVOR_BINARY);
                        PthCopyDataContainer pasteData = PthCopyDataContainer.deserialize((byte[])clipboardData);
                        return pasteData.getObjs();
                    }
                    catch (UnsupportedFlavorException | IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IllegalStateException e) {
                if ("cannot open system clipboard".equals(e.getMessage())) break block5;
                e.printStackTrace();
            }
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Warning> performPaste(MerlinData md, MerlinApp app, Map<IDomainObject, String> payload) {
        PasteHandler[] handlers = new PasteHandler[]{new GeomPasteHandler(), new FloorPasteHandler(), new DefaultPasteHandler()};
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        md.beginRead();
        Map<IDomainObject, Pair<PasteHandler, PasteHints>> handlerMap = Paste.preparePasteHandlers(md, app.getMainFrame(), handlers, payload, warnings);
        md.endRead();
        Undo.begin(Intl.intl("Paste"));
        md.beginWrite();
        try {
            Paste.processPasteObjs(md, app, handlerMap, payload, warnings);
        }
        finally {
            md.endWrite();
            Undo.end(md);
        }
        return warnings;
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Map<IDomainObject, String> payload = this.getClipboardPayload(app, md);
        Collection<Warning> warnings = this.performPaste(md, app, payload);
        this.showWarnings(app, warnings);
    }

    public void showWarnings(MerlinApp app, Collection<Warning> warnings) {
        if (warnings.isEmpty()) {
            return;
        }
        WarningReport<Warning> rpt = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
        warnings.stream().forEachOrdered(rpt::addWarning);
        WarningDlg warnDlg = WarningDlg.create(app.getMainFrame(), Intl.intl("Warnings"), "", rpt);
        warnDlg.doModal();
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData md = app.getData();
        Map<IDomainObject, String> payload = this.getClipboardPayload(app, md);
        this.setEnabled(this.canPaste(payload));
    }

    public static Map<IDomainObject, Pair<PasteHandler, PasteHints>> preparePasteHandlers(MerlinData md, Window dlgParent, PasteHandler[] handlers, Map<IDomainObject, String> pasteObjMap, Collection<Warning> warnings) {
        boolean shouldPromptForTransform = false;
        HashMap<IDomainObject, Pair<PasteHandler, PasteHints>> handlerMap = new HashMap<IDomainObject, Pair<PasteHandler, PasteHints>>();
        for (Map.Entry<IDomainObject, String> mapEntry : pasteObjMap.entrySet()) {
            String mdRootClassName;
            IDomainObject obj = mapEntry.getKey();
            if (Paste.isUnsupported(obj, mdRootClassName = mapEntry.getValue())) {
                String name = String.format("%s:%s", ((INamed)((Object)obj)).getName(), obj.getClass().getSimpleName());
                warnings.add(new Warning(name, Intl.intl("Object is ignored when generating model elements.")));
                System.err.printf("[WARN] [%s] unsupported object skipped: %s%n", Paste.class.getName(), obj);
                continue;
            }
            Optional<Object> result = Optional.empty();
            for (PasteHandler ph : handlers) {
                if (!ph.isHandlerFor(obj, mdRootClassName)) continue;
                result = Optional.of(ph);
                break;
            }
            if (result.isPresent()) {
                PasteHandler ph = (PasteHandler)result.get();
                PasteHints hints = ph.getPasteHints(md, pasteObjMap, obj);
                shouldPromptForTransform |= hints.geomTransformShouldPrompt;
                handlerMap.put(obj, new Pair<PasteHandler, PasteHints>(ph, hints));
                continue;
            }
            String name = String.format("%s:%s", ((INamed)((Object)obj)).getName(), obj.getClass().getSimpleName());
            warnings.add(new Warning(name, Intl.intl("Object is ignored when generating model elements.")));
            System.err.printf("[WARN] [%s] unsupported object skipped: %s%n", Paste.class.getName(), obj);
        }
        if (shouldPromptForTransform) {
            TransformInfo moveInfo = Paste.promptForTransformParameter(dlgParent, md);
            handlerMap.values().forEach(pair -> {
                ((PasteHints)pair.v2).geomTransform = moveInfo;
            });
        }
        return handlerMap;
    }

    public static void processPasteObjs(MerlinData md, MerlinApp app, Map<IDomainObject, Pair<PasteHandler, PasteHints>> handlerMap, Map<IDomainObject, String> pasteObjMap, Collection<Warning> warnings) {
        HashSet<IDomainObject> objsToSelect = new HashSet<IDomainObject>();
        Set selectedCompositesIntenseGenerics = md.selection.getSelected(Composite.class);
        Collection selectedComposites = selectedCompositesIntenseGenerics;
        Set<IMerlinObj> selectedLeaves = md.selection.getSelected(IMerlinObj.class);
        for (Map.Entry<IDomainObject, String> pasteObjMapEntry : pasteObjMap.entrySet()) {
            Pair<PasteHandler, PasteHints> handlerPair = handlerMap.get(pasteObjMapEntry.getKey());
            if (handlerPair == null) continue;
            PasteHandler handler = (PasteHandler)handlerPair.v1;
            PasteHints hints = (PasteHints)handlerPair.v2;
            handler.pasteApply(md, app, pasteObjMap, pasteObjMapEntry, hints, objsToSelect, selectedComposites, selectedLeaves, warnings);
        }
        md.selection.set(objsToSelect);
    }

    private static TransformInfo promptForTransformParameter(Window dlgParent, MerlinData md) {
        Callable<TransformInfo> uiFunc = () -> {
            int option = JOptionPane.showConfirmDialog(dlgParent, Intl.intl("Geometry intersection detected.\nOffset pasted geometry?"), Intl.intl("Paste Offset"), 0);
            if (option != 0) {
                return TransformUtil.IDENTITY_INFO;
            }
            guiDialog dlg = new guiDialog(dlgParent, Intl.intl("Offset"), 1);
            LocationPanel panel = new LocationPanel();
            dlg.getDialogPane().add(panel, "Center");
            if (dlg.doModal() == 1) {
                UnitPoint3D xformUpt3d = panel.getValue();
                Point3d xformMeters = xformUpt3d.getValue(SI.METER);
                ITransform xform = TransformUtil.translate(xformMeters.x, xformMeters.y, xformMeters.z);
                return xform.getInfo();
            }
            return TransformUtil.IDENTITY_INFO;
        };
        return md.ui(uiFunc);
    }
}

