/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.util.Collection;
import java.util.Map;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHandlerUtil;
import merlin.actions.copypaste.PasteHints;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.camera.CameraList;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Warning;

public class DefaultPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootField) {
        return CameraList.class.getName().equals(mdRootField);
    }

    @Override
    public PasteHints getPasteHints(MerlinData md, Map<IDomainObject, String> pasteObjMap, IDomainObject pasteObj) {
        return new PasteHints();
    }

    @Override
    public void pasteApply(MerlinData md, MerlinApp app, Map<IDomainObject, String> pasteObjMap, Map.Entry<IDomainObject, String> pasteEntry, PasteHints hints, Collection<IDomainObject> selectAccum, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves, Collection<Warning> warnings) {
        Composite<ICompElement> defaultRoot;
        IDomainObject pasteObj = pasteEntry.getKey();
        Composite insertRoot = PasteHandlerUtil.getBestPasteTarget(md, pasteObj, defaultRoot = PasteHandlerUtil.getDefaultRoot(md, pasteEntry), selectedComposites, selectedLeaves);
        if (insertRoot == null) {
            warnings.add(new Warning(pasteObj.getClass().getSimpleName(), Intl.intl("Object is ignored when generating model elements.")));
            System.err.printf("[WARN] [%s] unable to find valid insert location: %s%n", this.getClass().getName(), pasteObj);
            return;
        }
        Collection<INamed> nameSibs = insertRoot.getMembers(INamed.class);
        PasteHandlerUtil.renamePasteObj(nameSibs, pasteObj);
        PasteHandlerUtil.pasteInto(md, insertRoot, pasteEntry);
        selectAccum.add(pasteObj);
    }
}

