/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.image.BGImage;
import merlin.gui.guiUtil;
import thunderheadeng.cad.out.TeciGeomWriter;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.geom.DisplayGeom;

public class WriteVis
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new WriteVis(), Intl.intl("Save Imported Geometry file...,-,Write Imported Geometry file"));

    @Override
    public void run(MerlinApp app, MerlinData md) {
        File f = guiUtil.getSaveFile(app, md, MerlinPrefs.OPEN_DIR_PREF, md.getNewFilename(".geom"), "geom", Intl.intl("Egress Geom Files"));
        if (f == null) {
            return;
        }
        try {
            WriteVis.writeVis(md, f, true);
        }
        catch (IOException e) {
            guiUtil.showError(app, Intl.intl("Geom File Error"), Intl.intl("Could not create file"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeVis(MerlinData md, File f, boolean force) throws IOException {
        md.beginRead();
        try {
            Collection<BGImage> bgImages = md.sceneGeom.getDeepMembers(BGImage.class);
            Collection<ImportedGeom> geoms = md.sceneGeom.getDeepMembers(ImportedGeom.class);
            Collection displays = geoms.stream().map(GeomWrapper::new).collect(Collectors.toList());
            Collection bgWrappers = bgImages.stream().map(BGWrapper::new).collect(Collectors.toList());
            if (!force && displays.isEmpty() && bgWrappers.isEmpty()) {
                f.delete();
                boolean bl = false;
                return bl;
            }
            TeciGeomWriter.writeVis(f, new TeciGeomWriter.Options(MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_EDGE_ERROR), MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_FACE_ERROR)), displays, bgWrappers);
            boolean bl = true;
            return bl;
        }
        finally {
            md.endRead();
        }
    }

    private static class BGWrapper
    implements TeciGeomWriter.BGImage {
        public final BGImage img;

        public BGWrapper(BGImage img) {
            this.img = img;
        }

        @Override
        public Matrix4d getLWXform() {
            return this.img.getLWXform();
        }

        @Override
        public float getOpacity() {
            return this.img.getOpacity();
        }

        @Override
        public String getName() {
            return this.img.getName();
        }

        @Override
        public IImage getImage() {
            return this.img.getImage();
        }
    }

    private static class GeomWrapper
    implements TeciGeomWriter.IObject {
        public final ImportedGeom ig;

        public GeomWrapper(ImportedGeom ig) {
            this.ig = ig;
        }

        @Override
        public DisplayGeom getDisplay() {
            return this.ig.getDisplayGeom();
        }

        @Override
        public String getName() {
            return this.ig.getName();
        }

        @Override
        public TeciGeomWriter.Type getType() {
            return TeciGeomWriter.Type.GENERIC;
        }

        @Override
        public Collection<Integer> getFDSRepIds() {
            return Collections.emptyList();
        }
    }
}

