/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.gui.guiUtil;
import thunderheadeng.gui.OutputLog;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.FilenameManager;

public class SaveOutputLogAction
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new SaveOutputLogAction(), Intl.intl("Save Output &Log..."), 64);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        String filename;
        md.beginRead();
        try {
            filename = md.filename;
        }
        finally {
            md.endRead();
        }
        if (filename == null) {
            filename = "log.txt";
        } else {
            String[] fn = FilenameManager.splitFilename(filename);
            filename = fn[0] + "_log.txt";
        }
        File f = guiUtil.getSaveFile(app, md, MerlinPrefs.OPEN_DIR_PREF, filename, "txt", Intl.intl("Text Document"));
        if (f == null) {
            return;
        }
        try {
            System.out.printf("Copying log file to: %s%n", f.getAbsolutePath());
            CopyFile.copy(OutputLog.logFile, f);
        }
        catch (IOException e) {
            e.printStackTrace();
            md.ui(() -> JOptionPane.showMessageDialog(app.getMainFrame(), e.getLocalizedMessage()));
        }
    }
}

