/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.BehaviorRoot;
import merlin.data.egress.scripting.GotoExits;
import merlin.gui.NewDlg;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class NewBehavior
extends AMerlinOp
implements IEventObserver {
    public static final UIHook MENU_HOOK = new UIHook(new NewBehavior(true), Intl.intl("Add a Behavior..."));
    public static final UIHook CONTEXT_HOOK = new UIHook(new NewBehavior(false), Intl.intl("Add a Behavior..."));
    private final boolean d_mainMenu;

    public NewBehavior(boolean mainMenu) {
        this.d_mainMenu = mainMenu;
        if (!this.d_mainMenu) {
            SelectionObserver.add(this, IMerlinObj.class);
            this.update(null);
        }
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(md.selection.isSingleExclusive(BehaviorRoot.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        Behavior newBehavior = null;
        md.beginRead();
        try {
            NewDlg<Behavior> nd = new NewDlg<Behavior>(app.getActiveFrame(), md, Intl.intl("New Behavior"), Intl.intl("Behavior"), Behavior.class);
            if (nd.doModal() != 1) {
                return;
            }
            String name = nd.getName();
            Behavior baseBehavior = nd.getBaseObject();
            newBehavior = baseBehavior != null ? new Behavior(name, baseBehavior) : new Behavior(name, new GotoExits());
        }
        finally {
            md.endRead();
        }
        md.beginWrite();
        try {
            Undo.begin(Intl.intl("New Behavior"));
            Undo.insertUndoEntry_delete(md, md.behaviors, newBehavior);
            md.behaviors.add(newBehavior);
            md.selection.clear();
            md.selection.select(newBehavior);
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }
}

