/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.CreateGroupsAction;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.OccGroupObj;
import merlin.data.egress.agents.EgressAgent;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class CreateSingleGroupAction
extends AMerlinOp
implements IEventObserver {
    public static final String actionName = Intl.intl("New Movement Group from Selection");
    public static final UIHook UI_HOOK = new UIHook(new CreateSingleGroupAction(), actionName);

    public CreateSingleGroupAction() {
        SelectionObserver.add(this, EgressAgent.class);
        this.update(null);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        md.beginRead();
        Set<EgressAgent> agents = md.selection.getDeepSelected(EgressAgent.class);
        if (!CreateGroupsAction.verifySingleBehavior(agents, app)) {
            md.endRead();
            return;
        }
        md.endRead();
        md.beginWrite();
        OccGroupObj newGroup = OccGroupObj.newGroup(md.occGroupNameGen.nextName(), agents, null, null);
        Undo.begin(actionName);
        AddObject.add((MerlinData)md, (Composite)md.occGroups, (int)md.occGroups.getChildren().size(), (ICompElement[])new OccGroupObj[]{newGroup});
        Undo.end(md);
        md.endWrite();
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isDeepEmpty(EgressAgent.class));
    }
}

