/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.CancelledException;
import merlin.actions.OccGenerator;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IOccArea;
import merlin.data.egress.agents.IOccCount;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccupancySpec;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.gui.OccupancyPanel;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.theUtil;

public class AddOccupants
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new AddOccupants(), Intl.intl("&Add Occupants...,-,Add occupants to the selected rooms."));
    private Random d_rgen = new Random(0L);
    public static final UnitDouble searchTimeout = new UnitDouble(0.125, SI.SECOND);
    public static final int maxNumTries = 200;
    private final NameGenerator d_nameGenerator = new NameGenerator(Intl.intl("AddToRoomTool") + "_");

    public AddOccupants() {
        SelectionObserver.add(this, IEgressOccupiable.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(!md.selection.isDeepEmpty(IEgressOccupiable.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        Set selGeom;
        md.beginRead();
        try {
            selGeom = md.selection.getDeepSelected(IEgressOccupiable.class);
            if (selGeom.isEmpty()) {
                return;
            }
        }
        finally {
            md.endRead();
        }
        OccupancyPanel occPanel = OccupancyPanel.getOccupancyPanel(app, md);
        int dlgResponse = md.ui(() -> {
            guiDialog dlg = new guiDialog((Window)app.getMainFrame(), Intl.intl("Add Occupants"), 9);
            dlg.getDialogPane().setLayout(new BorderLayout());
            dlg.getDialogPane().add((Component)occPanel, "Center");
            return dlg.doModal();
        });
        if (dlgResponse == 1) {
            IUrn<OccProfile> profDist = occPanel.getProfileDist();
            IUrn<Behavior> behaviorDist = occPanel.getBehaviorDist();
            String newGroupName = this.d_nameGenerator.generateName();
            this.d_nameGenerator.registerName(newGroupName);
            AddOccupants.addOccupants(app, md, this.d_rgen, searchTimeout, 200, OccGenerator.getModels(selGeom), occPanel.get(), profDist, behaviorDist, newGroupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOccupants(MerlinApp app, MerlinData md, Random rgen, UnitDouble searchTimeout, int maxNumTries, Collection<Model> geometry, OccupancySpec spec, IUrn<OccProfile> profDist, IUrn<Behavior> behaviorDist, String newGroupName) {
        Collection<EgressAgent> agents;
        md.beginRead();
        try {
            UnitDouble maxDiam = OccGenerator.getMaxDiam(profDist);
            OccGenerator occgen = new OccGenerator(md, rgen, geometry, maxDiam, searchTimeout, maxNumTries, profDist, behaviorDist);
            AddOccupants.generateOccupants(app, md, occgen, spec);
            agents = occgen.finalizeData();
        }
        catch (CancelledException e) {
            return;
        }
        finally {
            md.endRead();
        }
        md.beginWrite();
        try {
            Undo.begin(Intl.intl("New Occupants"));
            OccGenerator.distributeAgents(md, agents, newGroupName);
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void generateOccupants(MerlinApp app, MerlinData md, OccGenerator occgen, OccupancySpec spec) throws CancelledException {
        long numOccs;
        IOccCount count = spec.getOccCount();
        if (count instanceof ConstOccCount) {
            numOccs = ((ConstOccCount)count).count;
        } else {
            IOccArea oa = (IOccArea)count;
            double density = oa.getArea().getValue(SIUS.unit(2));
            numOccs = Math.round(occgen.getTotalArea() / density);
        }
        numOccs = Math.min(numOccs, Integer.MAX_VALUE);
        int maxNumOccs = occgen.getMaxNumOccs();
        if (numOccs > 0L && maxNumOccs <= 0) {
            JOptionPane.showMessageDialog(app.getActiveFrame(), Intl.intl("There is insufficient space to place any occupants."), Intl.intl("Insufficient space"), 0);
            throw CancelledException.INSTANCE;
        }
        int spacing = spec.getSpacing();
        int genOptions = 0;
        if (numOccs > (long)maxNumOccs) {
            if (spacing == 1) {
                String title = Intl.intl("Occupant Error");
                String msg = String.format(Intl.intl("The specified area cannot support the requested occupant density\nwithout overlapping occupants. What action would you like to take?"), new Object[0]);
                String ADD_MAX_UNIFORM = Intl.intl("Uniformly add as many occupants as possible without overlapping");
                String ADD_MAX_RANDOM = Intl.intl("Randomly add as many occupants as possible without overlapping");
                String ADD_RANDOM_OVERLAP = Intl.intl("Add at the requested density, allowing overlap");
                Object[] options = new Object[]{ADD_RANDOM_OVERLAP, ADD_MAX_UNIFORM, ADD_MAX_RANDOM};
                Object choice = JOptionPane.showInputDialog(app.getActiveFrame(), msg, title, 3, null, options, ADD_RANDOM_OVERLAP);
                if (theUtil.equal(choice, ADD_MAX_RANDOM)) {
                    occgen.generate((int)numOccs, spacing, 0);
                    return;
                }
                if (theUtil.equal(choice, ADD_MAX_UNIFORM)) {
                    occgen.generate((int)numOccs, 0, 0);
                    return;
                }
                if (!theUtil.equal(choice, ADD_RANDOM_OVERLAP)) throw CancelledException.INSTANCE;
                genOptions = 1;
            } else {
                String title = Intl.intl("Occupant Error");
                String msg = String.format(Intl.intl("The specified area cannot support the requested occupant density\nwithout overlapping occupants. What action would you like to take?"), new Object[0]);
                String ADD_MAX = Intl.intl("Add as many occupants as possible without overlapping");
                String ADD_OVERLAP = Intl.intl("Add at the requested density, allowing overlap");
                Object[] options = new Object[]{ADD_OVERLAP, ADD_MAX};
                Object choice = JOptionPane.showInputDialog(app.getActiveFrame(), msg, title, 3, null, options, ADD_OVERLAP);
                if (theUtil.equal(choice, ADD_MAX)) {
                    occgen.generate((int)numOccs, 0, 0);
                    return;
                }
                if (!theUtil.equal(choice, ADD_OVERLAP)) throw CancelledException.INSTANCE;
                genOptions = 1;
            }
        }
        AddOccupants.generate(app, occgen, (int)numOccs, spacing, genOptions);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void generate(MerlinApp app, OccGenerator occgen, int numOccs, int spacing, int genOpts) throws CancelledException {
        block11: {
            occgen.generate(numOccs, spacing, genOpts);
            int desiredCount = numOccs;
            if (occgen.getNumOccupants() < desiredCount) {
                String msg;
                String title;
                if (spacing == 1) {
                    title = Intl.intl("Occupant Error");
                    msg = String.format(Intl.intl("Could not randomly place %d occupants in requested area.\nWhat action would you like to take?"), numOccs);
                    String USE_UNIFORM = Intl.intl("Try again using uniform spacing");
                    String ALLOW_OVERLAP = Intl.intl("Add remaining occupants, allowing them to overlap");
                    String KEEP_GENERATED = String.format(Intl.intl("Keep %d generated occupants"), occgen.getNumOccupants());
                    Object[] options = new Object[]{USE_UNIFORM, ALLOW_OVERLAP, KEEP_GENERATED};
                    Object choice = JOptionPane.showInputDialog(app.getActiveFrame(), msg, title, 3, null, options, USE_UNIFORM);
                    if (theUtil.equal(choice, USE_UNIFORM)) {
                        occgen.reset();
                        AddOccupants.generate(app, occgen, numOccs, 0, 0);
                        return;
                    }
                    if (theUtil.equal(choice, ALLOW_OVERLAP)) {
                        occgen.generate(numOccs - occgen.getNumOccupants(), spacing, 1);
                        break block11;
                    } else {
                        if (theUtil.equal(choice, KEEP_GENERATED)) {
                            return;
                        }
                        throw CancelledException.INSTANCE;
                    }
                }
                title = Intl.intl("Occupant Error");
                msg = String.format(Intl.intl("Could not uniformly place %d occupants in requested area.\nWhat action would you like to take?"), numOccs);
                String ALLOW_OVERLAP = Intl.intl("Add remaining occupants, allowing them to overlap");
                String ADD_MAX = Intl.intl("Add as many occupants as possible without overlapping");
                Object[] options = new Object[]{ADD_MAX, ALLOW_OVERLAP};
                Object choice = JOptionPane.showInputDialog(app.getActiveFrame(), msg, title, 3, null, options, ADD_MAX);
                if (theUtil.equal(choice, ADD_MAX)) {
                    return;
                }
                if (!theUtil.equal(choice, ALLOW_OVERLAP)) {
                    throw CancelledException.INSTANCE;
                }
                occgen.reset();
                occgen.generate(numOccs, spacing, 1);
            }
        }
        if (occgen.getNumOccupants() < numOccs) {
            String msg;
            if (occgen.getNumOccupants() == 0) {
                msg = String.format(Intl.intl("There is insufficient space to place any occupants."), new Object[0]);
                JOptionPane.showMessageDialog(MerlinApp.getApp().getMainFrame(), msg, Intl.intl("Insufficient Space"), 0);
                throw CancelledException.INSTANCE;
            }
            msg = String.format(Intl.intl("Could not place %1$d occupants in requested area. Do you want to keep\nthe %2$d generated occupants?"), numOccs, occgen.getNumOccupants());
            int option = JOptionPane.showConfirmDialog(app.getActiveFrame(), msg, Intl.intl("Occupant Error"), 0, 3);
            if (option != 0) {
                throw CancelledException.INSTANCE;
            }
        }
    }
}

