/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis.rend;

import inferno.data2.NavigateMeshData;
import inferno.data2.Occupant;
import inferno.data2.Tri;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.IPathSeek;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.RegroupPlanner;
import inferno.vis.GLView;
import inferno.vis.rend.IRenderer;
import inferno.vis.rend.RendAgentVehicle;
import java.awt.Color;
import java.io.Serializable;
import java.util.Set;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.lwjgl.opengl.GL11;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Util3D;

public class RendOccAgent
implements IRenderer<OccAgent> {
    private int d_outlineId = -1;
    private int d_diskId = -1;
    private static int s_bangList = -1;

    private int getOutline() {
        if (this.d_outlineId == -1) {
            this.d_outlineId = GL11.glGenLists(1);
            GL11.glNewList(this.d_outlineId, 4864);
            RendOccAgent.renderCircle(1.0, 36);
            GL11.glBegin(1);
            GL11.glVertex3d(0.0, 0.0, 0.0);
            GL11.glVertex3d(1.0, 0.0, 0.0);
            GL11.glEnd();
            GL11.glEndList();
        }
        return this.d_outlineId;
    }

    private int getDisk() {
        if (this.d_diskId == -1) {
            this.d_diskId = GL11.glGenLists(1);
            GL11.glNewList(this.d_diskId, 4864);
            RendOccAgent.renderDisk(1.0);
            GL11.glEndList();
        }
        return this.d_diskId;
    }

    private static int getBangList() {
        if (s_bangList != -1 && GL11.glIsList(s_bangList)) {
            return s_bangList;
        }
        s_bangList = GL11.glGenLists(1);
        GL11.glNewList(s_bangList, 4864);
        Color3f bang = new Color3f(1.0f, 0.8f, 0.8f);
        GL11.glColor3f(bang.x, bang.y, bang.z);
        RendOccAgent.renderDisc2(0.5, 1.0, 36);
        GL11.glEndList();
        return s_bangList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderOpaque(GLView view, KB kb, OccAgent oa) throws Exception {
        if (oa.hasVehicle()) {
            RendAgentVehicle.renderOpaque(view, kb, oa.getVehicle());
            return;
        }
        if (kb.getProps().isNull() || !view.testFilter(OCC_FILTER.class)) {
            return;
        }
        double zOff = 0.05;
        double r = oa.getOccupantRadius();
        Occupant occupant = oa.getOcc();
        synchronized (occupant) {
            if (oa.isSelected()) {
                Serializable navMeshDirsSer;
                Point3d ptSeek = kb.getProps().getDbgP3D(oa.getOcc(), "pt_seek");
                GL11.glColor3d(0.9, 0.2, 0.2);
                PathFollow pf = oa.getPathFollow();
                if (pf != null && pf.getPath() != null) {
                    int i;
                    int numKnownPoints = pf.getPath().getNumPoints(false);
                    int numPoints = view.testFilter(FULL_PATH_FILTER.class) ? pf.getPath().getNumPoints(true) : numKnownPoints;
                    IPathSeek[] pts = new IPathSeek[numPoints];
                    for (int m = 0; m < numPoints; ++m) {
                        pts[m] = pf.getPath().pointAt(m);
                    }
                    int ixSeek = -1;
                    for (i = 0; i < pts.length; ++i) {
                        if (!pts[i].getSeekPt().p.equals(ptSeek)) continue;
                        ixSeek = i;
                        break;
                    }
                    if (ptSeek == null) {
                        ixSeek = 0;
                    }
                    if (ixSeek != -1 && pts.length > 0) {
                        GL11.glColor3d(0.9, 0.2, 0.2);
                        RendOccAgent.point(pts[ixSeek].getSeekPt().p);
                        for (i = ixSeek; i < numPoints - 1; ++i) {
                            this.lineTo(pts[i].getSeekPt().p, pts[i + 1].getSeekPt().p);
                            if (i + 1 == numKnownPoints) {
                                GL11.glColor3d(0.9, 0.2, 0.9);
                            }
                            RendOccAgent.point(pts[i + 1].getSeekPt().p);
                        }
                    }
                }
                if (ptSeek != null) {
                    GL11.glColor3d(0.2, 0.8, 0.2);
                    GL11.glPushAttrib(4);
                    GL11.glLineWidth(3.0f);
                    IParametric3D curve = oa.getSeekCurve();
                    if (curve instanceof LineSeg3D) {
                        LineSeg3D seg = (LineSeg3D)curve;
                        this.lineTo(seg.p1, seg.p2);
                    } else {
                        int n = 15;
                        for (int i = 0; i < n; ++i) {
                            Point3d pt0 = curve.get((double)i / (double)n);
                            Point3d pt1 = curve.get((double)(i + 1) / (double)n);
                            Vector3d dir = Util3D.vector(pt0, pt1);
                            RendOccAgent.lineSeg(pt0, dir);
                        }
                    }
                    GL11.glPushMatrix();
                    GL11.glTranslated(ptSeek.x, ptSeek.y, ptSeek.z + zOff);
                    RendOccAgent.renderCircle(r * 0.2, 16);
                    GL11.glPopMatrix();
                    GL11.glPopAttrib();
                }
                if ((navMeshDirsSer = kb.getProps().getDbgObj(oa.getOcc(), "NAVMESH_DIR")) != null) {
                    GL11.glLineWidth(3.0f);
                    NavigateMeshData navMeshDirs = (NavigateMeshData)navMeshDirsSer;
                    int best = navMeshDirs.getBestDirIndex();
                    if (navMeshDirs.getData().size() > best && navMeshDirs.getData().get((int)best).dir != null) {
                        RendOccAgent.lineSeg(new Point3d(oa.getOcc().getDisplayLoc()), navMeshDirs.getData().get((int)best).dir);
                    }
                    GL11.glLineWidth(1.0f);
                    GL11.glColor3d(0.0, 0.0, 1.0);
                    for (NavigateMeshData.DirData dirData : navMeshDirs.getData()) {
                        if (dirData.dir == null) continue;
                        RendOccAgent.lineSeg(new Point3d(oa.getOcc().getDisplayLoc()), dirData.dir);
                    }
                }
            }
            if (view.testFilter(OCC_GROUPS_FILTER.class) && oa.getOcc().occupantGroup != null) {
                Set<OccAgent> groupMembers = oa.getOcc().occupantGroup.getMembers();
                Point3d pos = new Point3d(oa.getOcc().getDisplayLoc());
                if (oa.isSelected()) {
                    GL11.glColor3d(1.0, 0.0, 0.0);
                    GL11.glLineWidth(3.0f);
                } else {
                    GL11.glColor3d(1.0, 0.65, 0.0);
                }
                for (OccAgent other : groupMembers) {
                    if (other == oa || other.isSelected()) continue;
                    this.lineTo(pos, new Point3d(other.getOcc().getDisplayLoc()));
                }
                GL11.glLineWidth(1.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderTranslucent(GLView view, KB kb, OccAgent oa) {
        if (oa.hasVehicle()) {
            RendAgentVehicle.renderTranslucent(view, kb, oa.getVehicle());
            return;
        }
        if (kb.getProps().isNull() || !view.testFilter(OCC_FILTER.class)) {
            return;
        }
        Point3d loc = oa.getOcc().getDisplayLoc();
        double zOff = 0.05;
        Color cFill = RendOccAgent.toColor(oa.getOcc().visColor);
        Color cLine = new Color(0.0f, 0.0f, 0.53f);
        GL11.glPushMatrix();
        double rotAngle = Util3D.angle0To2PI(new Vector3d(1.0, 0.0, 0.0), oa.getDirFacing(), new Vector3d(0.0, 0.0, 1.0));
        GL11.glLoadIdentity();
        GL11.glTranslated(loc.x, loc.y, loc.z + zOff);
        GL11.glRotatef((float)(rotAngle * 180.0 / Math.PI), 0.0f, 0.0f, 1.0f);
        if (!Float.isNaN(oa.getSocialDistance()) && (view.testFilter(SOCIAL_DIST_FILTER.class) || view.testFilter(SEL_SOCIAL_DIST_FILTER.class) && oa.isSelected())) {
            GL11.glColor4f(1.0f, 0.5f, 0.5f, 0.5f);
            RendOccAgent.renderDisk(oa.getSocialDistance());
        }
        if (view.testFilter(COLOR_PRIORITY_FILTER.class)) {
            double agg = oa.getPriority(kb);
            cFill = agg >= 0.0 && agg < 0.5 ? Color.BLUE : (agg >= 0.5 && agg < 1.0 ? Color.GREEN : (agg >= 1.0 && agg < 1.5 ? Color.YELLOW : (agg >= 1.5 && agg < 2.0 ? Color.ORANGE : (agg >= 2.0 && agg < 2.5 ? Color.RED : Color.BLACK))));
        } else if (view.testFilter(OCC_GROUPS_FILTER.class) && oa.getOcc().occupantGroup != null) {
            IPathPlanner planner;
            PathFollow pathfollow = oa.getPathFollow();
            if (pathfollow != null && (planner = pathfollow.getPathPlanner()) instanceof RegroupPlanner) {
                OccAgent tempLeader = ((RegroupPlanner)planner).getTempLeader();
                if (tempLeader != null && tempLeader == oa) {
                    cFill = Color.GREEN;
                } else {
                    RegroupPlanner.State state = ((RegroupPlanner)planner).getState();
                    if (state != null && state.equals((Object)RegroupPlanner.State.DISCONNECTED_LEADER_SIDE)) {
                        cFill = Color.ORANGE;
                    } else if (state != null && state.equals((Object)RegroupPlanner.State.DISCONNECTED_NON_LEADER_SIDE)) {
                        cFill = Color.RED;
                    } else if (state != null && state.equals((Object)RegroupPlanner.State.CONNECTED)) {
                        cFill = Color.BLUE;
                    }
                }
            }
        } else if (view.testFilter(COUNTERFLOW_FILTER.class)) {
            Integer counterflow = kb.getProps().getDbgInt(oa.getOcc(), "COUNTERFLOWING");
            if (counterflow != null) {
                cFill = counterflow == 1 ? Color.ORANGE : (counterflow == 2 ? Color.RED : Color.GREEN);
            }
        } else if (oa.isSelected()) {
            cFill = Color.YELLOW;
        }
        double rColl = oa.getOccupantRadius() * oa.getCollisionFactor();
        double r = oa.getOccupantRadius();
        double rGeom = oa.getGeometryRadius();
        if (r != rGeom) {
            GL11.glColor3ub((byte)0, (byte)0, (byte)-1);
            RendOccAgent.renderCircle(rGeom, 10);
        }
        GL11.glScaled(r, r, r);
        GL11.glColor3ub((byte)cLine.getRed(), (byte)cLine.getGreen(), (byte)cLine.getBlue());
        GL11.glCallList(this.getOutline());
        if (kb.getProps().isDbgDefined(oa.getOcc(), "geom_collide") && kb.getProps().getDbgBool(oa.getOcc(), "geom_collide").booleanValue()) {
            GL11.glColor4d(1.0, 0.3, 0.3, 0.5);
            GL11.glCallList(this.getDisk());
        }
        double newScale = rColl / r;
        GL11.glScaled(newScale, newScale, newScale);
        RendOccAgent.glColor4(cFill.getRed(), cFill.getGreen(), cFill.getBlue(), 128);
        GL11.glCallList(this.getDisk());
        GL11.glColor3ub((byte)cLine.getRed(), (byte)cLine.getGreen(), (byte)cLine.getBlue());
        GL11.glCallList(this.getOutline());
        GL11.glPopMatrix();
        Occupant occupant = oa.getOcc();
        synchronized (occupant) {
            Occupant o = oa.getOcc();
            if (kb.getProps().getDbgP3D(o, "ptWiskOrigin") != null) {
                GL11.glColor4d(1.0, 1.0, 1.0, 0.5);
                this.lineTo(kb.getProps().getDbgP3D(o, "ptWiskOrigin"), kb.getProps().getDbgP3D(o, "ptWiskLeft"));
                this.lineTo(kb.getProps().getDbgP3D(o, "ptWiskLeft"), kb.getProps().getDbgP3D(o, "ptWiskAhead"));
                GL11.glColor4d(1.0, 1.0, 1.0, 0.5);
                this.lineTo(kb.getProps().getDbgP3D(o, "ptWiskOrigin"), kb.getProps().getDbgP3D(o, "ptWiskRight"));
                this.lineTo(kb.getProps().getDbgP3D(o, "ptWiskRight"), kb.getProps().getDbgP3D(o, "ptWiskAhead"));
                kb.getProps().setDbg(o, "ptWiskOrigin", null);
                kb.getProps().setDbg(o, "ptWiskAhead", null);
                kb.getProps().setDbg(o, "ptWiskLeft", null);
                kb.getProps().setDbg(o, "ptWiskRight", null);
            }
        }
    }

    private static void glColor4(int r, int g, int b, int a) {
        GL11.glColor4d((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, (double)a / 255.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rendTouchingTris(OccAgent oa) {
        Occupant occupant = oa.getOcc();
        synchronized (occupant) {
            Tri tri;
            int m = 0;
            while ((tri = (Tri)oa.getOcc().dbgProps.get("touchingtris" + m)) != null) {
                this.triangle(tri, 0.1, 1.0f, 0.0f, 0.0f);
                ++m;
            }
        }
    }

    private void triangle(Tri tri, double z, float cr, float cb, float cg) {
        Point3d pt1 = tri.v[0].p;
        Point3d pt2 = tri.v[1].p;
        Point3d pt3 = tri.v[2].p;
        GL11.glNormal3f(0.0f, 0.0f, 1.0f);
        GL11.glColor3f(cr, cg, cb);
        GL11.glBegin(4);
        GL11.glVertex3d(pt1.x, pt1.y, pt1.z + z);
        GL11.glVertex3d(pt2.x, pt2.y, pt2.z + z);
        GL11.glVertex3d(pt3.x, pt3.y, pt3.z + z);
        GL11.glEnd();
    }

    static void point(Point3d loc) {
        GL11.glBegin(0);
        GL11.glVertex3d(loc.x, loc.y, loc.z + 0.01);
        GL11.glEnd();
    }

    private void lineTo(Point3d loc, Point3d pt) {
        GL11.glBegin(1);
        GL11.glVertex3d(loc.x, loc.y, loc.z + 0.01);
        GL11.glVertex3d(pt.x, pt.y, pt.z + 0.01);
        GL11.glEnd();
    }

    static void lineSeg(Point3d loc, Vector3d dirVec) {
        Point3d p2 = new Point3d(loc);
        p2.add(dirVec);
        GL11.glBegin(1);
        GL11.glVertex3d(loc.x, loc.y, loc.z + 0.01);
        GL11.glVertex3d(p2.x, p2.y, p2.z + 0.01);
        GL11.glEnd();
    }

    private void lineSeg(LineSeg3D lineSeg) {
        Point3d p1 = lineSeg.getP1();
        Point3d p2 = lineSeg.getP2();
        GL11.glBegin(1);
        GL11.glVertex3d(p1.x, p1.y, p1.z + 0.01);
        GL11.glVertex3d(p2.x, p2.y, p2.z + 0.01);
        GL11.glEnd();
    }

    @Override
    public AABox getBounds(OccAgent oa) {
        if (oa.hasVehicle()) {
            return RendAgentVehicle.getBounds(oa.getVehicle());
        }
        Point3d loc = oa.getOcc().getDisplayLoc();
        return oa.getOcc().getBoundingBox(loc, false);
    }

    private void renderBox(Box3d box) {
        GL11.glBegin(7);
        for (Point3d[] face : box.getFaces()) {
            for (int m = 0; m < 4; ++m) {
                Point3d p = face[m];
                GL11.glVertex3d(p.x, p.y, p.z);
            }
        }
        GL11.glEnd();
    }

    static void renderCircle(double r, int segs) {
        GL11.glBegin(2);
        double deg2rad = Math.PI / 180;
        for (int i = 0; i < 360; i += 10) {
            double degInRad = (double)i * deg2rad;
            GL11.glVertex2d(Math.cos(degInRad) * r, Math.sin(degInRad) * r);
        }
        GL11.glEnd();
    }

    private static void renderDisk(double r) {
        GL11.glBegin(6);
        double deg2rad = Math.PI / 180;
        GL11.glVertex2d(0.0, 0.0);
        for (int i = 0; i < 360; i += 10) {
            double degInRad = (double)i * deg2rad;
            GL11.glVertex2d(Math.cos(degInRad) * r, Math.sin(degInRad) * r);
        }
        double degInRad = 360.0 * deg2rad;
        GL11.glVertex2d(Math.cos(degInRad) * r, Math.sin(degInRad) * r);
        GL11.glEnd();
    }

    private static void renderDisc2(double r1, double r2, int tris) {
        GL11.glBegin(5);
        double deg2rad = Math.PI / 180;
        GL11.glVertex2d(0.0, 0.0);
        for (int i = 0; i < 360; i += 10) {
            double degInRad = (double)i * deg2rad;
            GL11.glVertex2d(Math.cos(degInRad) * r1, Math.sin(degInRad) * r1);
            GL11.glVertex2d(Math.cos(degInRad) * r2, Math.sin(degInRad) * r2);
        }
        double degInRad = 360.0 * deg2rad;
        GL11.glVertex2d(Math.cos(degInRad) * r1, Math.sin(degInRad) * r1);
        GL11.glVertex2d(Math.cos(degInRad) * r2, Math.sin(degInRad) * r2);
        GL11.glEnd();
    }

    static Color toColor(Color3b color) {
        return new Color(RendOccAgent.toColorCC(color.x), RendOccAgent.toColorCC(color.y), RendOccAgent.toColorCC(color.z));
    }

    private static int toColorCC(byte ccb) {
        return 0xFF & ccb;
    }

    public static class SEL_SOCIAL_DIST_FILTER {
    }

    public static class SOCIAL_DIST_FILTER {
    }

    public static class COUNTERFLOW_FILTER {
    }

    public static class OCC_GROUPS_FILTER {
    }

    public static class FULL_PATH_FILTER {
    }

    public static class COLOR_PRIORITY_FILTER {
    }

    public static class OCC_FILTER {
    }
}

