/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis.rend;

import inferno.data2.NavigateMeshData;
import inferno.data2.Occupant;
import inferno.data2.PolygonShape;
import inferno.data2.TriPoint;
import inferno.sim.AgentVehicle;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.IPathSeek;
import inferno.sim.steering.PathFollow;
import inferno.vis.GLView;
import inferno.vis.rend.RendOccAgent;
import java.awt.Color;
import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.lwjgl.opengl.GL11;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Util3D;

public class RendAgentVehicle {
    private static boolean SEE_THROUGH_AGENTS = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderOpaque(GLView view, KB kb, AgentVehicle obj) throws Exception {
        OccAgent agent = obj.getAgent();
        Occupant occupant = obj.getOcc();
        synchronized (occupant) {
            if (agent.isSelected()) {
                Serializable navMeshDirsSer;
                Point3d ptSeek = kb.getProps().getDbgP3D(obj.getOcc(), "pt_seek");
                GL11.glColor3d(0.9, 0.2, 0.2);
                PathFollow pf = agent.getPathFollow();
                if (pf != null && pf.getPath() != null) {
                    int i;
                    int numKnownPoints = pf.getPath().getNumPoints(false);
                    int numPoints = !view.getFilters().isFilteringAllOf(RendOccAgent.FULL_PATH_FILTER.class) ? pf.getPath().getNumPoints(true) : numKnownPoints;
                    IPathSeek[] pts = new IPathSeek[numPoints];
                    for (int m = 0; m < numPoints; ++m) {
                        pts[m] = pf.getPath().pointAt(m);
                    }
                    int ixSeek = -1;
                    for (i = 0; i < pts.length; ++i) {
                        TriPoint p = pts[i].getSeekPt();
                        if (p == null || ptSeek == null || !p.p.equals(ptSeek)) continue;
                        ixSeek = i;
                        break;
                    }
                    if (ptSeek == null) {
                        ixSeek = 0;
                    }
                    if (ixSeek != -1) {
                        GL11.glColor3d(0.9, 0.2, 0.2);
                        RendOccAgent.point(pts[ixSeek].getSeekPt().p);
                        for (i = ixSeek; i < numPoints - 1; ++i) {
                            RendAgentVehicle.lineTo(pts[i].getSeekPt().p, pts[i + 1].getSeekPt().p);
                            if (i + 1 == numKnownPoints) {
                                GL11.glColor3d(0.9, 0.2, 0.9);
                            }
                            RendOccAgent.point(pts[i + 1].getSeekPt().p);
                        }
                    }
                }
                if (ptSeek != null) {
                    GL11.glColor3d(0.2, 0.8, 0.2);
                    GL11.glPushAttrib(4);
                    GL11.glLineWidth(3.0f);
                    IParametric3D curve = agent.getSeekCurve();
                    if (curve instanceof LineSeg3D) {
                        LineSeg3D seg = (LineSeg3D)curve;
                        RendAgentVehicle.lineTo(seg.p1, seg.p2);
                    } else {
                        int n = 15;
                        for (int i = 0; i < n; ++i) {
                            Point3d pt0 = curve.get((double)i / (double)n);
                            Point3d pt1 = curve.get((double)(i + 1) / (double)n);
                            Vector3d dir = Util3D.vector(pt0, pt1);
                            RendOccAgent.lineSeg(pt0, dir);
                        }
                    }
                    GL11.glPushMatrix();
                    GL11.glTranslated(ptSeek.x, ptSeek.y, ptSeek.z + 0.05);
                    GL11.glPopMatrix();
                    GL11.glPopAttrib();
                }
                if ((navMeshDirsSer = kb.getProps().getDbgObj(obj.getOcc(), "NAVMESH_DIR")) != null) {
                    GL11.glLineWidth(3.0f);
                    NavigateMeshData navMeshDirs = (NavigateMeshData)navMeshDirsSer;
                    int best = navMeshDirs.getBestDirIndex();
                    if (!navMeshDirs.getData().isEmpty() && navMeshDirs.getData().get((int)best).dir != null) {
                        RendOccAgent.lineSeg(obj.getOcc().getDisplayLoc(), navMeshDirs.getData().get((int)best).dir);
                    }
                    GL11.glLineWidth(1.0f);
                    GL11.glColor3d(0.0, 0.0, 1.0);
                    for (NavigateMeshData.DirData dirData : navMeshDirs.getData()) {
                        if (dirData.dir == null) continue;
                        RendOccAgent.lineSeg(obj.getOcc().getDisplayLoc(), dirData.dir);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderTranslucent(GLView view, KB kb, AgentVehicle obj) {
        if (kb.getProps().isNull() || view.getFilters().isFilteringAllOf(RendOccAgent.OCC_FILTER.class)) {
            return;
        }
        Occupant occupant = obj.getOcc();
        synchronized (occupant) {
            int i;
            OccAgent agent = obj.getAgent();
            double locZ = obj.getOcc().getDisplayLoc().z;
            double zOffset = 0.0;
            double height = obj.getOcc().bodyShape.getHeight();
            Point3d[] opoints = obj.getPoints();
            if (!view.getFilters().isFilteringAllOf(DISPLAY_ORIENT.class)) {
                PolygonShape oshape = obj.getShape().orientTo(obj.getOcc().displayOrient);
                oshape = (PolygonShape)oshape.moveTo(agent.getPos());
                opoints = oshape.getPoints();
            }
            Point3d[] points = new Point3d[2 * opoints.length];
            for (i = 0; i < opoints.length; ++i) {
                points[i] = new Point3d(opoints[i]);
                if (i == 0) {
                    zOffset = locZ - points[i].z;
                }
                points[i].z += zOffset;
            }
            for (i = 0; i < opoints.length; ++i) {
                Point3d p = points[i];
                points[i + opoints.length] = new Point3d(p.x, p.y, p.z + height);
            }
            Color cFill = RendOccAgent.toColor(obj.getOcc().visColor);
            if (!view.getFilters().isFilteringAllOf(RendOccAgent.COLOR_PRIORITY_FILTER.class)) {
                double agg = agent.getPriority(kb);
                cFill = agg >= 0.0 && agg < 0.5 ? Color.BLUE : (agg >= 0.5 && agg < 1.0 ? Color.GREEN : (agg >= 1.0 && agg < 1.5 ? Color.YELLOW : (agg >= 1.5 && agg < 2.0 ? Color.ORANGE : (agg >= 2.0 && agg < 2.5 ? Color.RED : Color.BLACK))));
            }
            if (points.length == 8) {
                Box3d box = new Box3d(points);
                RendAgentVehicle.renderBox(box, obj, cFill, height);
            } else {
                RendAgentVehicle.renderShape(points, obj, cFill, height);
            }
        }
    }

    private static void renderShape(Point3d[] points, AgentVehicle obj, Color c, double height) {
        assert (points.length % 2 == 0);
        Point3d[][] sides = new Point3d[points.length / 2][4];
        for (int i = 0; i < points.length / 2; ++i) {
            sides[i][0] = points[i];
            sides[i][1] = points[(i + 1) % (points.length / 2)];
            sides[i][2] = points[(i + 1) % (points.length / 2) + points.length / 2];
            sides[i][3] = points[i + points.length / 2];
        }
        OccAgent agent = obj.getAgent();
        if (!SEE_THROUGH_AGENTS && !agent.isSelected()) {
            int i;
            GL11.glBegin(7);
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            if (r == 102 && g == 102 && b == 255) {
                r = 0;
            }
            GL11.glColor3d(r, g, b);
            for (Point3d[] face : sides) {
                for (int m = 0; m < 4; ++m) {
                    Point3d p = face[m];
                    GL11.glVertex3d(p.x, p.y, p.z);
                }
            }
            GL11.glEnd();
            GL11.glBegin(9);
            for (i = 0; i < points.length / 2; ++i) {
                Point3d p = points[i];
                GL11.glVertex3d(p.x, p.y, p.z);
            }
            GL11.glEnd();
            GL11.glBegin(9);
            for (i = points.length / 2; i < points.length; ++i) {
                Point3d p = points[i];
                GL11.glVertex3d(p.x, p.y, p.z);
            }
            GL11.glEnd();
        }
        GL11.glColor3d(0.0, 0.0, 0.0);
        for (Point3d[] face : sides) {
            for (int m = 0; m < 4; ++m) {
                int n = (m + 1) % 4;
                Point3d p = face[m];
                Point3d p2 = face[n];
                RendAgentVehicle.lineTo(p, p2);
            }
        }
        Point3d center = new Point3d(obj.getOcc().getDisplayLoc());
        center.z += height;
        Point3d dirP = new Point3d(center);
        double length = obj.getBody().length / 2.0;
        Vector3d add = new Vector3d(agent.getDirFacing());
        add.normalize();
        add.scale(length);
        dirP.add(add);
        dirP.z = center.z;
        RendAgentVehicle.lineTo(center, dirP);
    }

    public static AABox getBounds(AgentVehicle obj) {
        return obj.getCurrentBoundingBox();
    }

    private static void renderBox(Box3d box, AgentVehicle obj, Color c, double height) {
        OccAgent agent = obj.getAgent();
        if (!SEE_THROUGH_AGENTS && !agent.isSelected()) {
            GL11.glBegin(7);
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            if (r == 102 && g == 102 && b == 255) {
                r = 0;
            }
            GL11.glColor3d(r, g, b);
            for (Point3d[] face : box.getFaces()) {
                for (int m = 0; m < 4; ++m) {
                    Point3d p = face[m];
                    GL11.glVertex3d(p.x, p.y, p.z);
                }
            }
            GL11.glEnd();
        }
        GL11.glColor3d(0.0, 0.0, 0.0);
        for (Point3d[] face : box.getFaces()) {
            for (int m = 0; m < 4; ++m) {
                int n = (m + 1) % 4;
                Point3d p = face[m];
                Point3d p2 = face[n];
                RendAgentVehicle.lineTo(p, p2);
            }
        }
        Point3d center = new Point3d(obj.getOcc().getDisplayLoc());
        center.z += height;
        Point3d dirP = new Point3d(center);
        double length = obj.getBody().length / 2.0;
        Vector3d add = new Vector3d(agent.getDirFacing());
        add.normalize();
        add.scale(length);
        dirP.add(add);
        dirP.z = center.z;
        RendAgentVehicle.lineTo(center, dirP);
        GL11.glPushMatrix();
        double radius = agent.getOccupantRadius();
        center = new Point3d(obj.getOcc().getDisplayLoc());
        GL11.glTranslated(center.x, center.y, center.z);
        RendOccAgent.renderCircle(radius, 16);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private static void lineTo(Point3d loc, Point3d pt) {
        GL11.glBegin(1);
        GL11.glVertex3d(loc.x, loc.y, loc.z + 0.01);
        GL11.glVertex3d(pt.x, pt.y, pt.z + 0.01);
        GL11.glEnd();
    }

    public static class DISPLAY_ORIENT {
    }
}

