/*
 * Decompiled with CFR 0.152.
 */
package inferno.test;

import inferno.test.EnvUtil;
import inferno.test.Prob;
import inferno.test.TestPrefs;
import inferno.test.WriteFile;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import thunderheadeng.gui.Application;
import thunderheadeng.io.TeciLogging;

public class Run
extends Application {
    private static final Logger LOGGER = Logger.getLogger(Run.class.getName());

    public static void main(String[] args) throws Throwable {
        SimpleFormatter fmt = new SimpleFormatter(){
            private static final String format = "[%3s] [%-7s] %s %n";

            @Override
            public synchronized String format(LogRecord lr) {
                return String.format(format, lr.getThreadID(), lr.getLevel().getLocalizedName(), lr.getMessage());
            }
        };
        TeciLogging.initToSplitHandler(Logger.getLogger(""), Level.CONFIG, Level.WARNING, fmt, System.out, System.err);
        Run app = new Run(args);
        app.run();
    }

    public Run(String[] args) {
        super("Pathfinder Tests", args);
    }

    @Override
    protected void loadLibraries() {
    }

    @Override
    public boolean isInstallFolder(File folder) {
        int found = 0;
        if (Stream.of(folder.listFiles()).anyMatch(f -> f.getName().equalsIgnoreCase("PathfinderResults.exe") || f.getName().equalsIgnoreCase("PathfinderResults_x86_Debug.exe") || f.getName().equalsIgnoreCase("PathfinderResults_x64_Debug.exe") || f.getName().equalsIgnoreCase("PathfinderResults_x86_Release.exe") || f.getName().equalsIgnoreCase("PathfinderResults_x64_Release.exe"))) {
            ++found;
        }
        if (Stream.of(folder.listFiles()).anyMatch(f -> f.getName().equalsIgnoreCase("lib"))) {
            ++found;
        }
        return found == 2;
    }

    public void run() throws Exception {
        long tI = System.currentTimeMillis();
        int nProcs = Run.getNumTests();
        PrintWriter resultWriter = null;
        if (EnvUtil.get(TestPrefs.STORE).booleanValue()) {
            File outputf = EnvUtil.getDir(TestPrefs.STORE_LOCATION);
            outputf.mkdir();
            resultWriter = WriteFile.createWriter(outputf.getCanonicalPath());
        }
        ExecutorService jobs = Executors.newFixedThreadPool(nProcs);
        Collection<Prob> tests = Run.getTests();
        for (Prob test : tests) {
            PrintWriter writer = resultWriter;
            jobs.submit(() -> {
                test.run();
                WriteFile.addResult(test, writer);
                writer.flush();
                System.gc();
            });
        }
        jobs.shutdown();
        jobs.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        if (resultWriter != null) {
            resultWriter.close();
        }
        System.out.flush();
        List<Prob> testFailures = Run.getTestFailures(tests);
        LOGGER.log(Level.INFO, String.format("%d/%d SUCCESSFUL tests.", tests.size() - testFailures.size(), tests.size()));
        LOGGER.log(Level.INFO, String.format("%d FAILED tests.", testFailures.size()));
        long tF = System.currentTimeMillis();
        long deltaT = tF - tI;
        int hours = (int)(deltaT / 3600000L);
        int minutes = (int)((deltaT - (long)(hours * 3600000)) / 60000L);
        int seconds = (int)((deltaT - (long)(hours * 3600000) - (long)(minutes * 60000)) / 1000L);
        LOGGER.log(Level.INFO, String.format("Runtime: %d hours %d minutes %d seconds", hours, minutes, seconds));
        int exitStatus = testFailures.size() > 0 ? -1 : 0;
        System.exit(exitStatus);
    }

    private static int getNumTests() {
        int nTests = 1;
        String nTestsStr = System.getProperty("ntests", Integer.toString(nTests));
        try {
            nTests = Integer.parseInt(nTestsStr);
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
        return nTests;
    }

    private static Collection<Prob> getTests() {
        return EnvUtil.get(TestPrefs.TESTSUITE).getTests();
    }

    private static List<Prob> getTestFailures(Collection<Prob> tests) {
        return tests.stream().filter(test -> test.getStatus() != 0).collect(Collectors.toList());
    }
}

