/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.locallyquickest;

import inferno.data2.ANode;
import inferno.data2.Mesh;
import inferno.data2.Occupant;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.Estimate;
import inferno.sim.path.IPathSeek;
import inferno.sim.path.Path;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.path.TriFilters;
import inferno.sim.path.WaypointSeek;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.locallyquickest.IGlobalTarget;
import inferno.sim.steering.locallyquickest.ILocalTarget;
import inferno.sim.steering.locallyquickest.LocalDoorTarget;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class PointTarget
implements ILocalTarget,
IGlobalTarget,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_MOVED_INTERVAL = theUtil.getSystemDouble("PointGoal.DEFAULT_MOVED_INTERVAL", 5.0);
    public static final double DEFAULT_MOVED_TOL = theUtil.getSystemDouble("PointGoal.DEFAULT_MOVED_TOL", 1.0);
    public final ITpSource targetPoint;
    public final double distTolSq;
    public final double timeTol;
    private ANode d_prevNode;
    private Point3d d_prevPt;
    private double d_prevUpdateTime = -1.7976931348623157E308;

    public PointTarget(ITpSource target) {
        this(target, DEFAULT_MOVED_TOL, DEFAULT_MOVED_INTERVAL);
    }

    public PointTarget(ITpSource target, double distTol, double timeTol) {
        this.targetPoint = target;
        this.distTolSq = distTol * distTol;
        this.timeTol = timeTol;
    }

    public PointTarget clone() {
        try {
            PointTarget target = (PointTarget)super.clone();
            return target;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public int hashCode() {
        return 0x3FF33EFE ^ this.targetPoint.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PointTarget && ((PointTarget)obj).targetPoint.equals(this.targetPoint);
    }

    @Override
    public boolean isStatic(KB kb) {
        return this.targetPoint.isStatic();
    }

    private static boolean pointsEqual(Point3d p1, Point3d p2, double distTolSq) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        return p1.distanceSquared(p2) <= distTolSq;
    }

    @Override
    public int update(KB kb, OccAgent agent) {
        ANode currNode;
        TriPoint currLoc = this.targetPoint.getTriPoint();
        int changes = 0;
        if (kb.getCurrentSimTime() - this.d_prevUpdateTime >= this.timeTol) {
            Point3d currPt;
            Point3d point3d = currPt = currLoc != null ? currLoc.p : null;
            if (!PointTarget.pointsEqual(this.d_prevPt, currPt, this.distTolSq)) {
                changes |= 2;
                this.d_prevPt = currPt;
            }
            this.d_prevUpdateTime = kb.getCurrentSimTime();
        }
        ANode aNode = currNode = currLoc != null ? currLoc.tri.node : null;
        if (this.d_prevNode != currNode) {
            changes |= 1;
        }
        this.d_prevNode = currNode;
        return changes;
    }

    @Override
    public void invalidate() {
    }

    @Override
    public Collection<? extends ILocalTarget> getLocalTargets(KB kb, OccAgent agent, ANode currentRoom) {
        TriPoint loc = this.targetPoint.getTriPoint();
        assert (loc.tri != null) : "Agent " + agent.getOcc().name + ": null tri";
        return loc.tri.node == currentRoom ? Collections.singleton(this) : Collections.EMPTY_LIST;
    }

    @Override
    public boolean isLocalTarget(ILocalTarget target) {
        return this.equals(target);
    }

    @Override
    public Vector3d getNaiveDistanceVec(KB kb, OccAgent agent, ANode room) {
        TriPoint tpGoal = this.targetPoint.getTriPoint();
        return Util3D.vector(agent.getPos(), tpGoal.p);
    }

    @Override
    public boolean isReachable(KB kb, OccAgent agent, Predicate<PathChange> pathPlanningFilter) {
        double r;
        Mesh mesh = kb.getMesh();
        Occupant occ = agent.getOcc();
        TriPoint tpGoal = this.targetPoint.getTriPoint();
        PathGen.PointGoal pathGoal = new PathGen.PointGoal(tpGoal);
        PathGen.MTSearchNode node = PathGen.getPathAStar(mesh, occ.tri, null, null, occ.loc, pathGoal, r = occ.bodyShape.getGeomRadius(), Double.MAX_VALUE, pathPlanningFilter);
        return node != null;
    }

    @Override
    public LocallyQuickest.LQuickPath getLocalPath(KB kb, OccAgent agent, Predicate<PathChange> pathPlanningFilter, IGlobalTarget gTarget, Estimate.DoorToGoalValue tailInfo) {
        double r;
        Mesh mesh = kb.getMesh();
        Occupant occ = agent.getOcc();
        TriPoint tpGoal = this.targetPoint.getTriPoint();
        PathGen.PointGoal pathGoal = new PathGen.PointGoal(tpGoal);
        Pair<List<TriPoint>, List<TriEdge>> pathData = PathGen.getPath(mesh, occ.tri, null, null, occ.loc, pathGoal, r = occ.bodyShape.getGeomRadius(), Double.MAX_VALUE, pathPlanningFilter);
        if (pathData == null) {
            return null;
        }
        List pts = (List)pathData.v1;
        ArrayList<IPathSeek> seekPts = new ArrayList<IPathSeek>(pts.size() + 1);
        for (int m = 0; m < pts.size(); ++m) {
            seekPts.add(new WaypointSeek((TriPoint)pts.get(m), EdgeFilters.acceptAll()));
        }
        seekPts.add(new WaypointSeek(tpGoal, EdgeFilters.acceptAll()));
        List edges = (List)pathData.v2;
        return new LocallyQuickest.LQuickPath(new Path(seekPts), edges, null);
    }

    @Override
    public Future<Estimate.DoorToGoalValue> getDistFromLocalTarget(KB kb, OccAgent agent, LocalDoorTarget localDoor, ANode currentRoom) {
        Predicate<Tri> triFilter = TriFilters.filterDangerous(Filters.accept(this.targetPoint.getTriPoint().tri.node), false);
        return kb.getPathEstimates().doorToPointDistance(kb.getMesh(), localDoor.door, this.targetPoint, currentRoom, agent.generatePathFilter(kb, triFilter, EdgeFilters.acceptAll(), OccAgent.PathFilterType.DOOR_TO_GOAL));
    }

    @Override
    public double getLocalQueueTimeEstimate(KB kb, OccAgent agent, LocalTimeEstimate estimator, double tTargetChosen, double localDist, Estimate.DoorToGoalValue globalDist) {
        return 0.0;
    }

    @Override
    public double getLocalTravelTimeEstimate(KB kb, OccAgent agent, LocalTimeEstimate estimator, double localDist) {
        double travelTime = estimator.getTravelTime(kb, agent, localDist);
        return travelTime;
    }

    public String toString() {
        return this.targetPoint.toString();
    }
}

