/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.locallyquickest;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Occupant;
import inferno.data2.SpeedModifier;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.ai.AssistOccupantsGoal;
import inferno.geom.Util;
import inferno.sim.DoorQueue;
import inferno.sim.ElevatorModel;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.AiUtil;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.Estimate;
import inferno.sim.path.IPath;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.path.TriFilters;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.locallyquickest.IGlobalTarget;
import inferno.sim.steering.locallyquickest.ILocalTarget;
import inferno.sim.steering.locallyquickest.LocalDoorCosts;
import inferno.sim.steering.locallyquickest.LocalDoorTarget;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class LocallyQuickest
implements IPathPlanner,
Serializable {
    static final long serialVersionUID = 1L;
    private final IGlobalTarget d_globalTarget;
    private int d_globalTargetChanges = 0;
    private Map<ILocalTarget, TargetInfo> d_localTargetInfo;
    private List<ILocalTarget> d_validLocalTargets;
    private int d_estimateId;
    private LocalTimeEstimate d_estimator;
    private ILocalTarget d_prevBestLocalTarget;
    private LQuickPath d_prevBestLocalTargetPath;
    private double d_tBestLocalTargetFirstChosen;
    private double d_tBestLocalTargetEvaluated;
    private int d_numEvals;
    private double d_distTravelledLastReset;
    private double d_prevDistTravelled;
    private Predicate<WingedEdge> d_transientEdgeFilter;
    protected ANode d_room;
    private Backtrack d_backtrack;

    public LocallyQuickest(OccAgent agent, LocalTimeEstimate estimator, IGlobalTarget target) {
        this.d_estimator = estimator;
        this.d_globalTarget = target;
        this.d_room = null;
        this.invalidate(agent, true);
        this.d_estimateId = -1;
        this.d_transientEdgeFilter = LocallyQuickest.getTransientEdgeFilter(null, Collections.EMPTY_SET, true);
        this.d_backtrack = new Backtrack();
    }

    private static Predicate<WingedEdge> getTransientEdgeFilter(ANode currRoom, Set<WingedEdge> acceptEdges, boolean filterOnewayDoors) {
        Predicate<WingedEdge> potDangerousEdgeFilter = Predicates.or(Filters.accept(acceptEdges), EdgeFilters.acceptRoomEdges(currRoom).negate());
        return EdgeFilters.filterDangerous(potDangerousEdgeFilter, filterOnewayDoors);
    }

    public void checkCache(KB kb, OccAgent agent) {
        Estimate est = kb.getPathEstimates();
        if (est.getChangeId() != this.d_estimateId) {
            this.d_localTargetInfo = null;
            this.d_validLocalTargets = null;
            this.d_prevDistTravelled = agent.getOcc().totalDistanceMeters;
            this.d_globalTarget.invalidate();
            this.d_estimateId = est.getChangeId();
        }
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue queue) {
        ANode destNode;
        if (this.d_room == null) {
            return;
        }
        assert (queue.getR1() == this.d_room || queue.getR2() == this.d_room);
        ANode aNode = destNode = queue.getR1() == this.d_room ? queue.getR2() : queue.getR1();
        if (this.d_room != destNode) {
            Point3d crossLoc = queue.getNode().getNearestLocOnDoor(agent.getPos());
            assert (crossLoc != null);
            if (crossLoc == null) {
                crossLoc = agent.getPos();
            }
            this.d_backtrack.update(this, queue, crossLoc, destNode);
            this.d_room = destNode;
            this.invalidate(agent, true);
        }
    }

    private ANode getDestNode(ANode currRoom, WingedEdge door) {
        ANode node1 = door.getNode1();
        return currRoom == node1 ? door.getNode2() : node1;
    }

    public void invalidate(OccAgent agent, boolean recalcTargets) {
        this.d_prevBestLocalTarget = null;
        this.d_tBestLocalTargetFirstChosen = Double.POSITIVE_INFINITY;
        this.d_tBestLocalTargetEvaluated = Double.NEGATIVE_INFINITY;
        this.d_distTravelledLastReset = agent.getOcc().totalDistanceMeters;
        this.d_numEvals = 0;
        this.d_estimator.clearAllMemory();
        if (recalcTargets) {
            this.d_localTargetInfo = null;
            this.d_validLocalTargets = null;
            this.d_globalTargetChanges = 0;
        }
    }

    @Override
    public Predicate<WingedEdge> getTransientEdgeFilter(KB kb, OccAgent agent) {
        return this.d_transientEdgeFilter;
    }

    private Predicate<PathChange> getPathPlanningFilter(KB kb, OccAgent agent) {
        Predicate<ANode> nodeFilter = this.d_room != null ? Filters.accept(this.d_room) : Filters.acceptAll(ANode.class);
        Predicate<Tri> triFilter = TriFilters.filterDangerous(nodeFilter, true);
        return agent.generatePathFilter(kb, triFilter, EdgeFilters.acceptAll(), OccAgent.PathFilterType.LOCAL);
    }

    private boolean isCurrTarget(ILocalTarget target) {
        return target.equals(this.d_prevBestLocalTarget);
    }

    private void evalLocalPath(KB kb, OccAgent agent, ILocalTarget localTarget, TargetEval eval, boolean updateCurrTargetPath, Map<ILocalTarget, LQuickPath> paths) {
        if (paths.containsKey(localTarget)) {
            return;
        }
        boolean isCurrTarget = this.isCurrTarget(localTarget);
        LQuickPath path = isCurrTarget && !updateCurrTargetPath && this.d_prevBestLocalTargetPath != null ? this.d_prevBestLocalTargetPath : this.getLocalPath(kb, agent, localTarget);
        paths.put(localTarget, path);
        if (path == null) {
            eval.setPathLength(Double.POSITIVE_INFINITY, Estimate.PointToGoalDist.noPath(null, 0.5));
        } else {
            eval.setPathLength(path.getLocalLength(), path.tailDist != null ? path.tailDist : TargetEval.irrelevantTailDist());
        }
    }

    private LQuickPath getLocalPath(KB kb, OccAgent agent, ILocalTarget localTarget) {
        TargetInfo ti = this.d_localTargetInfo.get(localTarget);
        LQuickPath path = localTarget.getLocalPath(kb, agent, this.getPathPlanningFilter(kb, agent), ti.target, ti.tailInfo);
        return path;
    }

    private List<ILocalTarget> getValidLocalTargets(Collection<ILocalTarget> potentialTargets, double tailLengthFilter, Predicate<Pair<TargetInfo, Estimate.PointToGoalDist>> targetFilter, KB kb, OccAgent agent, Map<ILocalTarget, LQuickPath> reachableTargets) {
        ArrayList<ILocalTarget> validTargets = new ArrayList<ILocalTarget>();
        for (ILocalTarget target : potentialTargets) {
            TargetInfo ti = this.d_localTargetInfo.get(target);
            double bestExitDist = ti.tailInfo.minDist.dist;
            if (tailLengthFilter <= bestExitDist) continue;
            Estimate.DoorToGoalValue tailInfo = ti.tailInfo;
            ArrayList<Estimate.PointToGoalDist> allowedDists = new ArrayList<Estimate.PointToGoalDist>(tailInfo.dists.size());
            for (Estimate.PointToGoalDist tdist : tailInfo.dists) {
                if (!targetFilter.test(new Pair<TargetInfo, Estimate.PointToGoalDist>(ti, tdist))) continue;
                allowedDists.add(tdist);
            }
            if (allowedDists.isEmpty()) continue;
            if (allowedDists.size() != tailInfo.dists.size()) {
                tailInfo = new Estimate.DoorToGoalValue(tailInfo.door1, tailInfo.goal, true, allowedDists);
                ti = new TargetInfo(ti.ltarget, ti.target, tailInfo);
                this.d_localTargetInfo.put(target, ti);
            }
            if (!reachableTargets.containsKey(target)) {
                LQuickPath path = this.getLocalPath(kb, agent, target);
                reachableTargets.put(target, path);
            }
            if (reachableTargets.get(target) == null) continue;
            validTargets.add(target);
        }
        return validTargets;
    }

    @Override
    public boolean update(KB kb, OccAgent agent, boolean forceNewPath) {
        int globalTargetChanges = this.d_globalTarget.isStatic(kb) ? 0 : this.d_globalTarget.update(kb, agent);
        this.d_globalTargetChanges |= globalTargetChanges;
        if (theUtil.testAny(globalTargetChanges, 1)) {
            this.invalidate(agent, true);
        }
        if (this.d_prevBestLocalTarget == null || forceNewPath) {
            return true;
        }
        double minRepathDT = kb.getParams().min_repath_dt;
        double evalDT = this.d_numEvals == 1 ? agent.d_realTimeModifier * minRepathDT : minRepathDT;
        double tNextEval = this.d_tBestLocalTargetEvaluated + evalDT;
        return theUtil.ge(kb.getCurrentSimTime(), tNextEval, 1.0E-6);
    }

    private void getTargetsInRoom(KB kb, OccAgent agent, ANode room, Set<ILocalTarget> targets) {
        for (WingedEdge door : room.getDoorEdges()) {
            if (door.isInternal()) continue;
            targets.add(new LocalDoorTarget(door));
        }
        Collection<? extends ILocalTarget> ltargets = this.d_globalTarget.getLocalTargets(kb, agent, room);
        targets.addAll(ltargets);
        for (WingedEdge e : kb.getElevatorModel().getTransportEdges(room.getElevatorLevel())) {
            targets.add(new LocalDoorTarget(e, true));
        }
    }

    @Override
    public IPath getPath(KB kb, OccAgent agent, boolean forceNewPath) {
        IdentityHashSet<WingedEdge> pathDoors;
        Occupant occ = agent.getOcc();
        int globalTargetChanges = this.d_globalTargetChanges;
        this.d_globalTargetChanges = 0;
        double t = kb.getCurrentSimTime();
        ++this.d_numEvals;
        this.d_tBestLocalTargetEvaluated = t;
        this.checkCache(kb, agent);
        if (this.d_room == null) {
            this.d_room = occ.curNode;
        } else if (occ.curNode != this.d_room) {
            System.err.printf("[0x9823ba] Occupant, %s, trying to get locally quickest path in wrong room.  Expected room %s, got room %s%nClearing backtrack prevention.%n", agent.getOcc().name, this.d_room, occ.curNode);
            this.d_room = occ.curNode;
            this.invalidate(agent, true);
        }
        assert (this.d_room != null);
        if (this.d_room == null) {
            System.err.printf("[0x8b0xfe] Occupant %s has null room%n", occ.name);
            return null;
        }
        boolean gtargetMoved = theUtil.testAny(globalTargetChanges, 2);
        if (gtargetMoved) {
            this.d_localTargetInfo = null;
            this.d_prevBestLocalTargetPath = null;
            this.d_validLocalTargets = null;
        }
        LinkedHashSet<ILocalTarget> targets = Collections.EMPTY_SET;
        if (this.d_localTargetInfo == null || this.d_validLocalTargets == null) {
            targets = new LinkedHashSet<ILocalTarget>();
            this.getTargetsInRoom(kb, agent, this.d_room, targets);
        }
        if (this.d_localTargetInfo == null) {
            assert (this.d_globalTarget != null);
            this.d_localTargetInfo = this.getLocalTargetEstimates(kb, agent, targets, this.d_globalTarget, occ.curNode, agent.isSelected() && !(AiUtil.getCurrentSeek(agent) instanceof AssistOccupantsGoal));
        }
        if (this.d_validLocalTargets == null) {
            Iterator<Map.Entry<ILocalTarget, TargetInfo>> backtrackFilter;
            HashMap<ILocalTarget, LQuickPath> validLocalTargetPaths = new HashMap<ILocalTarget, LQuickPath>();
            List<ILocalTarget> validLocalTargets = Collections.EMPTY_LIST;
            while ((validLocalTargets = this.getValidLocalTargets((Collection<ILocalTarget>)targets, Double.POSITIVE_INFINITY, (Predicate<Pair<TargetInfo, Estimate.PointToGoalDist>>)((Object)(backtrackFilter = this.d_backtrack.getFilter(this.d_room))), kb, agent, (Map<ILocalTarget, LQuickPath>)validLocalTargetPaths)).isEmpty() && !Predicates.alwaysTrue(backtrackFilter)) {
                this.clearBacktrack(false);
            }
            this.d_validLocalTargets = validLocalTargets;
            this.d_localTargetInfo.keySet().retainAll(validLocalTargets);
            if (this.d_prevBestLocalTarget != null && !this.d_validLocalTargets.contains(this.d_prevBestLocalTarget)) {
                this.invalidate(agent, false);
            }
            for (Map.Entry<ILocalTarget, TargetInfo> entry : this.d_localTargetInfo.entrySet()) {
                entry.getValue().pLocalTailTargets = this.getLocalTargetsOnTails(this.d_validLocalTargets, entry.getKey());
            }
            this.initEvals(this.d_validLocalTargets, validLocalTargetPaths, this.d_localTargetInfo);
            this.d_prevDistTravelled = agent.getOcc().totalDistanceMeters;
        }
        LQuickPath result = null;
        if (!this.d_validLocalTargets.isEmpty()) {
            BestTarget bestDoorAndPath = this.getBestTarget(kb, agent, forceNewPath);
            if (bestDoorAndPath != null) {
                if (!this.isCurrTarget(bestDoorAndPath.target)) {
                    this.d_prevBestLocalTarget = bestDoorAndPath.target;
                    this.d_tBestLocalTargetFirstChosen = kb.getCurrentSimTime();
                }
                for (Map.Entry<ILocalTarget, TargetInfo> entry : this.d_localTargetInfo.entrySet()) {
                    TargetEval eval = bestDoorAndPath.targetEvals.get(entry.getKey());
                    if (eval == null) continue;
                    ((TargetInfo)entry.getValue()).eval = eval;
                }
                this.d_prevBestLocalTargetPath = result = bestDoorAndPath.path;
            } else if (this.d_prevBestLocalTarget != null) {
                this.invalidate(agent, true);
            }
        }
        IPath resultPath = null;
        if (result == null) {
            pathDoors = Collections.EMPTY_SET;
        } else {
            resultPath = result.path;
            pathDoors = new IdentityHashSet<WingedEdge>();
            for (TriEdge te : result.edges) {
                if (!te.edge.isDoor()) continue;
                pathDoors.add(te.edge);
            }
        }
        this.d_transientEdgeFilter = LocallyQuickest.getTransientEdgeFilter(this.d_room, pathDoors, agent.getOcc().obeyOnewayDoors);
        this.d_prevDistTravelled = agent.getOcc().totalDistanceMeters;
        if (agent.isSelected()) {
            kb.getProps().setDbg(agent.getOcc(), "LOCQUICKEST_TARGETINFO", (Serializable)((Object)this.d_localTargetInfo));
        }
        return resultPath;
    }

    @Override
    public IPathPlanner.IStatus getStatus(KB kb, OccAgent agent) {
        return null;
    }

    private double getLocalQueueTimeEstimate(KB kb, OccAgent agent, ILocalTarget target, double localDist) {
        double tTargetChosen = this.isCurrTarget(target) ? this.d_tBestLocalTargetFirstChosen : Double.POSITIVE_INFINITY;
        return target.getLocalQueueTimeEstimate(kb, agent, this.d_estimator, tTargetChosen, localDist, this.d_localTargetInfo.get((Object)target).tailInfo);
    }

    private double getLocalTravelTimeEstimate(KB kb, OccAgent agent, ILocalTarget target, double localDist) {
        return target.getLocalTravelTimeEstimate(kb, agent, this.d_estimator, localDist);
    }

    private DoorDir getLocalDoorDirection(LocalDoorTarget target) {
        WingedEdge localDoor = target.door;
        Estimate.DoorToGoalValue val = this.d_localTargetInfo.get((Object)target).tailInfo;
        DoorDir dir = val.getDir(localDoor);
        assert (dir != null);
        return dir;
    }

    private LocalTimeEstimateVal getLocalTimeEstimate(KB kb, OccAgent agent, ILocalTarget localTarget, TargetEval eval, Predicate<ILocalTarget> queueEvalFilter, Map<ILocalTarget, LocalTimeEstimateVal> localTimeEstKnownDistMap) {
        double queueTime;
        LocalTimeEstimateVal timeEst = localTimeEstKnownDistMap.get(localTarget);
        if (timeEst != null) {
            return timeEst;
        }
        double localDist = eval.pathLenEst;
        if (Double.isInfinite(localDist)) {
            timeEst = new LocalTimeEstimateVal(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            localTimeEstKnownDistMap.put(localTarget, timeEst);
            return timeEst;
        }
        if (queueEvalFilter.test(localTarget)) {
            queueTime = this.getLocalQueueTimeEstimate(kb, agent, localTarget, localDist);
            eval.tLastEvaluated = kb.getCurrentSimTime();
            eval.queueTimeLastKnown = queueTime;
        } else {
            queueTime = eval.queueTimeLastKnown;
        }
        double travelTime = this.getLocalTravelTimeEstimate(kb, agent, localTarget, localDist);
        LocalTimeEstimateVal localTimeEst = new LocalTimeEstimateVal(queueTime, travelTime);
        localTimeEstKnownDistMap.put(localTarget, localTimeEst);
        return localTimeEst;
    }

    /*
     * WARNING - void declaration
     */
    private ILocalTarget getLowestCostTarget(KB kb, OccAgent agent, Collection<? extends ILocalTarget> targets, Map<ILocalTarget, TargetEval> targetEvals, Map<ILocalTarget, LocalTimeEstimateVal> localTimeEstKnownDistMap, List<ILocalTarget> betterThanPrev) {
        void var12_13;
        TargetCostComparer prevDoorCost = null;
        ArrayList<TargetCostComparer> targetCosts = new ArrayList<TargetCostComparer>();
        double distTravelledInRoom = agent.getOcc().totalDistanceMeters - this.d_distTravelledLastReset;
        for (ILocalTarget iLocalTarget : targets) {
            ANode adjNode;
            TargetEval teval = targetEvals.get(iLocalTarget);
            double localDist = teval.pathLenEst;
            if (localDist < agent.getGeometryRadius()) {
                localDist = 0.0;
            }
            LocalTimeEstimateVal localTimeEst = localTimeEstKnownDistMap.get(iLocalTarget);
            if (this.isCurrTarget(iLocalTarget)) {
                double stopTime = OccAgent.calcStopTime(agent.getVel().length(), agent.getMaxStopAccel(kb));
                localTimeEst = new LocalTimeEstimateVal((Double)localTimeEst.getLocalTimeEstimate().v1, Math.max(0.0, (Double)localTimeEst.getLocalTimeEstimate().v2 - stopTime));
            }
            if (iLocalTarget instanceof LocalDoorTarget && ((LocalDoorTarget)iLocalTarget).door.isElevatorDoor() && (adjNode = ((LocalDoorTarget)iLocalTarget).door.getAdjNode(agent.getOcc().curNode)) != null && adjNode.getElevatorLevel() != null && agent.getOcc().elevatorWaitTime.canWait()) {
                double travelToElevatorTime = this.d_estimator.getTravelTime(kb, agent, localDist);
                localTimeEst = new LocalTimeEstimateVal(0.0, Math.max(0.0, travelToElevatorTime), Collections.singletonMap(AdditionalTimeEstType.TRANSPORT_DOOR, new Pair(localTimeEst.getLocalTimeEstimate().v1, localTimeEst.getLocalTimeEstimate().v2)));
            }
            int priority = 0;
            boolean IS_PREV_BEST = true;
            int IS_DIRECT = 2;
            int IS_TARGET = 4;
            if (this.isCurrTarget(iLocalTarget)) {
                priority |= 1;
            }
            if (this.d_localTargetInfo.get(iLocalTarget).getLocalTailTargets(teval.tailDist).isEmpty()) {
                priority |= 2;
            }
            if (this.isGlobalTarget(iLocalTarget)) {
                priority |= 4;
            }
            TargetCostComparer dc = new TargetCostComparer(kb, agent, iLocalTarget, priority, distTravelledInRoom, localDist, localTimeEst, teval);
            targetCosts.add(dc);
            if (prevDoorCost == null && iLocalTarget.equals(this.d_prevBestLocalTarget)) {
                prevDoorCost = dc;
            }
            if (!KB.DEBUG_PATHS || !agent.isSelected()) continue;
            System.out.printf("%s's location through %s:%n", agent.getOcc().name, iLocalTarget != null ? iLocalTarget.toString() : null);
        }
        Collections.sort(targetCosts, new Comparator<TargetCostComparer>(){

            @Override
            public int compare(TargetCostComparer o1, TargetCostComparer o2) {
                return Double.compare(o1.targetEval.getTailDist(), o2.targetEval.getTailDist());
            }
        });
        if (agent.isSelected()) {
            kb.getProps().setDbg(agent.getOcc(), "LOCQUICKEST_TARGETCOSTS", targetCosts);
        }
        TargetCostComparer bestTarget = (TargetCostComparer)targetCosts.get(targetCosts.size() - 1);
        int n = targetCosts.size() - 2;
        while (var12_13 >= 0) {
            TargetCostComparer dc = (TargetCostComparer)targetCosts.get((int)var12_13);
            if (dc.compareTo(kb, agent, this.d_prevBestLocalTarget, bestTarget) < 0) {
                bestTarget = dc;
            }
            --var12_13;
        }
        if (betterThanPrev != null && this.d_prevBestLocalTarget != null && !bestTarget.target.equals(this.d_prevBestLocalTarget)) {
            assert (prevDoorCost != null);
            for (TargetCostComparer dc : targetCosts) {
                if (dc == prevDoorCost || dc.compareTo(kb, agent, this.d_prevBestLocalTarget, prevDoorCost) >= 0) continue;
                betterThanPrev.add(dc.target);
            }
            assert (!betterThanPrev.isEmpty());
        }
        return bestTarget.target;
    }

    protected static <CollT extends Collection<WingedEdge>> CollT getDoorsOnPath(LQuickPath p, CollT coll) {
        if (p == null) {
            return coll;
        }
        for (TriEdge te : p.edges) {
            if (!te.edge.isDoor()) continue;
            coll.add((WingedEdge)te.edge);
        }
        return coll;
    }

    private double getNextQueueEvalTime(KB kb, OccAgent agent, ILocalTarget localDoor, Vector3d prevBestDoorDir, double tLastEvaluated) {
        if (prevBestDoorDir == null || localDoor.equals(this.d_prevBestLocalTarget)) {
            return kb.getCurrentSimTime();
        }
        Vector3d naiveTargetVec = localDoor.getNaiveDistanceVec(kb, agent, this.d_room);
        Util.safeNormalize(naiveTargetVec, 1.0E-9);
        if (prevBestDoorDir.dot(naiveTargetVec) >= 0.0) {
            return kb.getCurrentSimTime();
        }
        double minRepathDT = kb.getParams().min_repath_dt;
        double maxRepathDT = kb.getParams().max_repath_dt;
        double avgTime = kb.getParams().local_speed_avg_time;
        double speed = agent.getAverageSpeedAlongPath(kb, avgTime);
        double speedFrac = speed / (double)agent.getOcc().maxVel;
        double evalDT = theUtil.lerp(minRepathDT, maxRepathDT, speedFrac);
        return tLastEvaluated + evalDT;
    }

    private Vector3d getNaiveDir(KB kb, OccAgent agent, ILocalTarget target) {
        Vector3d vec = target.getNaiveDistanceVec(kb, agent, this.d_room);
        Util.safeNormalize(vec, 1.0E-9);
        return vec;
    }

    private List<ILocalTarget> getInitialTestTargets(KB kb, OccAgent agent, boolean updateCurrDoorPath, double distTravelled, Map<ILocalTarget, TargetEval> targetEvals, Map<ILocalTarget, LQuickPath> paths) {
        for (ILocalTarget target : this.d_validLocalTargets) {
            TargetInfo ti = this.d_localTargetInfo.get(target);
            TargetEval eval = ti.eval.clone();
            targetEvals.put(target, eval);
            Vector3d naiveTargetVec = target.getNaiveDistanceVec(kb, agent, this.d_room);
            double naiveTargetDist = Util.safeNormalize(naiveTargetVec, 1.0E-9);
            eval.updatePathLenEst(naiveTargetDist, distTravelled);
        }
        return this.getTestTargets(kb, agent, this.d_validLocalTargets, updateCurrDoorPath, false, targetEvals, paths);
    }

    private List<ILocalTarget> getTestTargets(KB kb, OccAgent agent, Collection<? extends ILocalTarget> targets, boolean updateCurrDoorPath, boolean precisePathLens, Map<ILocalTarget, TargetEval> targetEvals, Map<ILocalTarget, LQuickPath> paths) {
        ArrayDeque<? extends ILocalTarget> targetStack = new ArrayDeque<ILocalTarget>(targets);
        HashSet<? extends ILocalTarget> closedTargets = new HashSet<ILocalTarget>(targetStack);
        ArrayList<ILocalTarget> testTargets = new ArrayList<ILocalTarget>();
        while (!targetStack.isEmpty()) {
            ILocalTarget target = (ILocalTarget)targetStack.removeFirst();
            TargetEval eval = targetEvals.get(target);
            if (target.equals(this.d_prevBestLocalTarget) || precisePathLens && !eval.isLenEstExact()) {
                this.evalLocalPath(kb, agent, target, eval, updateCurrDoorPath, paths);
            }
            if (!eval.hasPath()) continue;
            testTargets.add(target);
            TargetInfo ti = this.d_localTargetInfo.get(target);
            for (ILocalTarget tailTarget : ti.getLocalTailTargets(eval.tailDist)) {
                if (!closedTargets.add(tailTarget)) continue;
                targetStack.addLast(tailTarget);
            }
        }
        return testTargets;
    }

    private BestTarget getBestTarget(KB kb, OccAgent agent, boolean updateCurrTargetPath) {
        HashMap<ILocalTarget, LQuickPath> paths;
        HashMap<ILocalTarget, TargetEval> targetEvals;
        double distTravelled = agent.getOcc().totalDistanceMeters - this.d_prevDistTravelled;
        boolean newLoc = distTravelled > 0.001;
        List<ILocalTarget> testTargets = this.getInitialTestTargets(kb, agent, updateCurrTargetPath |= newLoc, distTravelled, targetEvals = new HashMap<ILocalTarget, TargetEval>(), paths = new HashMap<ILocalTarget, LQuickPath>());
        if (testTargets.isEmpty() || this.d_prevBestLocalTarget != null && paths.get(this.d_prevBestLocalTarget) == null) {
            return null;
        }
        Vector3d prevBestDoorDir = this.d_prevBestLocalTarget != null ? this.getNaiveDir(kb, agent, this.d_prevBestLocalTarget) : null;
        IdentityHashSet queueUpdateTargets = new IdentityHashSet();
        for (ILocalTarget localTarget : testTargets) {
            double tNextEval = this.getNextQueueEvalTime(kb, agent, localTarget, prevBestDoorDir, ((TargetEval)targetEvals.get((Object)localTarget)).tLastEvaluated);
            if (!theUtil.ge(kb.getCurrentSimTime(), tNextEval, 1.0E-6)) continue;
            queueUpdateTargets.add(localTarget);
        }
        Predicate<ILocalTarget> queueUpdateFilter = Filters.accept(queueUpdateTargets);
        ArrayList<ILocalTarget> betterThanPrev = new ArrayList<ILocalTarget>();
        ILocalTarget best = this.getBestTarget(kb, agent, testTargets, true, targetEvals, queueUpdateFilter, betterThanPrev);
        if (!(this.d_prevBestLocalTarget == null || best != null && this.isCurrTarget(best))) {
            assert (!betterThanPrev.isEmpty());
            betterThanPrev.add(this.d_prevBestLocalTarget);
            testTargets = this.getTestTargets(kb, agent, betterThanPrev, updateCurrTargetPath, true, targetEvals, paths);
            assert (!testTargets.isEmpty());
            queueUpdateFilter = Predicates.alwaysTrue();
            best = this.getBestTarget(kb, agent, testTargets, false, targetEvals, queueUpdateFilter, null);
        }
        if (best == null) {
            return null;
        }
        this.evalLocalPath(kb, agent, best, (TargetEval)targetEvals.get(best), updateCurrTargetPath, paths);
        assert (paths.containsKey(best));
        LQuickPath path = (LQuickPath)paths.get(best);
        if (path == null) {
            return null;
        }
        if (agent.isSelected()) {
            kb.getProps().setDbg(agent.getOcc(), "LOCQUICKEST_BEST", (Serializable)((Object)best));
            kb.getProps().setDbg(agent.getOcc(), "LOCQUICKEST_TARGETEVALS", targetEvals);
        }
        return new BestTarget(best, path, targetEvals);
    }

    private ILocalTarget getBestTarget(KB kb, OccAgent agent, Collection<? extends ILocalTarget> targets, boolean isAllTargets, Map<ILocalTarget, TargetEval> targetEvals, Predicate<ILocalTarget> queueEvalFilter, List<ILocalTarget> betterThanPrev) {
        assert (!targets.isEmpty());
        if (targets.size() == 1) {
            ILocalTarget onlyTarget = targets.iterator().next();
            return onlyTarget;
        }
        int noFlowCount = 0;
        HashMap<ILocalTarget, LocalTimeEstimateVal> localTimeEstMap = new HashMap<ILocalTarget, LocalTimeEstimateVal>();
        for (ILocalTarget iLocalTarget : targets) {
            LocalTimeEstimateVal est = this.getLocalTimeEstimate(kb, agent, iLocalTarget, targetEvals.get(iLocalTarget), queueEvalFilter, localTimeEstMap);
            if (!Double.isInfinite((Double)est.getLocalTimeEstimate().v1)) continue;
            ++noFlowCount;
        }
        if (isAllTargets) {
            if (noFlowCount == targets.size()) {
                this.d_estimator.clearAllMemory();
            }
            this.d_estimator.updateEstimates(kb, targets);
        }
        for (ILocalTarget iLocalTarget : targets) {
            TargetInfo ti = this.d_localTargetInfo.get(iLocalTarget);
            TargetEval eval = targetEvals.get(iLocalTarget);
            Collection<ILocalTarget> tailTargets = ti.getLocalTailTargets(eval.tailDist);
            if (tailTargets.isEmpty()) continue;
            LocalTimeEstimateVal tLocal = (LocalTimeEstimateVal)localTimeEstMap.get(iLocalTarget);
            for (ILocalTarget tailTarget : tailTargets) {
                LocalTimeEstimateVal tTailTarget = this.getLocalTimeEstimate(kb, agent, tailTarget, targetEvals.get(tailTarget), queueEvalFilter, localTimeEstMap);
                tLocal.setQueueTime((Double)tLocal.getLocalTimeEstimate().v1 + (Double)tTailTarget.getLocalTimeEstimate().v1);
            }
        }
        ILocalTarget bestTarget = this.getLowestCostTarget(kb, agent, targets, targetEvals, localTimeEstMap, betterThanPrev);
        if (KB.DEBUG_PATHS && agent.isSelected()) {
            System.out.printf("**** Selected Door: %s ****%n", bestTarget.toString());
        }
        return bestTarget;
    }

    private Map<ILocalTarget, TargetInfo> getLocalTargetEstimates(KB kb, OccAgent agent, Collection<ILocalTarget> localTargets, IGlobalTarget globalTarget, ANode currentNode, boolean printOutput) {
        LinkedHashMap<ILocalTarget, TargetInfo> doorToGoalDist = new LinkedHashMap<ILocalTarget, TargetInfo>();
        ArrayList<LTargetFuture> dtdBatches = new ArrayList<LTargetFuture>(localTargets.size());
        for (ILocalTarget localTarget : localTargets) {
            if (this.d_globalTarget.isLocalTarget(localTarget)) {
                Estimate.DoorToGoalValue bestVal;
                if (localTarget instanceof LocalDoorTarget) {
                    LocalDoorTarget ldt = (LocalDoorTarget)localTarget;
                    bestVal = Estimate.DoorToGoalValue.zeroPath(ldt.door, new PathGen.EdgeGoal(ldt.door), currentNode);
                } else {
                    bestVal = new Estimate.DoorToGoalValue(null, null, true, Collections.singletonList(new Estimate.PointToGoalDist(null, 0.5, 0.0, 0.0, null, null, new TriPoint[0], Collections.emptyList())));
                }
                TargetInfo dm = new TargetInfo(localTarget, this.d_globalTarget, bestVal);
                doorToGoalDist.put(localTarget, dm);
                continue;
            }
            assert (localTarget instanceof LocalDoorTarget);
            LocalDoorTarget doorTarget = (LocalDoorTarget)localTarget;
            Future<Estimate.DoorToGoalValue> future = this.d_globalTarget.getDistFromLocalTarget(kb, agent, doorTarget, currentNode);
            dtdBatches.add(new LTargetFuture(doorTarget, future));
        }
        for (LTargetFuture ltfuture : dtdBatches) {
            Estimate.DoorToGoalValue exitVal;
            LocalDoorTarget localTarget = ltfuture.ltarget;
            try {
                exitVal = ltfuture.future.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            TargetInfo dm = new TargetInfo(localTarget, this.d_globalTarget, exitVal);
            doorToGoalDist.put(localTarget, dm);
        }
        if (printOutput) {
            PrintStream out = kb.getParams().out;
            out.println("Door to Goal Distance Map for Selected Agent:");
            this.printDoorToGoalDist(doorToGoalDist, kb.getParams().out);
        }
        return doorToGoalDist;
    }

    private void printDoorToGoalDist(Map<ILocalTarget, TargetInfo> doorToGoalDist, PrintStream out) {
        for (ILocalTarget e : doorToGoalDist.keySet()) {
            TargetInfo val = doorToGoalDist.get(e);
            String v1Name = e.toString();
            String v2Name = val.target.toString();
            out.printf("localTarget=%s; globalTarget=%s; min_tail_dist=%.2f%n", v1Name, v2Name, val.tailInfo.minDist.dist);
        }
        out.printf("%n", new Object[0]);
    }

    private Map<Estimate.PointToGoalDist, Collection<ILocalTarget>> getLocalTargetsOnTails(Collection<ILocalTarget> validLocalTargets, ILocalTarget localDoor) {
        IdentityHashMap<Estimate.PointToGoalDist, Collection<ILocalTarget>> result = new IdentityHashMap<Estimate.PointToGoalDist, Collection<ILocalTarget>>();
        for (Estimate.PointToGoalDist tdist : this.d_localTargetInfo.get((Object)localDoor).tailInfo.dists) {
            ArrayList<ILocalTarget> additionalTargets = new ArrayList<ILocalTarget>();
            Set<Pair<WingedEdge, DoorDir>> usedDoors = tdist.usedDoors;
            for (ILocalTarget target : validLocalTargets) {
                DoorDir dir;
                LocalDoorTarget doorTarget;
                if (!(target instanceof LocalDoorTarget) || target.equals(localDoor) || !usedDoors.contains(new Pair<WingedEdge, DoorDir>(doorTarget.door, dir = this.getLocalDoorDirection(doorTarget = (LocalDoorTarget)target)))) continue;
                additionalTargets.add(target);
            }
            if (additionalTargets.isEmpty()) continue;
            additionalTargets.trimToSize();
            result.put(tdist, additionalTargets);
        }
        if (result.isEmpty()) {
            return Collections.emptyMap();
        }
        return result;
    }

    private void initEvals(Collection<ILocalTarget> validLocalTargets, Map<ILocalTarget, LQuickPath> paths, Map<ILocalTarget, TargetInfo> infos) {
        for (ILocalTarget target : validLocalTargets) {
            TargetInfo ti = infos.get(target);
            LQuickPath path = paths.get(target);
            assert (path != null);
            ti.eval.setPathLength(path.getLocalLength(), path.tailDist != null ? path.tailDist : TargetEval.irrelevantTailDist());
        }
    }

    private boolean isGlobalTarget(ILocalTarget ltarget) {
        return this.d_globalTarget.isLocalTarget(ltarget);
    }

    public void clearBacktrack(boolean clearAll) {
        if (this.d_backtrack != null) {
            this.d_backtrack.clearNextBacktrack(clearAll);
        }
    }

    @Override
    public void setRoom(ANode room, OccAgent agent) {
        if (room != this.d_room) {
            this.d_room = room;
            this.invalidate(agent, true);
        }
    }

    public static enum AdditionalTimeEstType {
        NONE,
        TRANSPORT_DOOR;

    }

    public static class LocalTimeEstimateVal {
        private Pair<Double, Double> timeEstimate;
        private final Map<AdditionalTimeEstType, Pair<Double, Double>> additionalTimeEst;

        public LocalTimeEstimateVal(double queueTime, double travelTime) {
            this(queueTime, travelTime, null);
        }

        public void setTravelTime(double travelTime) {
            this.timeEstimate = new Pair(this.timeEstimate.v1, travelTime);
        }

        public void setQueueTime(double queueTime) {
            this.timeEstimate = new Pair(queueTime, this.timeEstimate.v2);
        }

        public LocalTimeEstimateVal(double queueTime, double travelTime, Map<AdditionalTimeEstType, Pair<Double, Double>> additionalTimeEst) {
            this.timeEstimate = new Pair<Double, Double>(queueTime, travelTime);
            this.additionalTimeEst = additionalTimeEst;
        }

        public Pair<Double, Double> getLocalTimeEstimate() {
            return this.getLocalTimeEstimate(AdditionalTimeEstType.NONE);
        }

        public Pair<Double, Double> getLocalTimeEstimate(AdditionalTimeEstType type) {
            if (type == AdditionalTimeEstType.NONE || this.additionalTimeEst == null || !this.additionalTimeEst.containsKey((Object)type)) {
                return this.timeEstimate;
            }
            return this.additionalTimeEst.get((Object)type);
        }

        public double getTotalTimeEst(AdditionalTimeEstType type) {
            Pair<Double, Double> p = this.getLocalTimeEstimate(type);
            return (Double)p.v1 + (Double)p.v2;
        }

        private static AdditionalTimeEstType getTimeEstTypeFor(OccAgent agent, ILocalTarget target) {
            return target instanceof LocalDoorTarget && ((LocalDoorTarget)target).door.isTransportDoor() && !agent.getOcc().curNode.isTransportNode() ? AdditionalTimeEstType.TRANSPORT_DOOR : AdditionalTimeEstType.NONE;
        }
    }

    private static class Backtrack
    implements Serializable {
        static final long serialVersionUID = 1L;
        private final Set<ANode> d_previousVisitedRooms = new IdentityHashSet<ANode>();
        private final Set<WingedEdge> d_previousDoors = new IdentityHashSet<WingedEdge>();
        private EnterDir d_enterDir = EnterDir.UNKNOWN;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(LocallyQuickest lq, DoorQueue crossedQueue, Point3d crossLoc, ANode destNode) {
            this.d_enterDir = EnterDir.UNKNOWN;
            try {
                WingedEdge doorEdge;
                boolean passedThroughPlannedDoor;
                boolean enteredPlannedRoom;
                if (lq.d_room == null) {
                    return;
                }
                if (lq.d_prevBestLocalTarget == null || lq.d_localTargetInfo == null) {
                    this.d_previousVisitedRooms.add(lq.d_room);
                    return;
                }
                if (!lq.d_localTargetInfo.containsKey(lq.d_prevBestLocalTarget)) {
                    return;
                }
                boolean bl = enteredPlannedRoom = lq.d_prevBestLocalTarget instanceof LocalDoorTarget && ((LocalDoorTarget)((LocallyQuickest)lq).d_prevBestLocalTarget).door.getAdjNode(lq.d_room) == destNode;
                if (enteredPlannedRoom) {
                    this.d_previousVisitedRooms.add(lq.d_room);
                    if (!crossedQueue.getNode().getDoorEdges().isEmpty()) {
                        WingedEdge doorEdge2 = crossedQueue.getNode().getDoorEdges().get(0);
                        LocalDoorTarget dt = new LocalDoorTarget(doorEdge2);
                        TargetInfo ti = (TargetInfo)lq.d_localTargetInfo.get(dt);
                        if (ti != null) {
                            Estimate.PointToGoalDist tailDist;
                            DoorDir naturalDir;
                            DoorDir crossDir = doorEdge2.getDir(destNode);
                            this.d_enterDir = crossDir == (naturalDir = ti.getNaturalDir(tailDist = ti.tailInfo.getDistFrom(crossLoc))) ? EnterDir.NATURAL : EnterDir.UNNATURAL;
                        }
                    }
                }
                boolean bl2 = passedThroughPlannedDoor = lq.d_prevBestLocalTarget instanceof LocalDoorTarget && ((LocalDoorTarget)((LocallyQuickest)lq).d_prevBestLocalTarget).door.data.node == crossedQueue.getNode();
                if (passedThroughPlannedDoor) {
                    if (!crossedQueue.getNode().getDoorEdges().isEmpty()) {
                        doorEdge = crossedQueue.getNode().getDoorEdges().get(0);
                        this.d_previousDoors.add(doorEdge);
                    }
                } else {
                    if (!crossedQueue.getNode().getDoorEdges().isEmpty()) {
                        doorEdge = crossedQueue.getNode().getDoorEdges().get(0);
                        this.d_previousDoors.remove(doorEdge);
                    }
                    if (KB.DEBUG_PATHS || KB.DEBUG_STEERING) {
                        System.err.printf("Occupant accidently enters %s, not updating backtrack prevent.%n", destNode);
                    }
                }
            }
            finally {
                this.d_previousVisitedRooms.remove(destNode);
            }
        }

        public void clearNextBacktrack(boolean clearAll) {
            if (!this.d_previousVisitedRooms.isEmpty()) {
                this.d_previousVisitedRooms.clear();
                if (!clearAll) {
                    return;
                }
            }
            if (!this.d_previousDoors.isEmpty()) {
                this.d_previousDoors.clear();
                return;
            }
        }

        public Predicate<Pair<TargetInfo, Estimate.PointToGoalDist>> getFilter(ANode currNode) {
            if (this.d_previousVisitedRooms.isEmpty() && this.d_previousDoors.isEmpty()) {
                return Filters.acceptAll();
            }
            return p -> {
                TargetInfo o = (TargetInfo)p.v1;
                Estimate.PointToGoalDist td = (Estimate.PointToGoalDist)p.v2;
                if (!this.d_previousDoors.isEmpty() && o.ltarget instanceof LocalDoorTarget) {
                    for (Pair<WingedEdge, DoorDir> usedDoor : td.usedDoors) {
                        if (!this.d_previousDoors.contains(usedDoor.v1)) continue;
                        return false;
                    }
                }
                if (this.d_enterDir == EnterDir.NATURAL && o.ltarget instanceof LocalDoorTarget) {
                    LocalDoorTarget doorTarget = (LocalDoorTarget)o.ltarget;
                    DoorDir outDir = doorTarget.door.getDir(currNode).opposite();
                    if (o.getNaturalDir(td) == outDir) {
                        return true;
                    }
                }
                if (!this.d_previousVisitedRooms.isEmpty()) {
                    for (Pair<WingedEdge, DoorDir> usedDoor : td.usedDoors) {
                        ANode n1 = ((WingedEdge)usedDoor.v1).getNode1();
                        ANode n2 = ((WingedEdge)usedDoor.v1).getNode2();
                        if (!this.d_previousVisitedRooms.contains(n1) && !this.d_previousVisitedRooms.contains(n2)) continue;
                        return false;
                    }
                }
                return true;
            };
        }

        private static enum EnterDir {
            UNKNOWN,
            NATURAL,
            UNNATURAL;

        }
    }

    public static class TargetEval
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        public double tFlowrateReset;
        public double tLastEvaluated;
        public double queueTimeLastKnown;
        public double pathLenLastKnown;
        public double pathLenEst;
        public Estimate.PointToGoalDist tailDist;
        private Double tailTime = null;

        public TargetEval(double tFlowrateReset) {
            this(tFlowrateReset, Double.NEGATIVE_INFINITY, 0.0, Double.NaN, Double.NaN, TargetEval.irrelevantTailDist());
        }

        public TargetEval(double tFlowrateReset, double tLastEvaluated, double queueTimeLastKnown, double pathLenLastKnown, double pathLenEst, Estimate.PointToGoalDist tailDist) {
            this.tFlowrateReset = tFlowrateReset;
            this.tLastEvaluated = tLastEvaluated;
            this.queueTimeLastKnown = queueTimeLastKnown;
            this.pathLenLastKnown = pathLenLastKnown;
            this.pathLenEst = pathLenEst;
            this.tailDist = tailDist;
        }

        public static Estimate.PointToGoalDist irrelevantTailDist() {
            return new Estimate.PointToGoalDist(null, 0.5, 0.0, 0.0, null, null, new TriPoint[0], Collections.emptyList());
        }

        protected TargetEval clone() {
            try {
                return (TargetEval)super.clone();
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                return null;
            }
        }

        public boolean isInitialized() {
            return !Double.isNaN(this.pathLenEst);
        }

        public void setPathLength(double len, Estimate.PointToGoalDist tailDist) {
            this.pathLenEst = this.pathLenLastKnown = len;
            if (this.tailDist != tailDist) {
                this.tailDist = tailDist;
                this.tailTime = null;
            }
        }

        public boolean hasPath() {
            return !Double.isInfinite(this.pathLenEst);
        }

        public boolean isLenEstExact() {
            return this.isInitialized() && theUtil.eq(this.pathLenEst, this.pathLenLastKnown, 0.001);
        }

        public void updatePathLenEst(double minDist, double distTravelled) {
            if (!this.isInitialized()) {
                this.pathLenEst = minDist;
            } else if (this.hasPath()) {
                this.pathLenEst = Math.max(minDist, this.pathLenEst - distTravelled);
            }
        }

        public double getTailDist() {
            return this.tailDist.dist;
        }

        public double getTailTime(ElevatorModel elevatorModel, Occupant occ) {
            if (this.tailTime == null) {
                if (this.tailDist.path == null || this.tailDist.path.length == 0) {
                    this.tailTime = 0.0;
                } else {
                    double curDist = 0.0;
                    double totalTime = 0.0;
                    SpeedModifier curSpeedModifier = this.tailDist.path[0].tri.getSpeedModifier();
                    for (int i = 0; i < this.tailDist.path.length - 1; ++i) {
                        TriPoint tp1 = this.tailDist.path[i];
                        TriPoint tp2 = this.tailDist.path[i + 1];
                        if (tp1.tri.node.isTransportNode()) {
                            totalTime += elevatorModel.getTransportTime(tp1.tri.node.getElevatorLevel());
                            continue;
                        }
                        if (theUtil.equal(tp2.tri.getSpeedModifier(), curSpeedModifier) && !tp2.tri.node.isTransportNode() && i != this.tailDist.path.length - 2) {
                            curDist += tp1.p.distance(tp2.p);
                            continue;
                        }
                        double speed = curSpeedModifier != null ? curSpeedModifier.getAbsoluteSpeed(occ.maxVel, occ.walkOnMovingTerrain) : (double)occ.maxVel;
                        totalTime += (curDist += tp1.p.distance(tp2.p)) / speed;
                        curSpeedModifier = tp2.tri.getSpeedModifier();
                        curDist = 0.0;
                    }
                    this.tailTime = totalTime;
                }
            }
            return this.tailTime;
        }
    }

    public static class TargetInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final ILocalTarget ltarget;
        public final IGlobalTarget target;
        public final Estimate.DoorToGoalValue tailInfo;
        public TargetEval eval;
        public Map<Estimate.PointToGoalDist, Collection<ILocalTarget>> pLocalTailTargets;

        public TargetInfo(ILocalTarget ltarget, IGlobalTarget target, Estimate.DoorToGoalValue targetDist) {
            this.ltarget = ltarget;
            this.target = target;
            this.tailInfo = targetDist;
            this.eval = new TargetEval(0.0);
            this.pLocalTailTargets = Collections.emptyMap();
        }

        public DoorDir getNaturalDir(Estimate.PointToGoalDist tailDist) {
            return this.tailInfo.getNaturalDir(tailDist);
        }

        public Collection<ILocalTarget> getLocalTailTargets(Estimate.PointToGoalDist tdist) {
            return this.pLocalTailTargets.getOrDefault(tdist, Collections.emptyList());
        }
    }

    private static class BestTarget {
        public final ILocalTarget target;
        public final LQuickPath path;
        public final Map<ILocalTarget, TargetEval> targetEvals;

        public BestTarget(ILocalTarget target, LQuickPath path, Map<ILocalTarget, TargetEval> targetEvals) {
            this.target = target;
            this.path = path;
            this.targetEvals = targetEvals;
        }
    }

    protected static class LQuickPath
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final IPath path;
        public final List<TriEdge> edges;
        public final Estimate.PointToGoalDist tailDist;

        public LQuickPath(IPath path, List<TriEdge> edges, Estimate.PointToGoalDist tailDist) {
            this.path = path;
            this.edges = edges;
            this.tailDist = tailDist;
        }

        public double getLocalLength() {
            return this.path.length(false);
        }
    }

    private static class LTargetFuture {
        public final LocalDoorTarget ltarget;
        public final Future<Estimate.DoorToGoalValue> future;

        public LTargetFuture(LocalDoorTarget ltarget, Future<Estimate.DoorToGoalValue> future) {
            this.ltarget = ltarget;
            this.future = future;
        }
    }

    public static class TargetCostComparer {
        public final ILocalTarget target;
        public final double distTravelled;
        public final LocalTimeEstimateVal localTimeEst;
        public final double localDist;
        public final int priority;
        public final TargetEval targetEval;

        public TargetCostComparer(KB kb, OccAgent agent, ILocalTarget target, int priority, double distTravelled, double localDist, LocalTimeEstimateVal localTimeEst, TargetEval targetEval) {
            this.target = target;
            this.distTravelled = distTravelled;
            this.priority = priority;
            this.localTimeEst = localTimeEst;
            this.localDist = localDist;
            this.targetEval = targetEval;
        }

        private static boolean equal(double v1, double v2, double minTol, double tolFrac) {
            double tol = Math.max(minTol, Math.max(v1, v2) * tolFrac);
            return theUtil.eq(v1, v2, tol);
        }

        public int compareTo(KB kb, OccAgent agent, ILocalTarget currTarget, TargetCostComparer o) {
            double cost2;
            double tailDist2;
            double minTailTol = agent.getGeometryRadius() * 2.0;
            double tailTolFrac = kb.getParams().local_tail_tol_frac;
            double tailDist1 = this.targetEval.getTailDist();
            if (TargetCostComparer.equal(tailDist1, tailDist2 = o.targetEval.getTailDist(), minTailTol, tailTolFrac)) {
                tailDist1 = tailDist2 = Math.min(tailDist1, tailDist2);
            }
            AdditionalTimeEstType type1 = LocalTimeEstimateVal.getTimeEstTypeFor(agent, o.target);
            AdditionalTimeEstType type2 = LocalTimeEstimateVal.getTimeEstTypeFor(agent, this.target);
            double queueTime1 = (Double)this.localTimeEst.getLocalTimeEstimate((AdditionalTimeEstType)type1).v1;
            double queueTime2 = (Double)o.localTimeEst.getLocalTimeEstimate((AdditionalTimeEstType)type2).v1;
            double cost1 = LocalDoorCosts.getCost(kb, agent, this.target.equals(currTarget), this.distTravelled, this.localDist, tailDist1, queueTime1, (Double)this.localTimeEst.getLocalTimeEstimate((AdditionalTimeEstType)type1).v2, this.targetEval);
            if (theUtil.eq(cost1, cost2 = LocalDoorCosts.getCost(kb, agent, o.target.equals(currTarget), o.distTravelled, o.localDist, tailDist2, queueTime2, (Double)o.localTimeEst.getLocalTimeEstimate((AdditionalTimeEstType)type2).v2, o.targetEval), 1.0E-6) || Double.isInfinite(cost1) && Double.isInfinite(cost2)) {
                return this.priority < o.priority || this.priority == o.priority && o.localDist < this.localDist ? 1 : -1;
            }
            return cost2 < cost1 ? 1 : -1;
        }

        public String toString() {
            return this.target.toString();
        }
    }
}

