/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.locallyquickest;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.IElevator;
import inferno.data2.Mesh;
import inferno.data2.Occupant;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.sim.ElevatorModel;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.DoorSeek;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.Estimate;
import inferno.sim.path.ExitSeek;
import inferno.sim.path.IPath;
import inferno.sim.path.IPathSeek;
import inferno.sim.path.PartialPath;
import inferno.sim.path.Path;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.path.WaypointSeek;
import inferno.sim.steering.locallyquickest.IGlobalTarget;
import inferno.sim.steering.locallyquickest.ILocalTarget;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;

public class LocalDoorTarget
implements ILocalTarget,
Serializable {
    private static final long serialVersionUID = 1L;
    public final WingedEdge door;
    public final boolean isVirtual;

    public LocalDoorTarget(WingedEdge door) {
        this(door, false);
    }

    public LocalDoorTarget(WingedEdge door, boolean isVirtual) {
        this.door = door;
        this.isVirtual = isVirtual;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof LocalDoorTarget && ((LocalDoorTarget)obj).door == this.door;
    }

    public int hashCode() {
        return 0x9243A834 ^ this.door.hashCode();
    }

    @Override
    public Vector3d getNaiveDistanceVec(KB kb, OccAgent agent, ANode room) {
        return kb.getPathEstimates().getDistanceField(kb, room, this.door).getValue(agent.getLoc());
    }

    @Override
    public boolean isReachable(KB kb, OccAgent agent, Predicate<PathChange> pathPlanningFilter) {
        PathGen.EdgeGoal pathGoal = new PathGen.EdgeGoal(this.door);
        PathGen.IAStarResult searchResult = this.getPathAStar(kb, agent, pathPlanningFilter, pathGoal);
        return searchResult instanceof PathGen.AStarSuccess;
    }

    @Override
    public LocallyQuickest.LQuickPath getLocalPath(KB kb, OccAgent agent, Predicate<PathChange> pathPlanningFilter, IGlobalTarget gTarget, Estimate.DoorToGoalValue tailInfo) {
        Pair<IPath, Estimate.PointToGoalDist> p;
        PathGen.EdgeGoal pathGoal = new PathGen.EdgeGoal(this.door);
        Mesh m = kb.getMesh();
        Occupant occ = agent.getOcc();
        PathGen.IAStarResult searchResult = this.getPathAStar(kb, agent, pathPlanningFilter, pathGoal);
        if (searchResult instanceof PathGen.AStarFailure) {
            return null;
        }
        Pair<List<TriPoint>, List<TriEdge>> pathResult = PathGen.getPath(m, occ.tri, occ.loc, pathGoal, occ.bodyShape.getGeomRadius(), (PathGen.AStarSuccess)searchResult);
        if (pathResult == null) {
            return null;
        }
        ArrayList<TriEdge> pathEdges = new ArrayList<TriEdge>((Collection)pathResult.v2);
        List pts = (List)pathResult.v1;
        boolean isGTarget = gTarget.isLocalTarget(this);
        if (isGTarget) {
            Predicate<WingedEdge> edgeFilter = LocalDoorTarget.getEdgeFilter(pathEdges);
            p = LocalDoorTarget.createPathToExit(m, pts, this.door, occ.bodyShape.getGeomRadius(), edgeFilter);
        } else {
            DoorDir dir = tailInfo.getDir(this.door);
            assert (dir != null);
            TriEdge addEdge = LocalDoorTarget.getFirstEdgeInRoom(this.door, dir);
            pathEdges.add(addEdge);
            Point3d ptBeyond = addEdge.edge.base.midpoint();
            DoorDir doorDir = dir;
            Predicate<WingedEdge> edgeFilter = LocalDoorTarget.getEdgeFilter(pathEdges);
            p = this.createPathToInternalDoor(agent, m, pts, this.door, doorDir, ptBeyond, edgeFilter, tailInfo);
        }
        pathEdges.trimToSize();
        return new LocallyQuickest.LQuickPath((IPath)p.v1, pathEdges, (Estimate.PointToGoalDist)p.v2);
    }

    private static Predicate<WingedEdge> getEdgeFilter(List<TriEdge> pathEdges) {
        ArrayList<ANode> allowedDoorNodes = new ArrayList<ANode>(2);
        for (TriEdge edge : pathEdges) {
            if (!edge.edge.isDoor()) continue;
            allowedDoorNodes.add(edge.edge.data.node);
        }
        allowedDoorNodes.trimToSize();
        return EdgeFilters.filterDoors(Filters.accept(allowedDoorNodes));
    }

    public static TriEdge getFirstEdgeInRoom(WingedEdge edge, DoorDir dir) {
        Tri firstTri = edge.getDestTri(dir);
        if (firstTri == null) {
            firstTri = edge.getSrcTri(dir);
        }
        WingedEdge firstEdge = null;
        for (WingedEdgeUse eu : firstTri.eu) {
            if (eu.wedge == edge || firstEdge != null && eu.wedge.isBoundary()) continue;
            firstEdge = eu.wedge;
        }
        assert (firstEdge != null);
        return new TriEdge(firstTri, firstEdge);
    }

    private PathGen.IAStarResult getPathAStar(KB kb, OccAgent agent, Predicate<PathChange> pathPlanningFilter, PathGen.IPathGoal pathGoal) {
        Occupant occ = agent.getOcc();
        Mesh m = kb.getMesh();
        if (!pathPlanningFilter.test(new PathChange(occ.tri, this.door)) && this.door.data.node.isClosed(kb, agent) && Double.isInfinite(this.door.data.node.getNextOpenTime(kb, agent))) {
            return null;
        }
        return PathGen.getPathAStarDetailed(m, occ.tri, null, null, occ.loc, pathGoal, occ.bodyShape.getGeomRadius(), Double.MAX_VALUE, pathPlanningFilter);
    }

    private static Pair<IPath, Estimate.PointToGoalDist> createPathToExit(Mesh navMesh, List<TriPoint> pts, WingedEdge exitDoor, double occRadius, Predicate<WingedEdge> edgeFilter) {
        assert (exitDoor.isExit());
        if (pts.size() == 1) {
            pts.add(pts.get(0));
        }
        ArrayList<IPathSeek> path = new ArrayList<IPathSeek>(pts.size());
        for (int m = 0; m < pts.size() - 1; ++m) {
            path.add(new WaypointSeek(pts.get(m), edgeFilter));
        }
        TriPoint lastPt = pts.get(pts.size() - 1);
        path.add(new ExitSeek(navMesh, exitDoor, lastPt, occRadius, edgeFilter));
        double lastt = exitDoor.base.get(lastPt.p);
        return new Pair<IPath, Estimate.PointToGoalDist>(new Path(path), Estimate.PointToGoalDist.zeroPath(exitDoor, lastt, exitDoor.getExitDir()));
    }

    private Pair<IPath, Estimate.PointToGoalDist> createPathToInternalDoor(OccAgent agent, Mesh navMesh, List<TriPoint> pts, WingedEdge door, DoorDir dir, Point3d ptBeyond, Predicate<WingedEdge> edgeFilter, Estimate.DoorToGoalValue tailInfo) {
        if ((pts = new ArrayList<TriPoint>(pts)).size() == 1) {
            pts.add(pts.get(0));
        }
        ArrayList<IPathSeek> path = new ArrayList<IPathSeek>(pts.size());
        for (int m = 0; m < pts.size() - 1; ++m) {
            path.add(new WaypointSeek(pts.get(m), edgeFilter, this.isVirtual ? door : null));
        }
        TriPoint lastPt = pts.get(pts.size() - 1);
        double occRadius = agent.getGeometryRadius();
        Point3d segmentPt = Inter3D.nearestPointOnLineSeg(door.base.n1.p, door.base.n2.p, ptBeyond);
        Point3d[] lastSegment = navMesh.getEdgeSegment(door, segmentPt, occRadius);
        if (lastSegment != null) {
            Tri destTri = door.getDestTri(dir);
            if (destTri == null) {
                destTri = door.getAdjTri(destTri);
            }
            assert (destTri != null);
            DoorSeek lastSeek = new DoorSeek(door, lastSegment, new TriPoint(destTri, lastPt.p), edgeFilter, this.isVirtual);
            path.add(lastSeek);
        } else {
            path.add(new WaypointSeek(lastPt, edgeFilter));
        }
        Estimate.PointToGoalDist dist = tailInfo.getDistFrom(lastPt.p);
        return new Pair<IPath, Estimate.PointToGoalDist>(new PartialPath(new Path(path), dist.path, dist.dist), dist);
    }

    @Override
    public double getLocalQueueTimeEstimate(KB kb, OccAgent agent, LocalTimeEstimate estimator, double tTargetChosen, double localDist, Estimate.DoorToGoalValue globalDist) {
        DoorDir dir = this.getLocalDoorDirection(globalDist);
        double queueTime = estimator.getQueueTime(kb, agent, this.door, dir, localDist, Double.POSITIVE_INFINITY, tTargetChosen, kb.getCurrentSimTime());
        return queueTime;
    }

    @Override
    public double getLocalTravelTimeEstimate(KB kb, OccAgent agent, LocalTimeEstimate estimator, double localDist) {
        double travelTime = estimator.getTravelTime(kb, agent, localDist);
        return travelTime += LocalDoorTarget.getClosedTime(kb, this.door, agent, localDist);
    }

    private static double getClosedTime(KB kb, WingedEdge localDoor, OccAgent agent, double localDist) {
        ANode adjNode;
        if (localDoor != null && (adjNode = localDoor.getAdjNode(agent.getOcc().curNode)) != null && adjNode.getElevatorLevel() != null) {
            boolean willFitInElevator = LocalDoorTarget.willFitInElevator(kb, localDoor, agent, localDist);
            double ret = Math.max(0.0, localDoor.data.node.getNextOpenTime(kb, agent) - kb.getCurrentSimTime());
            return willFitInElevator ? ret : LocalDoorTarget.getWontFitInElevatorPenalty(kb.getElevatorModel(), agent, localDoor) + ret;
        }
        if (localDoor != null && localDoor.data.node.isClosed(kb, agent)) {
            return Math.max(0.0, localDoor.data.node.getNextOpenTime(kb, agent) - kb.getCurrentSimTime());
        }
        return 0.0;
    }

    private static boolean willFitInElevator(KB kb, WingedEdge localDoor, OccAgent agent, double localDist) {
        if (localDoor.isElevatorDoor() && localDoor.getAdjNode(agent.getOcc().curNode).getElevatorLevel() != null) {
            ElevatorModel elevatorModel = kb.getElevatorModel();
            DoorDir dir = localDoor.getDir(localDoor.getAdjNode(agent.getOcc().curNode));
            ANode elevatorNode = localDoor.getDestNode(dir);
            int nominalLoad = elevatorModel.findElevator(elevatorNode.getElevatorLevel()).getNominalLoad();
            int occsAlreadyIn = localDoor.data.node.isPhysicallyClosed() ? 0 : elevatorNode.getCorrespondingNumOccupants();
            int waitFor = kb.getPathEstimates().getQueue(localDoor).getQueue(dir).getQueuePosition(agent, localDist);
            if (waitFor < 0) {
                waitFor = -waitFor - 1;
            }
            return waitFor < nominalLoad - occsAlreadyIn;
        }
        return true;
    }

    private static double getWontFitInElevatorPenalty(ElevatorModel elevatorModel, OccAgent agent, WingedEdge localDoor) {
        DoorDir dir = localDoor.getDir(localDoor.getAdjNode(agent.getOcc().curNode));
        ANode elevatorNode = localDoor.getDestNode(dir);
        if (elevatorNode.getElevatorLevel() == null) {
            return 0.0;
        }
        IElevator elevator = elevatorModel.findElevator(elevatorNode.getElevatorLevel());
        return elevatorNode.getElevatorLevel().getDischargeTimeTot(elevator.getTargetLevel()) + elevatorNode.getElevatorLevel().getPickupTimeTot(elevator.getTargetLevel());
    }

    public DoorDir getLocalDoorDirection(Estimate.DoorToGoalValue globalTargetDist) {
        DoorDir dir = globalTargetDist.getDir(this.door);
        assert (dir != null);
        return dir;
    }

    public String toString() {
        return this.door.data.node.name;
    }
}

