/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.data2.IAgentBodyShape;
import inferno.data2.Occupant;
import inferno.data2.PolygonShape;
import inferno.data2.WingedEdge;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.io.Serializable;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class SeekWallSeparation
implements Serializable {
    static final long serialVersionUID = 1L;
    private final double d_maxSpeed;
    private final Vector2d d_preferredDir2d;

    public SeekWallSeparation(KB kb, OccInfo oi, SeekInfo seekInfo, Senses senses) {
        Vector3d dir = seekInfo.seekCurve.getTangent(0.0);
        dir.normalize();
        this.d_maxSpeed = OccAgent.getMaxVel(kb, oi.oa.getOcc(), dir);
        this.d_preferredDir2d = new Vector2d(dir.x, dir.y);
        Util2D.safeNormalize(this.d_preferredDir2d, 1.0E-9);
    }

    public static double getWallSensingRadius(KB kb, OccInfo oi, double sepDist) {
        return oi.shapeGeom.getEnclosingRadius() + InvSteerUtil.getBoundaryLayer(kb, oi) + oi.cache.currVel * (double)oi.oa.getOcc().reacTime;
    }

    public double[] getCost(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo, Vector3d dir, boolean isSocialDistancing) {
        Vector2d testDir;
        Point3d predictPos;
        Occupant occ = oi.oa.getOcc();
        if (dir == null) {
            predictPos = occ.loc;
            testDir = this.d_preferredDir2d;
            if (testDir.lengthSquared() == 0.0) {
                return new double[]{0.0, oi.cache.maxVel};
            }
        } else {
            testDir = new Vector2d(dir.x, dir.y);
            double len = Util2D.safeNormalize(testDir, 1.0E-9);
            if (len == 0.0) {
                return new double[]{0.0, oi.cache.maxVel};
            }
            if (!isSocialDistancing && theUtil.lt0(testDir.dot(this.d_preferredDir2d), 1.0E-6) && !(oi.oa.getOcc().bodyShape instanceof PolygonShape)) {
                return new double[]{1.0, oi.cache.maxVel};
            }
            predictPos = Util3D.add(occ.loc, (Tuple3d)Util3D.scale(dir, oi.cache.maxVel * (double)occ.reacTime));
        }
        List<WingedEdge> nearWalls = senses.getNearWalls(kb, oi);
        Point3d loc = predictPos;
        Vector2d dirN = testDir;
        double boundaryLayer = InvSteerUtil.getBoundaryLayer(kb, oi);
        IAgentBodyShape safeShape = oi.oa.getGeomCollisionShape(kb, true, oi.tightGeometry);
        double boundaryDist = boundaryLayer + safeShape.getEnclosingRadius();
        double boundaryDistSq = boundaryDist * boundaryDist;
        WingedEdge nearWall = null;
        Point3d nearPtOnWall = null;
        Vector3d occDir = new Vector3d();
        int count = nearWalls.size();
        for (int m = 0; m < count; ++m) {
            WingedEdge wall = nearWalls.get(m);
            Point3d w1 = wall.v1().p;
            Point3d w2 = wall.v2().p;
            double distsq = Inter2D.distSqToNearestPtOnLineSeg(w1.x, w1.y, w2.x, w2.y, loc.x, loc.y);
            if (distsq >= boundaryDistSq) continue;
            double neart = Inter2D.nearestTOnLineSeg(loc.x, loc.y, w1.x, w1.y, w2.x, w2.y);
            Point3d nearPos = Util3D.linesegPoint(w1, w2, neart);
            occDir.sub(nearPos, loc);
            double dot = occDir.x * dirN.x + occDir.y * dirN.y;
            if (dot < -1.0E-6) continue;
            nearWall = wall;
            nearPtOnWall = nearPos;
            boundaryDistSq = distsq;
        }
        if (nearWall == null) {
            return new double[]{0.0, oi.cache.maxVel};
        }
        double gap = oi.shapeGeom.getNearDist2d(nearPtOnWall);
        double f = 2.0;
        double m = -1.0 / (boundaryLayer * (f - 1.0));
        double b = f / (f - 1.0);
        double cost = Util.clampT(b + m * gap, 0.0, 1.25);
        return new double[]{cost, oi.cache.maxVel};
    }
}

