/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.geom.WallSlider;
import inferno.sim.AssistedEvacClientAgent;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.IPath;
import inferno.sim.path.IPathSeek;
import inferno.sim.path.Path;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathFilters;
import inferno.sim.path.PathGen;
import inferno.sim.path.WaypointSeek;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.Steer;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.simple.MoveToGoal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;

public class PassiveModeSteering
implements ISteeringBehavior,
Serializable {
    static final long serialVersionUID = 1L;
    private static final double PATH_RECALC_TIME = 0.0;
    private MoveToGoal d_moveTo;
    private OccAgent d_client;
    private Vector3d vel;
    private Vector3d orient;
    private final boolean FIX_ORIENT = true;
    private PathFollow d_pathFollow;
    private double d_dt = Double.POSITIVE_INFINITY;

    public PassiveModeSteering(OccAgent client) {
        this.d_client = client;
    }

    public void preMove(KB kb, OccAgent agent, double dt) {
        this.d_dt = dt;
        if (this.d_pathFollow == null) {
            this.d_pathFollow = new PathFollow(kb, agent, new PassivePathPlanner(this.d_client, kb));
        }
    }

    @Override
    public double getTimeLimit(KB kb, OccAgent agent) {
        return this.d_client.getSteeringBehavior().getTimeLimit(kb, this.d_client);
    }

    public void setOrient(Vector3d orient) {
        this.orient = orient;
    }

    public void setVel(Vector3d vel) {
        this.vel = vel;
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
        this.d_pathFollow.getPathPlanner().doorCrossed(t, agent, door);
    }

    @Override
    public PathFollow getPathFollow(OccAgent agent) {
        return this.d_pathFollow;
    }

    @Override
    public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
        LineSeg3D curve;
        this.d_pathFollow.planPath(kb, agent);
        Point3d curr = agent.getPos();
        TriPoint seek = this.d_pathFollow.getSeekPt();
        if (curr.epsilonEquals(seek.p, 1.0E-6)) {
            Vector3d nextDir = SteerUtil.getPredictDir(kb, agent, this.d_pathFollow);
            curve = new LineSeg3D(curr, Util3D.add(curr, (Tuple3d)nextDir));
        } else {
            curve = new LineSeg3D(agent.getPos(), seek.p);
        }
        Predicate<PathChange> pathFilter = PathFilters.filterEdges(EdgeFilters.rejectAllExits());
        WallSlider slider = Util.getWallSlider(kb, agent, pathFilter);
        return new SeekCurve(curve, slider, pathFilter, false);
    }

    @Override
    public Steer steer(KB world, OccAgent agent, SeekCurve seek, Predicate<OccAgent> agentFilter) {
        Vector3d dir = seek.curve.getTangent(0.0);
        double dist = Util3D.safeNormalize(dir, 0.0);
        Vector3d orient = this.d_client.getDirFacing();
        double delta = dist / this.d_dt;
        Vector3d vel = Util3D.scale(dir, delta);
        boolean tightRadius = true;
        return new Steer((Object)"meta", vel, orient, agent.getPriority(world), (double)agent.getOcc().squeezeFactor, Filters.rejectAll(), tightRadius, new OccAgent[0]);
    }

    private static class PassivePathPlanner
    implements IPathPlanner,
    Serializable {
        static final long serialVersionUID = 1L;
        private final OccAgent d_agent;
        private final AssistedEvacClientAgent d_clientAgent;
        private Path d_path;

        public PassivePathPlanner(OccAgent agent, KB kb) {
            this.d_agent = agent;
            this.d_clientAgent = agent.getAssistedEvacClientModule().get();
        }

        private TriPoint getCurrentDest(OccAgent agent) {
            ITpSource tp = this.d_clientAgent.getAttachedAgentsPos(agent);
            assert (tp != null);
            return tp.getTriPoint();
        }

        @Override
        public IPathPlanner.IStatus getStatus(KB kb, OccAgent agent) {
            return null;
        }

        @Override
        public boolean update(KB kb, OccAgent oa, boolean forceNewPath) {
            if (this.d_path == null || forceNewPath) {
                return true;
            }
            TriPoint dest = this.getCurrentDest(oa);
            IPathSeek goal = this.d_path.getGoal();
            assert (goal instanceof WaypointSeek);
            WaypointSeek waypoint = (WaypointSeek)goal;
            return !waypoint.getSeekPt().equals(dest);
        }

        @Override
        public IPath getPath(KB kb, OccAgent agent, boolean forceNewPath) {
            TriPoint dest = this.getCurrentDest(agent);
            ArrayList<Double> radiusAttempts = new ArrayList<Double>();
            radiusAttempts.add(agent.getGeometryRadius());
            if (this.d_agent.getGeometryRadius() < agent.getGeometryRadius()) {
                radiusAttempts.add(this.d_agent.getGeometryRadius());
            }
            radiusAttempts.add(0.0);
            this.d_path = null;
            for (Double radius : radiusAttempts) {
                Path path = this.generatePath(kb, agent, radius, dest);
                if (path == null) continue;
                this.d_path = path;
                break;
            }
            return this.d_path;
        }

        private Path generatePath(KB kb, OccAgent agent, double radius, TriPoint dest) {
            TriPoint loc = agent.getLoc();
            Predicate<PathChange> pathFilter = PathFilters.filterEdges(EdgeFilters.rejectAllExits());
            Pair<List<TriPoint>, List<TriEdge>> pathGenRes = PathGen.getPath(kb.getMesh(), loc.tri, null, null, loc.p, new PathGen.PointGoal(dest), radius, Double.POSITIVE_INFINITY, pathFilter);
            if (pathGenRes == null || pathGenRes.v1 == null) {
                return null;
            }
            List ptpath = (List)pathGenRes.v1;
            assert (!ptpath.isEmpty());
            ArrayList<IPathSeek> seekPts = new ArrayList<IPathSeek>(ptpath.size() + 1);
            for (int m = 0; m < ptpath.size(); ++m) {
                seekPts.add(new WaypointSeek((TriPoint)ptpath.get(m), EdgeFilters.acceptAll()));
            }
            seekPts.add(new WaypointSeek(dest, EdgeFilters.acceptAll()));
            return new Path(seekPts);
        }

        @Override
        public void doorCrossed(double t, OccAgent agent, DoorQueue queue) {
        }

        @Override
        public Predicate<WingedEdge> getTransientEdgeFilter(KB kb, OccAgent agent) {
            return EdgeFilters.rejectAllExits();
        }
    }
}

