/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.data2.OccPriority;
import inferno.geom.Inter;
import inferno.geom.Util;
import inferno.geom.WallSlider;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.inverse.ASeparationCalc;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class IdleSeparation
extends ASeparationCalc {
    static final long serialVersionUID = 1L;
    public static final int FILTERID = -1348979970;
    private final List<OccAgent> d_influencingOccs = new ArrayList<OccAgent>();
    private final boolean d_forceSep;
    private final double d_sepDist;

    public IdleSeparation(KB kb, OccInfo oi, boolean forceSep) {
        this(forceSep, oi.oa.getComfortDist(kb, oi.squeezeFactor));
    }

    public IdleSeparation(boolean forceSep, double sepDist) {
        this.d_forceSep = forceSep;
        this.d_sepDist = sepDist;
    }

    public double getSepDist() {
        return this.d_sepDist;
    }

    public List<OccAgent> getInfluencingOccs() {
        return this.d_influencingOccs;
    }

    @Override
    public void init(KB kb, WallSlider wallSlider, OccInfo oi, SeekInfo seekInfo, Senses senses) {
        this.d_influencingOccs.clear();
        super.init(kb, wallSlider, oi, seekInfo, senses);
    }

    public double getSensingRadius(KB kb, OccInfo oi) {
        return Math.max(this.d_sepDist, oi.oa.getComfortDist(kb, oi.squeezeFactor)) + oi.shapeAgents.getEnclosingRadius();
    }

    @Override
    protected Pair<Vector3d, Double> calcMove(KB kb, WallSlider wallSlider, OccInfo oi, SeekInfo seekInfo, Senses senses) {
        Vector3d seekDir = seekInfo.seekDir;
        double smallestGap = Double.MAX_VALUE;
        int count = 0;
        Vector3d moveDir = new Vector3d(0.0, 0.0, 0.0);
        double minComfortDist = Double.MAX_VALUE;
        for (OccAgent nearOcc : senses.getNearOccs(-1348979970, oi)) {
            Vector3d nearMoveDir;
            double gap;
            double comfortDist = IdleSeparation.getSepDist(kb, oi, seekInfo, nearOcc, this.d_sepDist);
            if (comfortDist == 0.0 || !((gap = Inter.getOccGap(oi.shapeAgents, nearOcc.getCollisionShape())) < comfortDist) || !this.shouldSeparate(kb, oi, seekInfo, nearOcc, gap, comfortDist) || (nearMoveDir = IdleSeparation.getMoveVec(kb, oi, wallSlider, nearOcc, gap, comfortDist)) == null) continue;
            moveDir.add(nearMoveDir);
            ++count;
            this.d_influencingOccs.add(nearOcc);
            if (gap < smallestGap) {
                smallestGap = gap;
            }
            if (!(comfortDist < minComfortDist)) continue;
            minComfortDist = comfortDist;
        }
        if (count > 0) {
            double dist = moveDir.length() / (double)count;
            if (Util3D.safeNormalize(moveDir = Util.projectAlongZ(oi.oa.getOcc().tri.plane, moveDir), 0.0) > 0.0) {
                double dtol;
                if ((moveDir = wallSlider.slide(moveDir, true)).lengthSquared() == 0.0) {
                    return new Pair<Vector3d, Double>(new Vector3d(), 0.0);
                }
                if (seekInfo.seekDir != null && moveDir.dot(seekDir) > 0.0 && !this.testNearHit(kb, oi, seekInfo, seekDir, senses, moveDir)) {
                    dist = Double.POSITIVE_INFINITY;
                }
                if (smallestGap < (dtol = 2.0 * IdleSeparation.getGapTol(minComfortDist)) || dist > dtol) {
                    dist = oi.oa.getOcc().tri.project2dLength(dist);
                    return new Pair<Vector3d, Double>(moveDir, dist);
                }
            }
            return new Pair<Vector3d, Double>(new Vector3d(0.0, 0.0, 0.0), 0.0);
        }
        return new Pair<Object, Double>(null, Double.POSITIVE_INFINITY);
    }

    @Override
    protected void getHighCostOccs(Consumer<OccAgent> highCostOccs) {
        for (OccAgent sep : this.d_influencingOccs) {
            highCostOccs.accept(sep);
        }
    }

    private boolean shouldSeparate(KB kb, OccInfo occ1, SeekInfo seek1, OccAgent occ2, double gap, double comfortDist) {
        int priorComp = InvSteerUtil.compare(kb, occ1, occ2);
        if (!InvSteerUtil.canSeparate(kb, occ1, seek1, occ2, priorComp, !this.d_forceSep)) {
            return false;
        }
        return this.d_forceSep || priorComp > 0 || !occ1.oa.hasVehicle() && theUtil.le0(gap, IdleSeparation.getGapTol(comfortDist)) || occ1.oa.isWaiting(kb) && !occ2.isWaiting(kb) && !InvSteerUtil.getYieldToIdler(kb, occ2, occ1.oa);
    }

    private static double getGapTol(double comfortDist) {
        return Math.min(0.01, 0.125 * comfortDist);
    }

    public static double getSepDist(KB kb, OccInfo occ1, SeekInfo seek1, OccAgent occ2, double samePriorDist) {
        int comp = InvSteerUtil.compare(kb, occ1, occ2);
        if (comp <= 0) {
            return samePriorDist;
        }
        return occ1.oa.getComfortDist(kb, occ1.squeezeFactor);
    }

    private static Vector3d getMoveVec(KB kb, OccInfo oi, WallSlider slide1, OccAgent nearOcc, double gap, double comfortDist) {
        double distToMove;
        Vector3d avoidDir;
        Point3d pos1 = oi.oa.getPos();
        Point3d pos2 = nearOcc.getPos();
        Vector3d nearMoveDir = Util.vector2d(nearOcc.getPos(), oi.oa.getPos());
        Util3D.safeNormalize(nearMoveDir, 0.0);
        if (!nearOcc.isWaiting(kb) && Util.dot2d(avoidDir = IdleSeparation.getAvoidDir(kb, nearOcc, oi.priority), nearMoveDir) > 0.0) {
            double distToMove2;
            double norm = Util2D.cross(nearMoveDir.x, nearMoveDir.y, avoidDir.x, avoidDir.y);
            if (norm == 0.0) {
                norm = 1.0;
            }
            Vector3d testDir = new Vector3d(norm * avoidDir.y, norm * -avoidDir.x, 0.0);
            testDir.normalize();
            testDir = slide1.slide(testDir, true);
            if (theUtil.gt0(Util.dot2d(testDir, nearMoveDir), 1.0E-6)) {
                IdleSeparation.set2d(nearMoveDir, testDir);
            } else {
                testDir = slide1.slide(nearMoveDir, true);
                if (testDir.lengthSquared() == 0.0) {
                    return GeomConstants.VEC3D_ZERO;
                }
                IdleSeparation.set2d(nearMoveDir, testDir);
            }
            double sinTheta = Math.abs(Util2D.cross(avoidDir.x, avoidDir.y, nearMoveDir.x, nearMoveDir.y)) / Util.length2d(avoidDir);
            if (theUtil.eq0(sinTheta, 1.0E-6)) {
                distToMove2 = comfortDist - gap;
            } else {
                double distToPathDes;
                double distToPathCurr = Math.sqrt(Inter2D.distSqToNearestPtOnLine(pos2.x, pos2.y, avoidDir.x, avoidDir.y, pos1.x, pos1.y));
                if (distToPathCurr >= (distToPathDes = Inter.getDistToMoveFromPath(oi.shapeAgents, nearOcc.getCollisionShape()) + comfortDist)) {
                    return null;
                }
                double hcurr = distToPathCurr / sinTheta;
                double hdes = distToPathDes / sinTheta;
                distToMove2 = Math.min(hdes - hcurr, distToPathDes);
            }
            nearMoveDir.scale(distToMove2);
            return nearMoveDir;
        }
        Vector3d slideDir = slide1.slide(nearMoveDir, true);
        if (slideDir.equals(nearMoveDir)) {
            distToMove = comfortDist - gap;
        } else {
            slideDir.z = 0.0;
            if (Util3D.safeNormalize(slideDir, 0.0) == 0.0) {
                return GeomConstants.VEC3D_ZERO;
            }
            double distToPathSq = Inter2D.distSqToNearestPtOnLine(pos1.x, pos1.y, slideDir.x, slideDir.y, pos2.x, pos2.y);
            double distOnPathCurr = Math.sqrt(Math.max(0.0, Util.distSquared2d(pos1, pos2) - distToPathSq));
            double distDes = Inter.getDistToMoveFromPath(oi.shapeAgents, nearOcc.getCollisionShape()) + comfortDist;
            double distOnPathDes = Math.sqrt(Math.max(0.0, distDes * distDes - distToPathSq));
            distToMove = distOnPathDes - distOnPathCurr;
            if (distToMove <= 0.0) {
                return null;
            }
            nearMoveDir.set(slideDir);
        }
        nearMoveDir.scale(distToMove);
        return nearMoveDir;
    }

    private static void set2d(Vector3d target, Vector3d usrc) {
        if (usrc.z == 0.0) {
            target.set(usrc);
        } else {
            target.set(usrc.x, usrc.y, 0.0);
            Util3D.safeNormalize(target, 0.0);
        }
    }

    public static Vector3d getAvoidDir(KB kb, OccAgent oa, double priority) {
        if (OccPriority.compareLevels(priority, oa.getPriority(kb)) >= 0) {
            if (oa.getVel().length() < 0.1 * OccAgent.getMaxVel(kb, oa.getOcc(), oa.getVel())) {
                return GeomConstants.VEC3D_ZERO;
            }
        } else if (theUtil.gt0(oa.getVel().length(), 0.1)) {
            return oa.getVel();
        }
        return oa.getSeekCurve().getTangent(0.0);
    }

    private static Point3d calcStopPos(KB kb, OccAgent oa) {
        double stopDist1 = OccAgent.calcStopDist(oa.getVel().length(), oa.getMaxStopAccel(kb));
        Vector3d travelDir = oa.getVel();
        if (travelDir.lengthSquared() > 0.0) {
            travelDir.normalize();
        }
        travelDir.scale(stopDist1);
        return Util3D.add(oa.getPos(), (Tuple3d)travelDir);
    }

    private static Vector2d toDir2d(Vector3d dir) {
        Vector2d dir2d = new Vector2d(dir.x, dir.y);
        double lensq = dir2d.lengthSquared();
        if (lensq > 0.0) {
            dir2d.scale(1.0 / Math.sqrt(lensq));
        }
        return dir2d;
    }

    private static Point2d getPos2d(OccAgent agent) {
        Point3d pos = agent.getPos();
        return IdleSeparation.toP2d(pos);
    }

    private static Point2d toP2d(Point3d p) {
        return new Point2d(p.x, p.y);
    }

    private boolean testNearHit(KB kb, OccInfo oi, SeekInfo seekInfo, Vector3d seekDir, Senses senses, Vector3d dir) {
        double comfortDist;
        ArrayList<Pair<OccAgent, Double>> occHits = new ArrayList<Pair<OccAgent, Double>>();
        senses.senseNearestOccHits(kb, -1348979970, oi, dir, occHits, null);
        if (occHits.isEmpty()) {
            return false;
        }
        Pair nearHit = (Pair)occHits.get(0);
        double hitTime = (Double)((Pair)occHits.get((int)0)).v2;
        double hitDist = hitTime * oi.cache.maxVel;
        return hitDist <= (comfortDist = IdleSeparation.getSepDist(kb, oi, seekInfo, (OccAgent)nearHit.v1, this.d_sepDist));
    }
}

