/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.geom.WallSlider;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.io.Serializable;
import java.util.function.Consumer;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Pair;

public abstract class ASeparationCalc
implements Serializable {
    static final long serialVersionUID = 1L;
    private Vector3d d_idealMoveVec;
    private double d_idealMoveDist;

    public boolean isSeparating() {
        return this.d_idealMoveVec != null;
    }

    public Vector3d getMoveVec() {
        return this.d_idealMoveVec;
    }

    public void init(KB kb, WallSlider wallSlider, OccInfo oi, SeekInfo seekInfo, Senses senses) {
        Pair<Vector3d, Double> move = this.calcMove(kb, wallSlider, oi, seekInfo, senses);
        this.d_idealMoveVec = (Vector3d)move.v1;
        this.d_idealMoveDist = (Double)move.v2;
    }

    protected abstract void getHighCostOccs(Consumer<OccAgent> var1);

    public double[] getCost(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo, Vector3d dir, Consumer<OccAgent> highCostOccs) {
        if (this.d_idealMoveVec == null) {
            return new double[]{0.0, oi.cache.maxVel};
        }
        if (dir == null) {
            if (this.d_idealMoveDist == 0.0) {
                return new double[]{0.0, oi.cache.maxVel};
            }
            if (highCostOccs != null) {
                this.getHighCostOccs(highCostOccs);
            }
            return new double[]{1.0, 0.0};
        }
        if (highCostOccs != null) {
            this.getHighCostOccs(highCostOccs);
        }
        double dot = dir.dot(this.d_idealMoveVec);
        dot = InvSteerUtil.clampCost(dot);
        double cost = 1.0 - dot;
        double moveDist = dot == 0.0 ? 0.0 : this.d_idealMoveDist * dot;
        return new double[]{cost, InvSteerUtil.getMaxVelToStop(kb, oi, moveDist)};
    }

    protected abstract Pair<Vector3d, Double> calcMove(KB var1, WallSlider var2, OccInfo var3, SeekInfo var4, Senses var5);
}

