/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.data2.OccPriority;
import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.inverse.BehaviorWeights;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.IdleSeparation;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Consumer;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public abstract class ASeek
implements ISeekCalc,
Serializable {
    static final long serialVersionUID = 1L;
    private static final boolean RAND_PASS_PREF = System.getProperty("ASeek.RAND_PASS_PREF") != null;
    private static final double SWENSON_SEEK = theUtil.getSystemDouble("ASeek.SWENSON_SEEK", Double.NaN);
    private double d_arrivalRadius;
    private double d_seekSpeed;
    private boolean d_travel360;
    private boolean d_passPrefRight;
    private static final double[][][][][] ALL_ANGLES = new double[2][2][2][3][];

    public ASeek(KB kb, OccAgent agent, double arrivalRadius) {
        this.d_arrivalRadius = arrivalRadius;
        this.d_seekSpeed = 0.0;
        this.d_passPrefRight = RAND_PASS_PREF ? new Random(agent.getOcc().rseed ^ 0x9A8F8F83298AL).nextBoolean() : true;
    }

    protected boolean getArrive() {
        return !Double.isNaN(this.getArrivalRadius());
    }

    protected double getArrivalRadius() {
        return this.d_arrivalRadius;
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue queue) {
    }

    @Override
    public void init(KB kb, OccInfo oi, IParametric3D seekCurve) {
        this.d_seekSpeed = this.calcSeekSpeed(kb, oi, seekCurve);
    }

    protected double getDistanceToDest(KB kb, OccAgent agent, IParametric3D seekCurve) {
        return seekCurve.length();
    }

    protected double calcSeekSpeed(KB kb, OccInfo oi, IParametric3D seekCurve) {
        double distToStopFromMaxVel;
        double timeToReachMaxSpeed;
        double maxSpeed;
        if (!this.getArrive()) {
            return oi.cache.maxVel;
        }
        double currSpeed = oi.cache.currVel;
        double distToStop = this.getDistanceToDest(kb, oi.oa, seekCurve);
        if (!Double.isFinite(distToStop)) {
            distToStop = Double.POSITIVE_INFINITY;
            maxSpeed = oi.cache.maxVel;
        } else {
            maxSpeed = InvSteerUtil.getMaxVelToStop(kb, oi, distToStop, currSpeed);
        }
        double accel = oi.oa.getMaxStartAccel(kb);
        if (maxSpeed > currSpeed && theUtil.lt(timeToReachMaxSpeed = OccAgent.calcSpeedupTime(currSpeed, maxSpeed, accel), oi.oa.getOcc().reacTime, 1.0E-6)) {
            return 0.0;
        }
        if (oi.oa.hasVehicle() && distToStop < (distToStopFromMaxVel = OccAgent.calcStopDist(oi.cache.maxVel, oi.oa.getMaxStopAccel(kb)))) {
            return 0.0;
        }
        return maxSpeed;
    }

    @Override
    public IdleSeparation getSeparation(KB kb, OccInfo oi) {
        boolean forceSeparation = kb.getParams().force_separation;
        if (oi.oa.getOcc().curNode.isTransportNode()) {
            forceSeparation = true;
        }
        return new IdleSeparation(kb, oi, forceSeparation);
    }

    @Override
    public double getSensingFOV(KB kb, OccInfo oi) {
        return oi.oa.isWaiting(kb) || this.isSlow(kb, oi) ? Math.PI * 2 : Math.PI;
    }

    @Override
    public SeekInfo getSeekInfo(KB kb, OccInfo oi, SeekCurve seek) {
        boolean seeking;
        Vector3d seekDir = seek.curve.getTangent(0.0);
        double seekDirLen = Util3D.safeNormalize(seekDir, 1.0E-9);
        if (!this.getArrive()) {
            seeking = true;
            if (seekDirLen == 0.0 && Util3D.safeNormalize(seekDir = new Vector3d(oi.oa.getVel()), 1.0E-9) == 0.0) {
                seekDir = oi.oa.getOcc().orient;
            }
        } else {
            double distToEndpoint = seek.curve.length();
            if (distToEndpoint <= this.d_arrivalRadius) {
                seeking = false;
                if (theUtil.eq0(distToEndpoint, 1.0E-9)) {
                    seekDir = null;
                }
            } else {
                seeking = true;
            }
        }
        return new SeekInfo(seek, seekDir, seeking);
    }

    private static double[] getSampleAngles(boolean preferRight, boolean standAllowed, boolean seeking, AngleType angleid) {
        int pr = preferRight ? 1 : 0;
        int sa = standAllowed ? 1 : 0;
        int sk = seeking ? 1 : 0;
        return ALL_ANGLES[pr][sa][sk][angleid.ordinal()];
    }

    @Override
    public Vector3d[] getSeekDirs(KB kb, OccInfo oi, SeekInfo seekInfo, IdleSeparation sep, int options) {
        AngleType atype;
        boolean standAllowed;
        this.d_travel360 = this.getTravel360(kb, oi, sep, options);
        Vector3d baseDir = seekInfo.seekDir != null ? seekInfo.seekDir : oi.oa.getOcc().orient;
        boolean seeking = seekInfo.seekDir != null;
        boolean bl = standAllowed = !theUtil.testAny(options, 2);
        if (this.d_travel360) {
            atype = AngleType.TRAVEL360;
        } else {
            BehaviorWeights weights = new BehaviorWeights(oi.oa, oi.oa.getOcc().bodyShape, theUtil.testAny(options, 4));
            atype = weights.cornerBehavior > 0.0 ? AngleType.SEEK_WIDE : AngleType.SEEK_NARROW;
        }
        double[] angles = ASeek.getSampleAngles(this.d_passPrefRight, standAllowed, seeking, atype);
        return InvSteerUtil.generateSampleDirs(kb, oi.oa, baseDir, angles);
    }

    private boolean getTravel360(KB kb, OccInfo oi, IdleSeparation sep, int options) {
        if (theUtil.testAny(options, 1)) {
            return false;
        }
        if (!oi.oa.getOcc().bodyShape.canTravel360()) {
            return false;
        }
        if (theUtil.testAny(options, 4)) {
            return true;
        }
        if (oi.oa.isWaiting(kb) && sep.isSeparating()) {
            return true;
        }
        for (OccAgent agent2 : sep.getInfluencingOccs()) {
            if (OccPriority.compareLevels(oi.priority, agent2.getPriority(kb)) <= 0) continue;
            return true;
        }
        return this.isSlow(kb, oi);
    }

    @Override
    public double[] getCost(KB kb, OccInfo oi, Senses sense, SeekInfo seekInfo, Vector3d preferredDir, Vector3d dir) {
        double stuckCost;
        double d = stuckCost = dir == null && oi.oa.hasVehicle() ? oi.oa.getVehicle().getStuckTime() * 40.0 : 0.0;
        if (dir == null && preferredDir == null) {
            return new double[]{0.0 + stuckCost, 0.0};
        }
        if (dir == null) {
            return new double[]{0.5 + stuckCost, 0.0};
        }
        if (preferredDir == null) {
            return new double[]{0.5 + stuckCost, 0.0};
        }
        double angle = Util.angle2d(dir, preferredDir);
        double speed = this.d_seekSpeed;
        if (!Double.isNaN(SWENSON_SEEK)) {
            double cutoff = Math.toRadians(SWENSON_SEEK);
            double cost = angle < cutoff ? angle / cutoff : 1.0;
            return new double[]{cost + stuckCost, speed};
        }
        if (theUtil.eq(angle, 1.5707963267948966, 1.0E-6)) {
            return new double[]{0.5 + stuckCost, speed};
        }
        if (angle > 1.5707963267948966) {
            speed = oi.cache.maxVel;
        }
        double cost = angle / Math.PI;
        return new double[]{cost + stuckCost, speed};
    }

    @Override
    public BehaviorWeights getWeights(KB kb, OccInfo oi, boolean isSocialDistancing) {
        return new BehaviorWeights(oi.oa, oi.oa.getOcc().bodyShape, isSocialDistancing);
    }

    @Override
    public boolean isDirectionAllowed(KB kb, OccAgent oa, Vector3d baseDir, Vector3d dir) {
        if (this.d_travel360 || baseDir == null || dir == null) {
            return true;
        }
        return baseDir.dot(dir) >= 0.0;
    }

    private boolean isSlow(KB kb, OccInfo oi) {
        return oi.oa.isSlow(kb, oi.cache.currVel);
    }

    static {
        Consumer<AngleType> addAngles = angleid -> {
            ArrayList<Double> angles = new ArrayList<Double>();
            for (int preferRight = 0; preferRight < 2; ++preferRight) {
                for (int standAllowed = 0; standAllowed < 2; ++standAllowed) {
                    for (int seeking = 0; seeking < 2; ++seeking) {
                        angles.clear();
                        if (standAllowed == 0) {
                            angles.add(0.0);
                        } else if (seeking == 0) {
                            angles.add(Double.NaN);
                            angles.add(0.0);
                        } else {
                            angles.add(0.0);
                            angles.add(Double.NaN);
                        }
                        for (double angleDeg = angleid.dThetaDeg; angleDeg <= angleid.maxAngleDeg; angleDeg += angleid.dThetaDeg) {
                            if (preferRight == 0) {
                                angles.add(Math.toRadians(angleDeg));
                            }
                            if (angleDeg != 180.0) {
                                angles.add(Math.toRadians(-angleDeg));
                            }
                            if (preferRight == 0) continue;
                            angles.add(Math.toRadians(angleDeg));
                        }
                        ASeek.ALL_ANGLES[preferRight][standAllowed][seeking][angleid.ordinal()] = theUtil.toDoubleArray(angles);
                    }
                }
            }
        };
        addAngles.accept(AngleType.TRAVEL360);
        addAngles.accept(AngleType.SEEK_NARROW);
        addAngles.accept(AngleType.SEEK_WIDE);
    }

    private static interface TriConsumer<T1, T2, T3> {
        public void accept(T1 var1, T2 var2, T3 var3);
    }

    private static enum AngleType {
        TRAVEL360("ASeek.t360", 180.0, 45.0),
        SEEK_NARROW("ASeek.narrow", 60.0, 15.0),
        SEEK_WIDE("ASeek.wide", 75.0, 15.0);

        public final double maxAngleDeg;
        public final double dThetaDeg;

        private AngleType(String propName, double defMaxAngleDeg, double defDThetaDeg) {
            this.maxAngleDeg = AngleType.dp(propName + ".max", defMaxAngleDeg);
            this.dThetaDeg = AngleType.dp(propName + ".dtheta", defDThetaDeg);
        }

        private static double dp(String name, Double defVal) {
            return theUtil.getSystemDouble(name, defVal);
        }
    }
}

