/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering;

import inferno.data2.Mesh;
import inferno.data2.Occupant;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.geom.Inter;
import inferno.geom.Util;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.IPath;
import inferno.sim.path.IPathSeek;
import inferno.sim.path.PathGen;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.LostException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class PathFollow
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final Status UNKNOWN_STATUS = new Status(null, Double.NaN, null);
    public static final Status LOST_STATUS = new Status(null, Double.POSITIVE_INFINITY, null);
    private static final double MIN_PATH_RECALC_TIME = 0.5;
    private static final boolean LAZY_SEEK = true;
    private double d_minWallDist;
    private IPath d_steerPath;
    private double d_lastPathStartTime;
    private Point3d d_prevSeekPos;
    private IPathSeek d_seek;
    private boolean d_lost;
    private int d_nextSeekIx;
    private IPathSeek d_nextSeek;
    private double d_dtModified = 0.0;
    private IPathPlanner d_planner;
    private final double d_minPathRecalcTime;

    public PathFollow(KB kb, OccAgent oa, IPathPlanner planner) {
        this(kb, oa, planner, 0.5);
    }

    public PathFollow(KB kb, OccAgent oa, IPathPlanner planner, double minPathRecalcTime) {
        this.d_planner = planner;
        this.d_minPathRecalcTime = minPathRecalcTime;
        this.d_prevSeekPos = null;
        this.d_seek = null;
        this.d_nextSeek = null;
        this.d_lost = false;
        this.d_lastPathStartTime = -1.7976931348623157E308;
    }

    public String getName() {
        return "path_following";
    }

    public IPathPlanner getPathPlanner() {
        return this.d_planner;
    }

    private void startSteering(KB kb, OccAgent agent, IPath path, double minWallDist) {
        this.d_lastPathStartTime = kb.getCurrentSimTime();
        this.d_steerPath = path;
        this.d_minWallDist = minWallDist;
        this.d_prevSeekPos = null;
        this.d_seek = null;
        this.d_nextSeek = null;
        if (this.d_steerPath != null) {
            int seekIx = PathGen.prunePoints(kb, this.d_steerPath, 0, true);
            this.setSeek(kb, this.d_steerPath.pointAt(0).getSeekPt(), seekIx, null);
            this.updateSeek(kb, agent);
            assert (this.d_seek != null);
        }
    }

    public IPath getPath() {
        return this.d_steerPath;
    }

    public Status getStatus(KB kb, OccAgent agent) {
        double distRemain = this.getRemainingDistance(agent, true);
        if (Double.isNaN(distRemain)) {
            return UNKNOWN_STATUS;
        }
        if (Double.isInfinite(distRemain)) {
            return LOST_STATUS;
        }
        return new Status(this.d_steerPath, distRemain, this.d_planner.getStatus(kb, agent));
    }

    public double getRemainingKnownDistance(OccAgent agent) {
        return this.getRemainingDistance(agent, false);
    }

    public double getRemainingDistance(OccAgent agent, boolean fuzzy) {
        return this.getRemainingDistance(agent, fuzzy, Double.POSITIVE_INFINITY);
    }

    public boolean isCloseToDestination(OccAgent agent, double distTol) {
        double dist = this.getRemainingDistance(agent, true, distTol);
        if (!Double.isFinite(dist)) {
            return false;
        }
        return dist <= distTol;
    }

    private double getRemainingDistance(OccAgent agent, boolean fuzzy, double quitDist) {
        if (this.d_seek == null) {
            return this.d_lost ? Double.POSITIVE_INFINITY : Double.NaN;
        }
        TriPoint currSeek = this.d_seek.getSeekPt();
        double dist = agent.getPos().distance(currSeek.p);
        if (dist > quitDist) {
            return dist;
        }
        if (fuzzy || this.d_seek != this.d_nextSeek) {
            int numPoints = this.d_steerPath.getNumPoints(false);
            for (int m = this.d_nextSeekIx; m < numPoints; ++m) {
                TriPoint nextSeek = this.d_steerPath.pointAt(m).getSeekPt();
                dist += currSeek.p.distance(nextSeek.p);
                currSeek = nextSeek;
                if (!(dist > quitDist)) continue;
                return dist;
            }
            if (fuzzy) {
                dist += this.d_steerPath.fuzzyLength();
            }
        }
        return dist;
    }

    public void getSeekPoints(KB kb, Point3d startPos, double dist, boolean pruneColinearPoints, boolean fuzzy, List<Point3d> seeks) {
        if (this.d_seek == null) {
            return;
        }
        double distAccum = 0.0;
        Point3d p1 = startPos;
        Point3d p2 = this.d_seek.getSeekPt().p;
        seeks.add(p2);
        if (theUtil.gt(distAccum += p1.distance(p2), dist, 1.0E-6)) {
            return;
        }
        p1 = p2;
        if (this.d_nextSeek != this.d_seek) {
            p2 = this.d_nextSeek.getSeekPt().p;
            seeks.add(p2);
            if (theUtil.gt(distAccum += p1.distance(p2), dist, 1.0E-6)) {
                return;
            }
            p1 = p2;
        } else if (!fuzzy) {
            return;
        }
        int numPoints = this.d_steerPath.getNumPoints(fuzzy);
        int ix = this.d_nextSeekIx;
        while (ix < numPoints) {
            int nextIx;
            int n = nextIx = pruneColinearPoints ? PathGen.prunePoints(kb, this.d_steerPath, ix, true) : ix + 1;
            if (nextIx == ix || nextIx == -1 || nextIx >= numPoints) {
                return;
            }
            IPathSeek nextSeek = this.d_steerPath.pointAt(nextIx);
            p2 = nextSeek.getSeekPt().p;
            seeks.add(p2);
            if (theUtil.gt(distAccum += p1.distance(p2), dist, 1.0E-6)) {
                return;
            }
            p1 = p2;
            ix = nextIx;
        }
    }

    public <T> Optional<T> processRemainingSeeks(KB kb, boolean fuzzy, Function<IPathSeek, T> consumer) {
        if (this.d_seek == null) {
            return Optional.empty();
        }
        T result = consumer.apply(this.d_seek);
        if (result != null) {
            return Optional.of(result);
        }
        if (this.d_nextSeek != this.d_seek) {
            result = consumer.apply(this.d_nextSeek);
            if (result != null) {
                return Optional.of(result);
            }
        } else if (!fuzzy) {
            return Optional.empty();
        }
        int numPoints = this.d_steerPath.getNumPoints(fuzzy);
        for (int nextIx = this.d_nextSeekIx + 1; nextIx < numPoints; ++nextIx) {
            IPathSeek nextSeek = this.d_steerPath.pointAt(nextIx);
            result = consumer.apply(nextSeek);
            if (result == null) continue;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public IPathSeek getSeek() {
        return this.d_seek;
    }

    public IPathSeek getNextSeek() {
        return this.d_nextSeek;
    }

    public TriPoint getSeekPt() {
        return this.d_seek != null ? this.d_seek.getSeekPt() : null;
    }

    public TriPoint getNextSeekPt() {
        return this.d_nextSeek.getSeekPt();
    }

    public void planPath(KB kb, OccAgent oa) throws LostException {
        PathStatus ps;
        if (this.d_dtModified <= kb.getMesh().dtModified() || this.d_dtModified <= oa.dtModified()) {
            this.d_dtModified = kb.getCurrentSimTime();
            this.updateSeek(kb, oa);
        }
        if ((ps = this.getPathStatus(kb, oa)) != PathStatus.VALID) {
            IPath mtPath = this.d_planner.getPath(kb, oa, ps == PathStatus.INVALID);
            if (mtPath != this.d_steerPath) {
                this.startSteering(kb, oa, mtPath, oa.getGeometryRadius());
            }
            boolean bl = this.d_lost = mtPath == null;
            if (mtPath == null) {
                throw new LostException();
            }
        }
    }

    private static List<WingedEdge> getGoalEdges(Tri mt, List<WingedEdge> eGoalTopos) {
        List<WingedEdge> es = Arrays.asList(mt.eu[0].wedge, mt.eu[1].wedge, mt.eu[2].wedge);
        es.retainAll(eGoalTopos);
        return es;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSeek(KB kb, OccAgent agent) {
        if (this.d_steerPath == null) {
            return;
        }
        boolean moveToNext = this.testNextSeek(kb, agent);
        if (moveToNext) {
            this.setSeek(kb, agent.getLoc(), this.d_nextSeekIx, this.d_nextSeek);
        }
        if (!kb.getProps().isNull()) {
            Occupant occupant = agent.getOcc();
            synchronized (occupant) {
                Point3d seekPt = this.d_seek.isVisible() ? this.d_seek.getSeekPt().p : null;
                kb.getProps().setDbg(agent.getOcc(), "pt_seek", seekPt);
                Point3d nextSeekPt = this.d_nextSeek.isVisible() ? this.d_nextSeek.getSeekPt().p : null;
                kb.getProps().setDbg(agent.getOcc(), "pt_nextseek", nextSeekPt);
            }
        }
    }

    private static boolean normalizeSafe(Vector3d v) {
        return Util.safeNormalize(v, 1.0E-9) > 0.0;
    }

    private static double signum(double v, double tol) {
        if (theUtil.eq0(v, tol)) {
            return 0.0;
        }
        if (v > 0.0) {
            return 1.0;
        }
        return -1.0;
    }

    public boolean testNextSeek(KB kb, TriPoint testPt, IPathSeek currSeek, IPathSeek nextSeek) {
        Mesh mesh = kb.getMesh();
        currSeek.updateSeekPt(testPt, this.d_minWallDist, mesh);
        if (nextSeek != currSeek) {
            Point3d pPrev = this.d_prevSeekPos;
            Point3d pCurr = currSeek.getSeekPt().p;
            Point3d pNext = nextSeek.getSeekPt().p;
            Vector3d vNext = Util3D.vector(pCurr, pNext);
            if (!PathFollow.normalizeSafe(vNext)) {
                return true;
            }
            boolean moveToNext = false;
            Vector3d vCurr = Util3D.vector(pPrev, pCurr);
            if (!PathFollow.normalizeSafe(vCurr)) {
                moveToNext = true;
            } else {
                Vector3d pnorm = Util3D.cross(vNext, GeomConstants.VEC3D_ZPOS);
                double dot = vCurr.dot(pnorm);
                if (theUtil.eq0(dot, 1.0E-6)) {
                    moveToNext = true;
                } else {
                    if (dot < 0.0) {
                        pnorm.negate();
                    }
                    Plane3d iPlane = new Plane3d(pnorm, pCurr);
                    double side = iPlane.dot(testPt.p);
                    moveToNext = theUtil.ge0(side, 1.0E-6);
                }
            }
            if (moveToNext) {
                return true;
            }
        }
        currSeek.updateVisibility(testPt, 0.0, mesh);
        return false;
    }

    private boolean testNextSeek(KB kb, OccAgent agent) {
        return this.testNextSeek(kb, agent.getLoc(), this.d_seek, this.d_nextSeek);
    }

    private static Point2d p2d(IPathSeek seek) {
        TriPoint tp = seek.getSeekPt();
        return new Point2d(tp.p.x, tp.p.y);
    }

    private void setSeek(KB kb, TriPoint agentPos, int seekIx, IPathSeek preSetSeek) {
        IPathSeek nextSeek;
        int nextSeekIx;
        IPathSeek seek = preSetSeek != null ? preSetSeek : this.getSeekForIx(seekIx);
        int numSteerPts = this.d_steerPath.getNumPoints(false);
        if (seekIx == numSteerPts - 1) {
            nextSeekIx = seekIx;
            nextSeek = seek;
        } else {
            nextSeekIx = PathGen.prunePoints(kb, this.d_steerPath, seekIx, true);
            nextSeek = this.getSeekForIx(nextSeekIx);
        }
        this.d_prevSeekPos = this.d_seek != null ? this.d_seek.getSeekPt().p : agentPos.p;
        this.d_seek = seek;
        assert (this.d_seek != null);
        this.d_nextSeekIx = nextSeekIx;
        this.d_nextSeek = nextSeek;
        this.d_seek.updateSeekPt(agentPos, 0.0, kb.getMesh());
        this.d_seek.updateVisibility(agentPos, 0.0, kb.getMesh());
    }

    private IPathSeek getSeekForIx(int ix) {
        IPathSeek seek = this.d_steerPath.pointAt(ix);
        return seek;
    }

    private static Point3d ptProj(Point3d pt, Vector3d vel) {
        Point3d ptProj = new Point3d(pt);
        ptProj.add(vel);
        return ptProj;
    }

    private PathStatus getPathStatus(KB kb, OccAgent oa) {
        boolean pathInvalid;
        double simTime = kb.getCurrentSimTime();
        boolean bl = pathInvalid = this.d_steerPath == null || simTime - this.d_lastPathStartTime >= this.d_minPathRecalcTime && !this.d_seek.isVisible();
        if (this.d_planner.update(kb, oa, pathInvalid)) {
            return pathInvalid ? PathStatus.INVALID : PathStatus.NEEDS_VALIDATION;
        }
        return PathStatus.VALID;
    }

    private double getPathDeviationSq(Point3d startPt, TriPoint curpos) {
        Point3d projSeekCurr = curpos.tri.plane.project(this.d_seek.getSeekPt().p);
        Point3d projSeekLast = curpos.tri.plane.project(startPt);
        Point3d ptAtNear = projSeekLast.epsilonEquals(projSeekCurr, 1.0E-6) ? startPt : Inter.nearPointOnLineSeg(curpos.p, projSeekLast, projSeekCurr);
        return curpos.p.distanceSquared(ptAtNear);
    }

    public static class Status
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final IPath path;
        public final double remainingDist;
        public final IPathPlanner.IStatus plannerStatus;

        public Status(IPath path, double remainingDist, IPathPlanner.IStatus plannerStatus) {
            this.path = path;
            this.remainingDist = remainingDist;
            this.plannerStatus = plannerStatus;
        }
    }

    private static enum PathStatus {
        INVALID,
        NEEDS_VALIDATION,
        VALID;

    }

    private static enum NextSeekResult {
        NEED_NEW_PATH,
        SEEK_TO_NEXT,
        SEEK_TO_CURR;

    }
}

