/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.sim.path.PathChange;
import java.io.ObjectStreamException;
import java.util.function.Predicate;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.Predicates;

public class PathFilters {
    public static Predicate<PathChange> rejectInvalidOnewayCrossings() {
        return RejectOnewayDoors.INSTANCE;
    }

    public static Predicate<PathChange> filterTriangles(boolean enableEscape, Predicate<Tri> triFilter) {
        if (Predicates.alwaysTrue(triFilter)) {
            return Predicates.alwaysTrue();
        }
        return enableEscape ? new EscapeFilter(triFilter) : new TriToPathFilter(triFilter);
    }

    public static Predicate<PathChange> filterEdges(Predicate<WingedEdge> edgeFilter) {
        return Predicates.alwaysTrue(edgeFilter) ? Predicates.alwaysTrue() : new EdgeToPathFilter(edgeFilter);
    }

    public static Predicate<PathChange> acceptDoorDir(WingedEdge door, DoorDir dir) {
        return new AcceptDoorDir(door, dir);
    }

    public static Predicate<PathChange> acceptNodeCorrections(ANode curNode) {
        return new NodeCorrectionFilter(curNode);
    }

    public static Predicate<PathChange> acceptTriCorrections(Tri curTri) {
        return new TriCorrectionFilter(curTri);
    }

    private static DoorDir getDoorDir(PathChange o) {
        assert (o.getType() == PathChange.Type.TRI_ENTER);
        return o.edge.getExitDir(o.tri);
    }

    private static class AcceptDoorDir
    extends APredicate<PathChange> {
        static final long serialVersionUID = 1L;
        public final WingedEdge doorEdge;
        public final DoorDir acceptDir;

        public AcceptDoorDir(WingedEdge doorEdge, DoorDir acceptDir) {
            this.doorEdge = doorEdge;
            this.acceptDir = acceptDir;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof AcceptDoorDir && ((AcceptDoorDir)obj).doorEdge == this.doorEdge && ((AcceptDoorDir)obj).acceptDir == this.acceptDir;
        }

        public int hashCode() {
            return 0x92349FE ^ this.doorEdge.hashCode() + this.acceptDir.hashCode();
        }

        @Override
        public boolean test(PathChange o) {
            return o.getType() == PathChange.Type.TRI_ENTER && this.doorEdge == o.edge && PathFilters.getDoorDir(o) == this.acceptDir;
        }
    }

    private static class RejectOnewayDoors
    extends APredicate<PathChange> {
        static final long serialVersionUID = 1L;
        public static final RejectOnewayDoors INSTANCE = new RejectOnewayDoors();

        private RejectOnewayDoors() {
        }

        @Override
        public boolean test(PathChange o) {
            return o.getType() != PathChange.Type.TRI_ENTER || !o.edge.isDoor() || o.edge.data.node.getOnewayDir() == null || o.tri != o.edge.getSrcTri(o.edge.data.node.getOnewayDir());
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static class EdgeToPathFilter
    extends APredicate<PathChange> {
        static final long serialVersionUID = 1L;
        private final Predicate<WingedEdge> edgeFilter;

        public EdgeToPathFilter(Predicate<WingedEdge> edgeFilter) {
            this.edgeFilter = edgeFilter;
        }

        @Override
        public boolean test(PathChange o) {
            return o.getType() == PathChange.Type.PATH_BEGIN || this.edgeFilter.test(o.edge);
        }

        public boolean equals(Object obj) {
            return obj instanceof EdgeToPathFilter && ((EdgeToPathFilter)obj).edgeFilter.equals(this.edgeFilter);
        }

        public int hashCode() {
            return 0x234F32FE ^ this.edgeFilter.hashCode();
        }
    }

    private static class TriToPathFilter
    extends APredicate<PathChange> {
        static final long serialVersionUID = 1L;
        private final Predicate<Tri> triFilter;

        public TriToPathFilter(Predicate<Tri> triFilter) {
            this.triFilter = triFilter;
        }

        @Override
        public boolean test(PathChange o) {
            return o.getType() == PathChange.Type.EDGE_ENTER || this.triFilter.test(o.tri);
        }

        public boolean equals(Object obj) {
            return obj instanceof TriToPathFilter && ((TriToPathFilter)obj).triFilter.equals(this.triFilter);
        }

        public int hashCode() {
            return 0x269238FE ^ this.triFilter.hashCode();
        }
    }

    private static class EscapeFilter
    extends APredicate<PathChange> {
        static final long serialVersionUID = 1L;
        private final Predicate<Tri> triFilter;

        public EscapeFilter(Predicate<Tri> triFilter) {
            this.triFilter = triFilter;
        }

        @Override
        public boolean test(PathChange o) {
            if (o.getType() != PathChange.Type.TRI_ENTER) {
                return true;
            }
            Tri prevTri = o.edge.getAdjTri(o.tri);
            return prevTri == null || !this.triFilter.test(prevTri) || this.triFilter.test(o.tri);
        }

        public boolean equals(Object obj) {
            return obj instanceof EscapeFilter && ((EscapeFilter)obj).triFilter.equals(this.triFilter);
        }

        public int hashCode() {
            return 0x12FE234A ^ this.triFilter.hashCode();
        }
    }

    private static class TriCorrectionFilter
    extends APredicate<PathChange> {
        static final long serialVersionUID = 1L;
        public final Tri tri;

        public TriCorrectionFilter(Tri tri) {
            this.tri = tri;
        }

        @Override
        public boolean test(PathChange o) {
            return o.tri != null && o.tri == this.tri;
        }

        public boolean equals(Object obj) {
            return obj instanceof TriCorrectionFilter && ((TriCorrectionFilter)obj).tri.equals(this.tri);
        }

        public int hashCode() {
            return 0x1FD83F3E ^ this.tri.hashCode();
        }
    }

    private static class NodeCorrectionFilter
    extends APredicate<PathChange> {
        static final long serialVersionUID = 1L;
        public final ANode node;

        public NodeCorrectionFilter(ANode node) {
            this.node = node;
        }

        @Override
        public boolean test(PathChange o) {
            return o.tri != null && o.edge != null && o.edge.getNode1() != o.edge.getNode2() && o.tri.node == this.node;
        }

        public boolean equals(Object obj) {
            return obj instanceof NodeCorrectionFilter && ((NodeCorrectionFilter)obj).node.equals(this.node);
        }

        public int hashCode() {
            return 0x34987FAD ^ this.node.hashCode();
        }
    }
}

