/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Mesh;
import inferno.data2.Occupant;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.geom.IValueField;
import inferno.geom.NaiveDistanceField;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccSource;
import inferno.sim.path.CompletedFuture;
import inferno.sim.path.DoorQueueEstimate;
import inferno.sim.path.IPath;
import inferno.sim.path.IPathSeek;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.path.WaypointSeek;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.PathFollow;
import inferno.util.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.mtproc.MTListProcessor;
import thunderheadeng.util.mtproc.MTProcessor;
import thunderheadeng.util.theUtil;

public class Estimate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final double DOOR_SEG_TOL = theUtil.getSystemDouble("Estimate.DOOR_SEG_TOL", 1.0);
    protected int d_changeId;
    private final KB d_kb;
    private double d_radiusMin;
    private final Map<ANode, DoorQueueEstimate> d_doorQueues;
    private transient List<DoorQueueEstimate> d_doorQueueList;
    private transient MTListProcessor<DoorQueueEstimate> d_doorQueueProcessor;
    protected Map<DoorToGoalKey, DoorToGoalPair> memo_doorToDoorDistance;
    private Map<Pair<ANode, WingedEdge>, IValueField<Vector3d>> d_distanceFieldMap;
    private transient ExecutorService d_workerExecutor = null;

    public Estimate(KB kb) {
        this.d_kb = kb;
        this.d_doorQueues = new LinkedIdentityHashMap<ANode, DoorQueueEstimate>();
        this.memo_doorToDoorDistance = new HashMap<DoorToGoalKey, DoorToGoalPair>();
        this.d_distanceFieldMap = new HashMap<Pair<ANode, WingedEdge>, IValueField<Vector3d>>();
        this.d_changeId = 0;
        this.d_workerExecutor = Estimate.createWorkerExecutor();
    }

    protected void finalize() throws Throwable {
        this.d_workerExecutor.shutdown();
        super.finalize();
    }

    private static ExecutorService createWorkerExecutor() {
        int minThreads = 2;
        int numThreads = Math.max(minThreads, Engine.getNumProcThreads());
        return Executors.newFixedThreadPool(numThreads);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_workerExecutor = Estimate.createWorkerExecutor();
    }

    public KB getKB() {
        return this.d_kb;
    }

    public void resetDoors() {
        this.memo_doorToDoorDistance.clear();
        ++this.d_changeId;
    }

    public int getChangeId() {
        return this.d_changeId;
    }

    public void init() {
        this.d_radiusMin = Double.MAX_VALUE;
        for (Occupant occ : this.d_kb.getOccs()) {
            this.d_radiusMin = Math.min(this.d_radiusMin, occ.bodyShape.getGeomRadius());
        }
        for (OccSource occSource : this.d_kb.getOccSources()) {
            this.d_radiusMin = Math.min(this.d_radiusMin, occSource.getMinGeomRadius());
        }
        Consumer<ANode> addTransportDistField = room -> {
            if (room != null && room.isTransportNode()) {
                for (WingedEdge door : this.d_kb.getElevatorModel().getTransportEdges(room.getElevatorLevel())) {
                    this.d_distanceFieldMap.put(new Pair<ANode, WingedEdge>((ANode)room, door), new NaiveDistanceField(door));
                }
            }
        };
        for (ANode door : this.d_kb.getDoorNodes()) {
            this.d_doorQueues.put(door, new DoorQueueEstimate(this.d_kb, door));
            ANode room1 = door.doorQueue.getR1();
            ANode room2 = door.doorQueue.getR2();
            for (WingedEdge edge : door.getDoorEdges()) {
                NaiveDistanceField distField = new NaiveDistanceField(edge);
                if (room1 != null) {
                    this.d_distanceFieldMap.put(new Pair<ANode, WingedEdge>(room1, edge), distField);
                }
                if (room2 == null) continue;
                this.d_distanceFieldMap.put(new Pair<ANode, WingedEdge>(room2, edge), distField);
            }
            addTransportDistField.accept(room1);
            addTransportDistField.accept(room2);
        }
    }

    public void pauseWorkers() {
    }

    public void resumeWorkers() {
    }

    public void updateDoorQueues() throws ExecutionException {
        for (DoorQueueEstimate dq : this.d_doorQueues.values()) {
            dq.reset(this.d_kb);
        }
        for (OccAgent oa : this.d_kb.getActiveAgents()) {
            Pair<WingedEdge, DoorDir> door;
            PathFollow pf = oa.getPathFollow();
            if (pf == null || pf.getPath() == null || (door = pf.getPath().getTargetDoor()) == null) continue;
            DoorQueueEstimate dq = this.getQueue((WingedEdge)door.v1);
            DoorQueueEstimate.OccQueue queue = dq.getQueue((DoorDir)((Object)door.v2));
            double dist = pf.getRemainingKnownDistance(oa);
            if (!Double.isFinite(dist)) continue;
            queue.add(oa, dist);
        }
        if (this.d_doorQueueList == null) {
            this.d_doorQueueList = new ArrayList<DoorQueueEstimate>(this.d_doorQueues.values());
        }
        if (this.d_doorQueueProcessor == null) {
            this.d_doorQueueProcessor = new MTListProcessor(Engine.getNumProcThreads(), MTProcessor.Schedule.DYNAMIC, this.d_kb.getThreadPool());
            this.d_doorQueueProcessor.setList(this.d_doorQueueList);
        }
        this.d_doorQueueProcessor.process(new MTProcessor.IProc<DoorQueueEstimate>(){

            @Override
            public void process(DoorQueueEstimate val, int threadNum, int ix) {
                val.finish(Estimate.this.d_kb);
            }
        });
    }

    public DoorQueueEstimate getQueue(WingedEdge queueDoor) {
        assert (queueDoor != null && queueDoor.isDoor());
        return this.d_doorQueues.get(queueDoor.data.node);
    }

    public IValueField<Vector3d> getDistanceField(KB kb, ANode n, WingedEdge localDoor) {
        Pair<ANode, WingedEdge> key = new Pair<ANode, WingedEdge>(n, localDoor);
        IValueField<Vector3d> fld = this.d_distanceFieldMap.get(key);
        assert (fld != null);
        return fld;
    }

    private static boolean canCrossDoor(ANode roomOrigin, WingedEdge roomDoor, Predicate<PathChange> pathFilter) {
        Tri enterTri = roomDoor.getNode1() == roomOrigin ? roomDoor.t2 : roomDoor.t1;
        return pathFilter.test(new PathChange(enterTri, roomDoor));
    }

    public Future<DoorToGoalValue> doorToPointDistance(Mesh m, WingedEdge doorStart, ITpSource target, ANode roomOrigin, Predicate<PathChange> pathFilter) {
        PathGen.PointGoal goal = new PathGen.PointGoal(target);
        if (Estimate.canCrossDoor(roomOrigin, doorStart, pathFilter)) {
            return this.doorToGoalDistance(doorStart, goal, roomOrigin, pathFilter);
        }
        return new CompletedFuture<DoorToGoalValue>(DoorToGoalValue.noPath(doorStart, goal));
    }

    private PointToGoalDist pointToGoalDistanceImpl(WingedEdge door0, double t0, PathGen.IPathGoal goal, Predicate<PathChange> pathFilter) {
        DoorDir revDir;
        TriPoint[] ptsArr;
        Point3d pt0 = door0.base.get(t0);
        Tri startTri = door0.t1 != null ? door0.t1 : door0.t2;
        PathGen.IAStarResult result = PathGen.getPathAStarDetailed(this.d_kb.getMesh(), startTri, door0, null, pt0, goal, this.d_radiusMin, Double.MAX_VALUE, pathFilter);
        if (result instanceof PathGen.AStarFailure) {
            return null;
        }
        PathGen.AStarSuccess astarSuccess = (PathGen.AStarSuccess)result;
        PathGen.MTSearchNode node = astarSuccess.node;
        ArrayList<TriEdge> forwardEdges = PathGen.getPathEdgePoints(node);
        ArrayList<TriEdge> spEdges = forwardEdges.size() >= 2 ? forwardEdges.subList(1, forwardEdges.size()) : forwardEdges;
        Tri firstTriCorrection = ((TriEdge)forwardEdges.get((int)0)).tri;
        TriPoint startPt = new TriPoint(firstTriCorrection, pt0);
        List<TriPoint> pts = PathGen.stringPullFixedEndPoints(this.d_kb.getMesh(), spEdges, astarSuccess.goalReached, startPt, goal, this.d_radiusMin);
        if (pts.get((int)0).tri != firstTriCorrection) {
            pts = new ArrayList<TriPoint>(pts);
            pts.set(0, new TriPoint(firstTriCorrection, pts.get((int)0).p));
        }
        if (pts == null) {
            return null;
        }
        assert (((TriEdge)forwardEdges.get((int)0)).edge == door0);
        IPath tempPath = new FakePath(pts);
        if ((tempPath = PathGen.getPrunedPath(this.d_kb, tempPath, false)) != null) {
            ptsArr = new TriPoint[tempPath.getNumPoints(false)];
            for (int m = 0; m < ptsArr.length; ++m) {
                ptsArr[m] = tempPath.pointAt(m).getSeekPt();
            }
        } else {
            ptsArr = new TriPoint[]{};
        }
        double pathLen = PathGen.getPathLength(Arrays.asList(ptsArr));
        LinkedHashSet<Pair<WingedEdge, DoorDir>> usedDoors = new LinkedHashSet<Pair<WingedEdge, DoorDir>>();
        for (TriEdge te : forwardEdges) {
            if (!te.edge.isDoor()) continue;
            DoorDir dir = te.edge.getDir(te.tri);
            usedDoors.add(new Pair<WingedEdge, DoorDir>(te.edge, dir));
        }
        TriEdge firstEdge = (TriEdge)forwardEdges.get(0);
        DoorDir fwdDir = firstEdge.edge.getDir(firstEdge.tri);
        if (forwardEdges.size() == 1) {
            revDir = fwdDir;
        } else {
            TriEdge lastEdge = (TriEdge)forwardEdges.get(forwardEdges.size() - 1);
            revDir = lastEdge.edge.getDir(lastEdge.tri).opposite();
        }
        PointToGoalDist forVal = new PointToGoalDist(door0, t0, pathLen, pathLen, fwdDir, revDir, ptsArr, usedDoors);
        return forVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DoorToGoalPair getDoorToGoalPair(WingedEdge doorStart, PathGen.IPathGoal goal, ANode roomOrigin, Predicate<PathChange> pathFilter) {
        DoorToGoalKey key = new DoorToGoalKey(doorStart, goal, roomOrigin, pathFilter);
        Map<DoorToGoalKey, DoorToGoalPair> map = this.memo_doorToDoorDistance;
        synchronized (map) {
            DoorToGoalPair result = this.memo_doorToDoorDistance.get(key);
            if (result == null) {
                result = new DoorToGoalPair(doorStart, goal);
                this.memo_doorToDoorDistance.put(key, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<DoorToGoalValue> doorToGoalDistance(WingedEdge doorStart, PathGen.IPathGoal goal, ANode roomOrigin, Predicate<PathChange> pathFilter) {
        DoorToGoalPair pair;
        Function<Consumer, Future> calc = cacheResult -> {
            Supplier<DoorToGoalValue> getEarlyResult = () -> {
                if (!Estimate.canCrossDoor(roomOrigin, doorStart, pathFilter) || !this.d_kb.getMesh().isEdgeTravellable(doorStart, this.d_radiusMin)) {
                    return DoorToGoalValue.noPath(doorStart, goal);
                }
                if (goal.testReached(new PathChange(null, doorStart)) != null) {
                    PathGen.IPathGoal vgoal = doorStart.isExit() ? new PathGen.EdgeGoal(doorStart) : goal;
                    return DoorToGoalValue.zeroPath(doorStart, vgoal, roomOrigin);
                }
                return null;
            };
            DoorToGoalValue earlyResult = getEarlyResult.get();
            if (earlyResult != null) {
                cacheResult.accept(earlyResult);
                return new CompletedFuture<DoorToGoalValue>(earlyResult);
            }
            ArrayList<Future<PointToGoalDist>> pointFutures = new ArrayList<Future<PointToGoalDist>>();
            int nPoints = (int)Math.max(1.0, (double)Math.round(wingedEdge.base.length() / DOOR_SEG_TOL));
            int nSegs = nPoints + 1;
            double iNSegs = 1.0 / (double)nSegs;
            for (int m = 1; m < nSegs; ++m) {
                double t = (double)m * iNSegs;
                Callable<PointToGoalDist> ptask = () -> {
                    Engine.TIME_ACCUM.begin("DTD");
                    PointToGoalDist value = this.pointToGoalDistanceImpl(doorStart, t, goal, roomOrigin, pathFilter);
                    Engine.TIME_ACCUM.end("DTD");
                    return value;
                };
                pointFutures.add(this.d_workerExecutor.submit(ptask));
            }
            Callable<DoorToGoalValue> task = () -> {
                ArrayList<PointToGoalDist> dists = new ArrayList<PointToGoalDist>(pointFutures.size());
                for (Future fdist : pointFutures) {
                    PointToGoalDist pdist = (PointToGoalDist)fdist.get();
                    if (pdist == null || !pdist.areDoorsConnected()) continue;
                    dists.add(pdist);
                }
                DoorToGoalValue result = dists.isEmpty() ? DoorToGoalValue.noPath(doorStart, goal) : new DoorToGoalValue(doorStart, goal, true, dists);
                cacheResult.accept(result);
                return result;
            };
            return this.d_workerExecutor.submit(task);
        };
        if (!goal.isStatic(this.d_kb)) {
            return calc.apply(r -> {});
        }
        DoorToGoalPair doorToGoalPair = pair = this.getDoorToGoalPair(doorStart, goal, roomOrigin, pathFilter);
        synchronized (doorToGoalPair) {
            Future value = pair.getValue(doorStart);
            if (value == null) {
                value = calc.apply(r -> {
                    DoorToGoalPair doorToGoalPair2 = pair;
                    synchronized (doorToGoalPair2) {
                        pair.setValue(doorStart, new CompletedFuture<DoorToGoalValue>((DoorToGoalValue)r));
                    }
                });
                pair.setValue(doorStart, value);
            }
            return value;
        }
    }

    protected PointToGoalDist pointToGoalDistanceImpl(WingedEdge doorStart, double t0, PathGen.IPathGoal goal, ANode roomOrigin, Predicate<PathChange> pathFilter) {
        PathChange tempPathChange = new PathChange();
        Predicate<PathChange> baseFilter = pathFilter;
        Predicate<PathChange> searchFilter = o -> {
            if (o.getType() == PathChange.Type.PATH_BEGIN) {
                assert (o.tri == wingedEdge.t1 || o.tri == wingedEdge.t2);
                tempPathChange.set(o.tri, doorStart, o.node);
                o = tempPathChange;
            }
            return baseFilter.test((PathChange)o);
        };
        PointToGoalDist result = this.pointToGoalDistanceImpl(doorStart, t0, goal, searchFilter);
        if (result == null) {
            return null;
        }
        assert (result.isValid());
        ANode destNode = result.getDestNode(doorStart);
        if (destNode == null) {
            return result;
        }
        if (destNode != roomOrigin && !this.getAStarFailed(doorStart, goal, roomOrigin, pathFilter, result)) {
            return result;
        }
        PointToGoalDist resultForced = this.pointToDoorDistanceNeverRevistAnyRoom(doorStart, t0, goal, roomOrigin, pathFilter);
        if (resultForced == null) {
            return null;
        }
        resultForced = resultForced.setNaturalDist(result.naturalDist);
        assert (resultForced.isValid());
        result = resultForced;
        return result;
    }

    private boolean getAStarFailed(WingedEdge doorStart, PathGen.IPathGoal goal, ANode roomOrigin, Predicate<PathChange> pathFilter, PointToGoalDist naturalResult) {
        return false;
    }

    private static Set<Pair<WingedEdge, DoorDir>> reverseDirs(Collection<Pair<WingedEdge, DoorDir>> doorDirs) {
        LinkedHashSet<Pair<WingedEdge, DoorDir>> revDoorDirs = new LinkedHashSet<Pair<WingedEdge, DoorDir>>(doorDirs.size());
        for (Pair<WingedEdge, DoorDir> usedDoor : doorDirs) {
            DoorDir opp = usedDoor.v2 != null ? ((DoorDir)((Object)usedDoor.v2)).opposite() : null;
            revDoorDirs.add(new Pair(usedDoor.v1, opp));
        }
        return revDoorDirs;
    }

    private PointToGoalDist pointToDoorDistanceNeverRevistAnyRoom(final WingedEdge doorStart, double t0, PathGen.IPathGoal goal, final ANode roomOrigin, Predicate<PathChange> pathFilter) {
        final Predicate<PathChange> baseFilter = pathFilter;
        final PathChange tempPathChange = new PathChange();
        Predicate<PathChange> searchFilter = new Predicate<PathChange>(){

            @Override
            public boolean test(PathChange o) {
                PathChange.Type type = o.getType();
                if (type == PathChange.Type.PATH_BEGIN) {
                    if (o.tri.node == roomOrigin) {
                        return false;
                    }
                    assert (o.tri == doorStart.t1 || o.tri == doorStart.t2);
                    tempPathChange.set(o.tri, doorStart, o.node);
                    o = tempPathChange;
                } else if (type == PathChange.Type.TRI_ENTER && o.edge.isDoor() && !o.edge.isInternal()) {
                    ANode newNode = o.tri.node;
                    if (newNode == roomOrigin) {
                        return false;
                    }
                    PathGen.MTSearchNode mtnode = o.node;
                    if (mtnode != null) {
                        mtnode = mtnode.parent;
                    }
                    while (mtnode != null) {
                        if (mtnode != null && mtnode.destTri() != null && mtnode.destTri().node == newNode) {
                            return false;
                        }
                        mtnode = mtnode.parent;
                    }
                }
                return baseFilter.test(o);
            }
        };
        return this.pointToGoalDistanceImpl(doorStart, t0, goal, searchFilter);
    }

    private static class CameFrom {
        public final WingedEdge door;
        public final DoorDir dir;
        public final TriEdge firstEdge;
        public final TriEdge lastEdge;

        public CameFrom(WingedEdge door, DoorDir dir, TriEdge firstEdge1, TriEdge firstEdge2) {
            this.door = door;
            this.dir = dir;
            this.firstEdge = firstEdge1;
            this.lastEdge = firstEdge2;
        }
    }

    public static class DoorToGoalKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final WingedEdge doorStart;
        public final PathGen.IPathGoal goal;
        public final ANode roomOrigin;
        public final Predicate<PathChange> pathFilter;
        private final int d_hashCode;

        public DoorToGoalKey(WingedEdge doorStart, PathGen.IPathGoal doorGoal, ANode roomOrigin, Predicate<PathChange> pathFilter) {
            this.doorStart = doorStart;
            this.goal = doorGoal;
            this.roomOrigin = roomOrigin;
            this.pathFilter = pathFilter;
            this.d_hashCode = this.calcHashCode();
        }

        private int calcHashCode() {
            return 1118783 + System.identityHashCode(this.doorStart) + this.goal.hashCode() + System.identityHashCode(this.roomOrigin) + this.pathFilter.hashCode();
        }

        public int hashCode() {
            return this.d_hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DoorToGoalKey)) {
                return false;
            }
            DoorToGoalKey dtd = (DoorToGoalKey)obj;
            return this.doorStart == dtd.doorStart && this.goal.equals(dtd.goal) && this.roomOrigin == dtd.roomOrigin && this.pathFilter.equals(dtd.pathFilter);
        }
    }

    public static class DoorToGoalValue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final WingedEdge door1;
        public final PathGen.IPathGoal goal;
        public final boolean initialized;
        public final List<PointToGoalDist> dists;
        public final PointToGoalDist minDist;
        public final PointToGoalDist maxDist;
        public final DoorDir dir1;
        public final DoorDir dir2;

        public DoorToGoalValue(WingedEdge door1, PathGen.IPathGoal goal, boolean initialized, List<PointToGoalDist> dists) {
            this.door1 = door1;
            this.goal = goal;
            this.initialized = initialized;
            this.dists = dists;
            Comparator distCompare = (d1, d2) -> Double.compare(d1.dist, d2.dist);
            if (!initialized) {
                this.minDist = this.maxDist = PointToGoalDist.invalidPath(door1, 0.5);
            } else if (dists.isEmpty()) {
                this.minDist = this.maxDist = PointToGoalDist.noPath(door1, 0.5);
            } else {
                this.minDist = (PointToGoalDist)dists.stream().min(distCompare).get();
                this.maxDist = (PointToGoalDist)dists.stream().max(distCompare).get();
            }
            if (door1 != null && door1.isExit()) {
                this.dir1 = this.dir2 = door1.getExitDir();
            } else if (dists.isEmpty()) {
                this.dir2 = door1 != null ? DoorDir.POSITIVE : null;
                this.dir1 = this.dir2;
            } else {
                PointToGoalDist dist0 = dists.get(0);
                assert (dists.stream().allMatch(d -> d.dir1 == pointToGoalDist.dir1)) : String.format("All tail paths from %s should be going in the same direction.", door1.getDoorQueue().getNode().name);
                this.dir1 = dist0.dir1;
                this.dir2 = dist0.dir2;
            }
        }

        public static DoorToGoalValue noPath(WingedEdge doorStart, PathGen.IPathGoal goal) {
            return new DoorToGoalValue(doorStart, goal, true, Collections.emptyList());
        }

        public static DoorToGoalValue zeroPath(WingedEdge door, PathGen.IPathGoal goal, ANode srcNode) {
            DoorDir dir = door.getDir(srcNode).opposite();
            List<PointToGoalDist> points = Collections.singletonList(PointToGoalDist.zeroPath(door, 0.5, dir));
            return new DoorToGoalValue(door, goal, true, points);
        }

        public PointToGoalDist getDistFrom(Point3d p) {
            double t = this.door1.base.get(p);
            return this.getDistFrom(t);
        }

        public PointToGoalDist getDistFrom(double t) {
            if (!this.initialized) {
                return PointToGoalDist.invalidPath(this.door1, t);
            }
            if (this.dists.isEmpty()) {
                return PointToGoalDist.noPath(this.door1, t);
            }
            int ix = Collections.binarySearch(this.dists, t);
            if (ix < 0) {
                if ((ix = -ix - 1) == 0) {
                    return this.dists.get(0);
                }
                if (ix == this.dists.size()) {
                    return this.dists.get(this.dists.size() - 1);
                }
                PointToGoalDist dist1 = this.dists.get(ix - 1);
                PointToGoalDist dist2 = this.dists.get(ix);
                return t - dist1.dist <= dist2.dist - t ? dist1 : dist2;
            }
            return this.dists.get(ix);
        }

        public DoorDir getDir(WingedEdge door) {
            return door == this.door1 ? this.dir1 : this.dir2;
        }

        public DoorDir getNaturalDir(PointToGoalDist pgdist) {
            DoorDir outDir = this.dir1;
            return pgdist.naturalDist == pgdist.dist ? outDir : outDir.opposite();
        }

        public ANode getDestNode(WingedEdge door) {
            DoorDir dir = this.getDir(door);
            assert (dir != null);
            return door.getDestNode(dir);
        }
    }

    public static class PointToGoalDist
    implements Serializable,
    Comparable<Double> {
        private static final long serialVersionUID = 1L;
        public final WingedEdge edge;
        public final double t;
        public final double dist;
        public final double naturalDist;
        public final DoorDir dir1;
        public final DoorDir dir2;
        public final TriPoint[] path;
        public final Set<Pair<WingedEdge, DoorDir>> usedDoors;

        public PointToGoalDist(WingedEdge edge, double t, double dist, double naturalDist, DoorDir dir1, DoorDir dir2, TriPoint[] path, Collection<Pair<WingedEdge, DoorDir>> usedDoors) {
            assert (usedDoors != null && Util.isOrdered(usedDoors));
            this.edge = edge;
            this.t = t;
            this.dist = dist;
            this.naturalDist = naturalDist;
            this.dir1 = dir1;
            this.dir2 = dir2;
            this.path = path == null ? new TriPoint[]{} : path;
            this.usedDoors = usedDoors == null || usedDoors instanceof Set ? (Set<Object>)usedDoors : new LinkedHashSet<Pair<WingedEdge, DoorDir>>(usedDoors);
        }

        public static PointToGoalDist invalidPath(WingedEdge edge, double t) {
            return new PointToGoalDist(edge, t, Double.NaN, Double.NaN, null, null, new TriPoint[0], Collections.emptyList());
        }

        public static PointToGoalDist noPath(WingedEdge edge, double t) {
            DoorDir dir = edge.isExit() ? edge.getExitDir() : DoorDir.POSITIVE;
            return new PointToGoalDist(edge, t, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, dir, dir, new TriPoint[0], Collections.emptyList());
        }

        public static PointToGoalDist zeroPath(WingedEdge edge, double t, DoorDir exitDir) {
            return new PointToGoalDist(edge, t, 0.0, 0.0, exitDir, exitDir, new TriPoint[0], Collections.singleton(new Pair<WingedEdge, DoorDir>(edge, exitDir)));
        }

        public PointToGoalDist setNaturalDist(double ndist) {
            return new PointToGoalDist(this.edge, this.t, this.dist, ndist, this.dir1, this.dir2, this.path, this.usedDoors);
        }

        @Override
        public int compareTo(Double o) {
            return Double.compare(this.t, o);
        }

        public ANode getDestNode(WingedEdge door) {
            DoorDir dir;
            DoorDir doorDir = dir = door == this.edge ? this.dir1 : this.dir2;
            assert (dir != null);
            return door.getDestNode(dir);
        }

        public boolean isValid() {
            return this.isInitialized() && (!this.areDoorsConnected() || this.dist == 0.0 || this.dir1 != null);
        }

        private boolean isInitialized() {
            return !Double.isNaN(this.dist);
        }

        public boolean areDoorsConnected() {
            return !Double.isInfinite(this.dist);
        }
    }

    public static class DoorToGoalPair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final WingedEdge door1;
        public final PathGen.IPathGoal goal;
        public Future<DoorToGoalValue> val12;

        public DoorToGoalPair(WingedEdge door1, PathGen.IPathGoal goal) {
            this.door1 = door1;
            this.goal = goal;
            this.val12 = null;
        }

        public Future<DoorToGoalValue> getValue(WingedEdge startDoor) {
            return this.val12;
        }

        public void setValue(WingedEdge startDoor, Future<DoorToGoalValue> val) {
            this.val12 = val;
        }
    }

    private static class FakePath
    implements IPath {
        private final List<TriPoint> points;

        public FakePath(List<TriPoint> points) {
            this.points = points;
        }

        @Override
        public int getNumPoints(boolean fuzzy) {
            return this.points.size();
        }

        @Override
        public Pair<WingedEdge, DoorDir> getTargetDoor() {
            return null;
        }

        @Override
        public double length(boolean fuzzy) {
            return 0.0;
        }

        @Override
        public IPathSeek pointAt(int ix) {
            return new WaypointSeek(this.points.get(ix), Filters.acceptAll(WingedEdge.class));
        }
    }
}

