/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.ElevatorLevel;
import inferno.data2.IElevator;
import inferno.data2.ITimeEstimate;
import inferno.data2.WingedEdge;
import inferno.sim.DoorQueue;
import inferno.sim.IFormationLeaderAgent;
import inferno.sim.KB;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;

public class EdgeFilters
extends Filters {
    public static Predicate<WingedEdge> rejectAllBoundaries() {
        return RejectAllBoundaries.INSTANCE;
    }

    public static Predicate<WingedEdge> filterDoors(Predicate<ANode> doorNodeFilter) {
        return Predicates.or(EdgeFilters.rejectAllDoors(), EdgeFilters.toEdgeFilter(doorNodeFilter));
    }

    public static Predicate<WingedEdge> rejectAllDoors() {
        return RejectAllDoors.INSTANCE;
    }

    public static Predicate<WingedEdge> filterOnewayDoors(Predicate<WingedEdge> onewayFilter) {
        return Predicates.or(EdgeFilters.rejectAllOnewayDoors(), onewayFilter);
    }

    public static Predicate<WingedEdge> rejectAllOnewayDoors() {
        return RejectAllOnewayDoors.INSTANCE;
    }

    public static Predicate<WingedEdge> filterElevatorDoors(Predicate<WingedEdge> doorFilter) {
        return Predicates.or(EdgeFilters.rejectAllElevatorDoors(), doorFilter);
    }

    public static Predicate<WingedEdge> rejectAllElevatorDoors() {
        return RejectAllElevatorDoors.INSTANCE;
    }

    public static Predicate<WingedEdge> rejectAllFlowrateDoors(KB kb) {
        return new RejectAllFlowrateDoors(kb);
    }

    public static Predicate<WingedEdge> filterDangerous(Predicate<WingedEdge> edgeFilter, boolean filterOnewayDoors) {
        if (!filterOnewayDoors) {
            return EdgeFilters.filterElevatorDoors(edgeFilter);
        }
        return Predicates.or(EdgeFilters.rejectAllDangerous(true), edgeFilter);
    }

    public static Predicate<WingedEdge> acceptRoomEdges(ANode room) {
        return new AcceptRoomEdges(room);
    }

    public static Predicate<WingedEdge> rejectAllDangerous(boolean rejectOnewayDoors) {
        return !rejectOnewayDoors ? EdgeFilters.rejectAllElevatorDoors() : RejectAllDangerous.INSTANCE;
    }

    public static boolean isDangerous(WingedEdge o) {
        return o.isOnewayDoor() || o.isElevatorDoor();
    }

    public static Predicate<WingedEdge> rejectPermanentlyClosedDoors() {
        return RejectPermanentlyClosedDoors.INSTANCE;
    }

    public static Predicate<WingedEdge> filterPermanentlyClosedDoors(Predicate<ANode> permanentlyClosedFilter) {
        return Predicates.or(EdgeFilters.rejectPermanentlyClosedDoors(), EdgeFilters.toEdgeFilter(permanentlyClosedFilter));
    }

    public static Predicate<WingedEdge> filterClosedDoors(Predicate<ANode> closedDoorNodeFilter) {
        return Predicates.or(EdgeFilters.rejectAllClosedDoors(), EdgeFilters.toEdgeFilter(closedDoorNodeFilter));
    }

    public static Predicate<WingedEdge> rejectAllClosedDoors() {
        return RejectAllClosedDoors.INSTANCE;
    }

    public static Predicate<WingedEdge> filterExits(Predicate<ANode> exitNodeFilter) {
        return Predicates.or(EdgeFilters.rejectAllExits(), EdgeFilters.toEdgeFilter(exitNodeFilter));
    }

    public static Predicate<WingedEdge> rejectAllExits() {
        return RejectAllExits.INSTANCE;
    }

    private static final Predicate<WingedEdge> toEdgeFilter(Predicate<ANode> nodeFilter) {
        if (Predicates.alwaysTrue(nodeFilter)) {
            return Predicates.alwaysTrue();
        }
        if (Predicates.alwaysFalse(nodeFilter)) {
            return Predicates.alwaysFalse();
        }
        return new NodeToEdgeFilter(nodeFilter);
    }

    public static Predicate<WingedEdge> restrictElevatorUseToFloor(final Map<IElevator, Set<WingedEdge>> tempElevatorRestrictions) {
        return new APredicate<WingedEdge>(){

            @Override
            public boolean test(WingedEdge t) {
                if (tempElevatorRestrictions.isEmpty()) {
                    return true;
                }
                if (!t.isElevatorDoor()) {
                    return true;
                }
                IElevator elevator = null;
                for (Map.Entry entry : tempElevatorRestrictions.entrySet()) {
                    if (!((Set)entry.getValue()).contains(t)) continue;
                    elevator = (IElevator)entry.getKey();
                    break;
                }
                ElevatorLevel level = t.getElevatorLevel().get();
                if (elevator == null) {
                    return true;
                }
                if (elevator.getTargetLevel() == level || elevator.isDoubleDeck() && elevator.getUpperTargetLevel() == level) {
                    return true;
                }
                return !tempElevatorRestrictions.containsKey(elevator) || ((Set)tempElevatorRestrictions.get(elevator)).contains(t);
            }
        };
    }

    public static class AcceptPartiallyTraversedDoors
    extends APredicate<WingedEdge> {
        static final long serialVersionUID = 1L;
        private IFormationLeaderAgent leaderAgent;

        public AcceptPartiallyTraversedDoors(IFormationLeaderAgent leaderAgent) {
            this.leaderAgent = leaderAgent;
        }

        public int hashCode() {
            return 0x8F33FE ^ this.leaderAgent.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof AcceptPartiallyTraversedDoors && ((AcceptPartiallyTraversedDoors)obj).leaderAgent == this.leaderAgent;
        }

        @Override
        public boolean test(WingedEdge t) {
            if (!t.isDoor()) {
                return false;
            }
            DoorQueue dq = t.getDoorQueue();
            return this.leaderAgent.isFreePassDoor(dq);
        }
    }

    private static class RejectAllFlowrateDoors
    extends APredicate<WingedEdge> {
        static final long serialVersionUID = 1L;
        private final KB kb;

        public RejectAllFlowrateDoors(KB kb) {
            this.kb = kb;
        }

        @Override
        public boolean test(WingedEdge t) {
            return !t.isDoor() || !t.getDoorQueue().getFinalFlowrate(this.kb).isFinite(this.kb);
        }

        public int hashCode() {
            return 0x7F33FE ^ System.identityHashCode(this.kb);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof RejectAllFlowrateDoors && ((RejectAllFlowrateDoors)obj).kb == this.kb;
        }
    }

    private static class RejectAllElevatorDoors
    extends APredicate<WingedEdge> {
        static final long serialVersionUID = 1L;
        private static final RejectAllElevatorDoors INSTANCE = new RejectAllElevatorDoors();

        private RejectAllElevatorDoors() {
        }

        @Override
        public boolean test(WingedEdge t) {
            return !t.isElevatorDoor();
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static class RejectAllDangerous
    extends APredicate<WingedEdge> {
        static final long serialVersionUID = 1L;
        private static final RejectAllDangerous INSTANCE = new RejectAllDangerous();

        private RejectAllDangerous() {
        }

        @Override
        public boolean test(WingedEdge t) {
            return !EdgeFilters.isDangerous(t);
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static class RejectPermanentlyClosedDoors
    extends APredicate<WingedEdge> {
        public static final RejectPermanentlyClosedDoors INSTANCE = new RejectPermanentlyClosedDoors();
        static final long serialVersionUID = 1L;

        private RejectPermanentlyClosedDoors() {
        }

        @Override
        public boolean test(WingedEdge wedge) {
            return !wedge.isDoor() || wedge.data.node.getNextOpenTimeEst() != ITimeEstimate.FOREVER;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static class AcceptRoomEdges
    extends APredicate<WingedEdge> {
        static final long serialVersionUID = 1L;
        private final ANode d_room;

        public AcceptRoomEdges(ANode room) {
            this.d_room = room;
        }

        @Override
        public boolean test(WingedEdge t) {
            return t.getNode1() == this.d_room || t.getNode2() == this.d_room;
        }

        public int hashCode() {
            return 0x1623F3FE ^ Objects.hashCode(this.d_room);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof AcceptRoomEdges && ((AcceptRoomEdges)obj).d_room == this.d_room;
        }
    }

    private static class RejectAllBoundaries
    extends APredicate<WingedEdge> {
        static final long serialVersionUID = 1L;
        private static RejectAllBoundaries INSTANCE = new RejectAllBoundaries();

        private RejectAllBoundaries() {
        }

        @Override
        public boolean test(WingedEdge t) {
            return !t.isBoundary();
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static class RejectAllDoors
    extends APredicate<WingedEdge> {
        static final long serialVersionUID = 1L;
        private static RejectAllDoors INSTANCE = new RejectAllDoors();

        private RejectAllDoors() {
        }

        @Override
        public boolean test(WingedEdge t) {
            return !t.isDoor();
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static class RejectAllOnewayDoors
    extends APredicate<WingedEdge> {
        static final long serialVersionUID = 1L;
        private static RejectAllOnewayDoors INSTANCE = new RejectAllOnewayDoors();

        private RejectAllOnewayDoors() {
        }

        @Override
        public boolean test(WingedEdge t) {
            return !t.isOnewayDoor();
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static class RejectAllExits
    extends APredicate<WingedEdge> {
        static final long serialVersionUID = 1L;
        private static RejectAllExits INSTANCE = new RejectAllExits();

        private RejectAllExits() {
        }

        @Override
        public boolean test(WingedEdge t) {
            return !t.isExit();
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static class RejectAllClosedDoors
    extends APredicate<WingedEdge> {
        static final long serialVersionUID = 1L;
        private static RejectAllClosedDoors INSTANCE = new RejectAllClosedDoors();

        private RejectAllClosedDoors() {
        }

        @Override
        public boolean test(WingedEdge t) {
            return !t.isDoor() || !t.data.node.isPhysicallyClosed();
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static class NodeToEdgeFilter
    extends APredicate<WingedEdge> {
        static final long serialVersionUID = 1L;
        private final Predicate<ANode> nodeFilter;

        public NodeToEdgeFilter(Predicate<ANode> nodeFilter) {
            this.nodeFilter = nodeFilter;
        }

        @Override
        public boolean test(WingedEdge t) {
            return this.nodeFilter.test(t.data.node);
        }

        public int hashCode() {
            return 0x32948FDE ^ this.nodeFilter.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof NodeToEdgeFilter && ((NodeToEdgeFilter)obj).nodeFilter.equals(this.nodeFilter);
        }
    }
}

