/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Mesh;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.sim.path.IPathSeek;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class DoorSeek
implements IPathSeek,
Serializable {
    private static final long serialVersionUID = 1L;
    public final WingedEdge door;
    private final Point3d[] endpoints;
    public final DoorDir dir;
    private final TriPoint backupPt;
    private final Predicate<WingedEdge> edgeFilter;
    private Vector3d seekDir;
    private TriPoint currEdgeSeek;
    private double obstDist;
    public final boolean isVirtual;

    public DoorSeek(WingedEdge door, Point3d[] endpoints, TriPoint backupPt, Predicate<WingedEdge> edgeFilter, boolean isVirtual) {
        this.door = door;
        this.endpoints = endpoints;
        this.isVirtual = isVirtual;
        this.dir = door.getExitDir(backupPt.tri);
        this.backupPt = backupPt;
        this.edgeFilter = edgeFilter;
        this.obstDist = Double.POSITIVE_INFINITY;
        this.currEdgeSeek = backupPt;
    }

    @Override
    public DoorSeek clone() {
        try {
            DoorSeek seek = (DoorSeek)super.clone();
            return seek;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public TriPoint updateSeekPt(TriPoint currLoc, double radius, Mesh mesh) {
        this.currEdgeSeek = this.getIdealSeekPt(currLoc, radius, mesh);
        return this.currEdgeSeek;
    }

    @Override
    public TriPoint getSeekPt() {
        return this.currEdgeSeek;
    }

    @Override
    public boolean updateVisibility(TriPoint currLoc, double radius, Mesh mesh) {
        double d = this.obstDist = this.currEdgeSeek != null ? mesh.getPathObstructionDist(currLoc, this.currEdgeSeek, radius, this.edgeFilter) : 0.0;
        if (!this.isVisible()) {
            this.currEdgeSeek = this.backupPt;
            this.obstDist = mesh.getPathObstructionDist(currLoc, this.currEdgeSeek, radius, this.edgeFilter);
        }
        return this.isVisible();
    }

    @Override
    public double getObstructionDist() {
        return this.obstDist;
    }

    private TriPoint getIdealSeekPt(TriPoint currLoc, double radius, Mesh mesh) {
        Point3d nearpt = Inter3D.nearestPointOnLineSeg(this.endpoints[0], this.endpoints[1], currLoc.p);
        return new TriPoint(this.backupPt.tri, nearpt);
    }

    @Override
    public Vector3d getPredictDir() {
        if (this.seekDir == null) {
            for (WingedEdgeUse eu : this.backupPt.tri.eu) {
                if (eu.wedge != this.door) continue;
                Vector3d edir = eu.edgeDir();
                Vector3d triNorm = this.backupPt.tri.normal;
                if (theUtil.eq0(triNorm.z, 1.0E-6)) {
                    triNorm = GeomConstants.VEC3D_ZPOS;
                }
                this.seekDir = Util3D.cross(triNorm, edir);
                this.seekDir.normalize();
                break;
            }
        }
        return this.seekDir;
    }

    @Override
    public boolean isVirtual(ANode node) {
        if (!this.isVirtual) {
            return false;
        }
        return !node.getDoorEdges().contains(this.door);
    }
}

