/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import java.util.ArrayList;
import java.util.List;

public class TsvOutput {
    private List<String[]> d_rows = new ArrayList<String[]>();

    public void addRow(String[] row) {
        if (!this.d_rows.isEmpty() && this.d_rows.get(0).length != row.length) {
            throw new IllegalArgumentException(String.format("Invalid number of rows %s, expected %s", row.length, this.d_rows.get(0).length));
        }
        this.d_rows.add(row);
    }

    private int getColumnWidth(int i) {
        int maxRowWidth = 0;
        for (String[] row : this.d_rows) {
            maxRowWidth = Math.max(maxRowWidth, row[i].length());
        }
        return maxRowWidth;
    }

    public String toString() {
        if (this.d_rows.isEmpty()) {
            return "";
        }
        ArrayList<String> rowFormatStrs = new ArrayList<String>();
        int cols = this.d_rows.get(0).length;
        for (int i = 0; i < cols; ++i) {
            rowFormatStrs.add("%" + this.getColumnWidth(i) + "s");
        }
        String rowFormatStr = String.join((CharSequence)"\t", rowFormatStrs);
        StringBuilder output = new StringBuilder();
        for (String[] row : this.d_rows) {
            output.append(String.format(rowFormatStr, row));
            output.append(System.lineSeparator());
        }
        return output.toString();
    }
}

