/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.io.SerializedOutputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class Output {
    public static OutputStream createStream(String fn) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(fn));
    }

    public static OutputStream createStream(SerializedOutputStream sos) throws FileNotFoundException {
        return new BufferedOutputStream(sos.stream());
    }

    public static DataOutputStream openBinStream(SerializedOutputStream sos) throws FileNotFoundException {
        return new DataOutputStream(Output.createStream(sos));
    }

    public static DataOutputStream openBinStream(String fn) throws FileNotFoundException {
        return new DataOutputStream(Output.createStream(fn));
    }

    public static PrintStream openTxtStream(SerializedOutputStream sos) throws FileNotFoundException {
        try {
            return new PrintStream(Output.createStream(sos), false, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new PrintStream(Output.createStream(sos));
        }
    }

    public static PrintStream openTxtStream(String fn) throws FileNotFoundException {
        try {
            return new PrintStream(Output.createStream(fn), false, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new PrintStream(Output.createStream(fn));
        }
    }

    public static void close(Closeable w) {
        try {
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

