/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.OccAnim;
import inferno.data2.Occupant;
import inferno.data2.PolygonShape;
import inferno.data2.ai.ControlledOccGoal;
import inferno.data2.ai.IGoal;
import inferno.sim.AVisWriter;
import inferno.sim.BehaviorSim;
import inferno.sim.IRelation;
import inferno.sim.KB;
import inferno.sim.ObjectTracker;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import inferno.sim.OccTracker;
import inferno.sim.VehicleBody;
import java.awt.Color;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Color3b;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class OccVisWriter
extends AVisWriter
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final int DEFAULT_AGENT_BLOCK_SIZE = 134000;
    private static final int VERSION = 17;
    private static final int FLAGS = 0;
    public static final int OCCPROP_DONE = 0;
    public static final int OCCPROP_RADIUS = 1;
    public static final int OCCPROP_COLOR = 2;
    public static final int OCCPROP_SEED = 3;
    public static final int OCCPROP_MODELID = 4;
    public static final int OCCPROP_HEIGHT = 5;
    public static final int OCCPROP_OPTIONS = 6;
    public static final int OCCPROP_MAXVEL = 7;
    public static final int OCCPROP_SHAPE = 8;
    public static final int OCCPROP_VISIBILITY = 9;
    public static final int OCCPROP_VIRTUALID = 10;
    public static final int OCCPROP_GROUP_COLOR = 11;
    public static final int OCCPROP_GROUP_TEMPLATE_COLOR = 12;
    public static final int OCCPROP_BEHAVIOR_COLOR = 13;
    public static final int OCCPROP_PROFILE_COLOR = 14;
    public static final int OCCPROP_IS_HUMANOID = 15;
    public static final int OCCPROP_REALISTIC_SHAPE = 16;
    public static final int VIS_HUMAN_NO_H_AVATAR_NO_V_AVATAR = OccVisWriter.getFlags(ViewType.VT_MARKER_DIAMOND, ViewType.VT_MARKER_FLAG, ViewType.VT_SIMPLE_CYL, ViewType.VT_SIMPLE_DISKS, ViewType.VT_SIMPLE_SPHERES);
    public static final int VIS_HUMAN_NO_H_AVATAR_V_AVATAR = -1;
    public static final int VIS_HUMAN_H_AVATAR_NO_V_AVATAR = -1;
    public static final int VIS_HUMAN_H_AVATAR_V_AVATAR = -1;
    public static final int VIS_VEHICLE_NO_H_AVATAR_NO_V_AVATAR = 0;
    public static final int VIS_VEHICLE_NO_H_AVATAR_V_AVATAR = 0;
    public static final int VIS_VEHICLE_H_AVATAR_NO_V_AVATAR = 0;
    public static final int VIS_VEHICLE_H_AVATAR_V_AVATAR = OccVisWriter.getFlags(ViewType.VT_MD5_CASUAL, ViewType.VT_MD5_GENERIC);
    public static final int OPT_CONTROLLED = 1;
    public static final byte STATE_NEEDS_ASSISTANCE = 1;
    public static final Vector3d OCC_ROT_REF = GeomConstants.VEC3D_YNEG;
    private final OccTracker d_occs;
    private final RelationTracker d_relations;
    private final AVisWriter.InterleavedBlockWriter d_agentDataBlockWriter;
    private static final Vector3f s_vec3f0 = new Vector3f();

    private static int getFlags(ViewType ... types) {
        int flags = 0;
        for (ViewType vt : types) {
            flags |= 1 << vt.ordinal();
        }
        return flags;
    }

    public static int getHumanoidFlags(boolean hasAvatar, boolean hasVehicleAvatar) {
        if (hasAvatar && hasVehicleAvatar) {
            return VIS_HUMAN_H_AVATAR_V_AVATAR;
        }
        if (hasAvatar) {
            return VIS_HUMAN_H_AVATAR_NO_V_AVATAR;
        }
        if (hasVehicleAvatar) {
            return VIS_HUMAN_NO_H_AVATAR_V_AVATAR;
        }
        return VIS_HUMAN_NO_H_AVATAR_NO_V_AVATAR;
    }

    public static int getVehicleFlags(boolean hasAvatar, boolean hasVehicleAvatar) {
        if (hasAvatar && hasVehicleAvatar) {
            return VIS_VEHICLE_H_AVATAR_V_AVATAR;
        }
        if (hasAvatar) {
            return VIS_VEHICLE_H_AVATAR_NO_V_AVATAR;
        }
        if (hasVehicleAvatar) {
            return VIS_VEHICLE_NO_H_AVATAR_V_AVATAR;
        }
        return VIS_VEHICLE_NO_H_AVATAR_NO_V_AVATAR;
    }

    public static int getVisFlags(boolean forHuman, boolean hasRealHumanAvatar, boolean hasRealVehicleAvatar) {
        if (forHuman) {
            return OccVisWriter.getHumanoidFlags(hasRealHumanAvatar, hasRealVehicleAvatar);
        }
        return OccVisWriter.getVehicleFlags(hasRealHumanAvatar, hasRealVehicleAvatar);
    }

    public OccVisWriter(String filename, KB kb) throws FileNotFoundException {
        super(filename, 17, 0);
        this.d_occs = new OccTracker(kb);
        this.d_relations = new RelationTracker();
        this.d_agentDataBlockWriter = new AVisWriter.InterleavedBlockWriter(this, 134000);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_agentDataBlockWriter.deserialize();
    }

    @Override
    protected void writeCustomHeaderData(KB kb, DataOutputStream oos) throws IOException {
        this.d_agentDataBlockWriter.init();
    }

    public void writeFrame(KB kb, double t, List<OccAgent> activeAgents) {
        DataOutputStream oos = this.getStream();
        try {
            Set<Relation> relations = OccVisWriter.getRelations(activeAgents);
            ArrayList<OccAgent> added = new ArrayList<OccAgent>();
            ArrayList<OccAgent> removed = new ArrayList<OccAgent>();
            ArrayList<OccAgent> changed = new ArrayList<OccAgent>();
            ArrayList<Relation> addedRelations = new ArrayList<Relation>();
            ArrayList<Relation> removedRelations = new ArrayList<Relation>();
            this.d_occs.beginUpdate(activeAgents, added, removed, changed);
            this.d_relations.beginUpdate(relations, addedRelations, removedRelations);
            this.writeAgentData(t, added, removed, changed, addedRelations, removedRelations);
            long frameix = this.getPos();
            OccVisWriter.writeAgentUpdate(oos, this.d_occs, this.d_occs.getObjs());
            this.writeFrameIx(t, frameix);
            this.d_occs.endUpdate((Collection<? extends OccAgent>)removed);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeAgentData(double time, List<OccAgent> added, List<OccAgent> removed, List<OccAgent> changed, List<Relation> addedRelations, List<Relation> removedRelations) throws IOException {
        if (added.isEmpty() && removed.isEmpty() && changed.isEmpty()) {
            return;
        }
        this.d_agentDataBlockWriter.beginWrite();
        DataOutputStream oos = new DataOutputStream(this.d_agentDataBlockWriter);
        long statusPos = this.d_agentDataBlockWriter.getPos();
        oos.writeByte(0);
        oos.writeFloat((float)time);
        OccVisWriter.writeAgentsAdded(oos, this.d_occs, added);
        OccVisWriter.writeAgentsRemoved(oos, this.d_occs, removed);
        OccVisWriter.writeAgentsChanged(oos, this.d_occs, changed);
        OccVisWriter.writeRelationsAdded(oos, addedRelations);
        OccVisWriter.writeRelationsRemoved(oos, removedRelations);
        long curPos = this.d_agentDataBlockWriter.getPos();
        this.d_agentDataBlockWriter.setPos(statusPos);
        oos.writeByte(1);
        this.d_agentDataBlockWriter.setPos(curPos);
        this.d_agentDataBlockWriter.endWrite();
    }

    private static void writePoint(DataOutput os, Point3d p) throws IOException {
        os.writeFloat((float)p.x);
        os.writeFloat((float)p.y);
        os.writeFloat((float)p.z);
    }

    public static void writeShape(DataOutput os, OccTracker.ITrackerShape shape) throws IOException {
        String name = "";
        OccVisWriter.writeString(os, name);
        if (shape instanceof OccTracker.CylShape) {
            os.writeInt(ShapeType.CYL.ordinal());
            OccTracker.CylShape cyl = (OccTracker.CylShape)shape;
            os.writeFloat((float)cyl.radius);
            os.writeFloat((float)cyl.height);
        } else if (shape instanceof OccTracker.IPolyShape) {
            os.writeInt(ShapeType.POLY.ordinal());
            OccTracker.IPolyShape poly = (OccTracker.IPolyShape)shape;
            os.writeFloat((float)poly.getHeight());
            Point3d[] points = poly.getPoints();
            os.writeInt(points.length);
            for (Point3d p : points) {
                os.writeFloat((float)p.x);
                os.writeFloat((float)p.y);
            }
        } else if (shape instanceof OccTracker.RealisticShape) {
            os.writeInt(ShapeType.REALISTIC.ordinal());
            OccTracker.RealisticShape rshape = (OccTracker.RealisticShape)shape;
            OccVisWriter.writeString(os, rshape.model);
            OccVisWriter.writePoint(os, rshape.offset);
            os.writeBoolean(rshape.isHuman);
        } else assert (false);
    }

    private static void writeShapes(DataOutput os, OccTracker tracker, Collection<? extends OccTracker.ITrackerShape> shapes) throws IOException {
        os.writeInt(shapes.size());
        for (OccTracker.ITrackerShape iTrackerShape : shapes) {
            OccVisWriter.writeShape(os, iTrackerShape);
        }
    }

    private static void writeString(DataOutput os, String str) throws IOException {
        if (os instanceof INativeStream) {
            ((INativeStream)os).writeString(str);
        } else {
            os.writeChars(str);
            os.writeChar(0);
        }
    }

    private static int getNumVehicles(Collection<? extends OccAgent> agents) {
        return theUtil.filter(agents, a -> OccTracker.getVehicleBody(a) != null).size();
    }

    private static VehicleBody getVehicle(OccAgent agent) {
        return OccTracker.getVehicleBody(agent);
    }

    private static int getNumOccIds(Collection<? extends OccAgent> agents) {
        int count = agents.size();
        return count += OccVisWriter.getNumVehicles(agents);
    }

    private static void writeAddedShapes(DataOutputStream oos, OccTracker tracker, Collection<? extends OccAgent> occs, boolean writeNewShapesOnly) throws IOException {
        Collection<OccTracker.ITrackerShape> newShapes = tracker.getShapes(occs, writeNewShapesOnly);
        OccVisWriter.writeShapes(oos, tracker, newShapes);
    }

    public static void writeAgentsAdded(DataOutputStream oos, OccTracker tracker, Collection<? extends OccAgent> added) throws IOException {
        OccVisWriter.writeAgentsAdded(oos, tracker, added, true);
    }

    public static void writeAgentsAdded(DataOutputStream oos, OccTracker tracker, Collection<? extends OccAgent> added, boolean writeNewShapesOnly) throws IOException {
        OccVisWriter.writeAddedShapes(oos, tracker, added, writeNewShapesOnly);
        oos.writeInt(OccVisWriter.getNumOccIds(added));
        for (OccAgent occAgent : added) {
            OccVisWriter.writeAgentDesc(oos, occAgent, tracker, false);
            PolygonShape vehicleShape = tracker.recordVehicleShape(occAgent);
            if (vehicleShape == null) continue;
            tracker.createVehicleId(occAgent);
            OccVisWriter.writeAgentDesc(oos, occAgent, tracker, true);
        }
    }

    public static void writeAgentsChanged(DataOutputStream oos, OccTracker tracker, Collection<? extends OccAgent> changed) throws IOException {
        ArrayList<OccAgent> removedVehicles = new ArrayList<OccAgent>();
        ArrayList<OccAgent> addedVehicles = new ArrayList<OccAgent>();
        for (OccAgent occAgent : changed) {
            PolygonShape prevShape;
            PolygonShape currShape = OccTracker.getVehicleShape(occAgent);
            if (currShape == (prevShape = tracker.getRecordedVehicleShape(occAgent))) continue;
            if (prevShape != null) {
                removedVehicles.add(occAgent);
            }
            if (currShape != null) {
                addedVehicles.add(occAgent);
            }
            tracker.recordVehicleShape(occAgent);
        }
        oos.writeInt(removedVehicles.size());
        for (OccAgent occAgent : removedVehicles) {
            Integer vehicleId = tracker.removeVehicleId(occAgent);
            assert (vehicleId != null);
            oos.writeInt(vehicleId);
        }
        OccVisWriter.writeAddedShapes(oos, tracker, changed, true);
        oos.writeInt(addedVehicles.size());
        for (OccAgent occAgent : addedVehicles) {
            VehicleBody vehicle = OccVisWriter.getVehicle(occAgent);
            assert (vehicle != null);
            tracker.createVehicleId(occAgent);
            OccVisWriter.writeAgentDesc(oos, occAgent, tracker, true);
        }
    }

    private static void writeColor(DataOutputStream oos, int key, Point3f c) throws IOException {
        if (c != null) {
            oos.writeInt(key);
            oos.writeFloat(c.x);
            oos.writeFloat(c.y);
            oos.writeFloat(c.z);
        }
    }

    private static void writeColor(DataOutputStream oos, int key, Color3b c) throws IOException {
        if (c != null) {
            oos.writeInt(key);
            oos.writeFloat(theUtil.toCCf(c.x));
            oos.writeFloat(theUtil.toCCf(c.y));
            oos.writeFloat(theUtil.toCCf(c.z));
        }
    }

    private static void writeColor(DataOutputStream oos, int key, Color c) throws IOException {
        if (c != null) {
            oos.writeInt(key);
            oos.writeFloat(theUtil.toCCf((byte)c.getRed()));
            oos.writeFloat(theUtil.toCCf((byte)c.getGreen()));
            oos.writeFloat(theUtil.toCCf((byte)c.getBlue()));
        }
    }

    protected static void writeAgentDesc(DataOutputStream oos, OccAgent agent, OccTracker tracker, boolean vehicle) throws IOException {
        boolean groupColor;
        Occupant occ = agent.getOcc();
        VehicleBody vehicleBody = OccVisWriter.getVehicle(agent);
        int id = vehicle ? tracker.getVehicleId(agent) : occ.id;
        oos.writeInt(id);
        OccVisWriter.writeString(oos, occ.name);
        Pair<OccTracker.ITrackerShape, Boolean> collShape = OccTracker.getTrackerShape(agent, vehicle, false);
        Pair<OccTracker.ITrackerShape, Boolean> realShape = OccTracker.getTrackerShape(agent, vehicle, true);
        oos.writeInt(15);
        oos.writeBoolean(vehicle ? false : (Boolean)realShape.v2);
        OccVisWriter.writeColor(oos, 2, occ.visColor);
        boolean bl = groupColor = occ.occupantGroup != null;
        if (groupColor) {
            OccVisWriter.writeColor(oos, 11, occ.occupantGroup.color);
        }
        if (occ.occupantGroup != null && occ.occupantGroup.templateColor != null) {
            OccVisWriter.writeColor(oos, 12, occ.occupantGroup.templateColor);
        }
        OccVisWriter.writeColor(oos, 13, OccVisWriter.getCurrentBehavior((Occupant)occ).color);
        OccVisWriter.writeColor(oos, 14, occ.parentProfile.getProperty(OccProfileSim.PROP_COLOR));
        oos.writeInt(3);
        oos.writeLong(occ.rseed);
        assert (collShape.v1 != null);
        oos.writeInt(8);
        oos.writeInt(tracker.getShapeId((OccTracker.ITrackerShape)collShape.v1));
        if (realShape.v1 != null) {
            oos.writeInt(16);
            oos.writeInt(tracker.getShapeId((OccTracker.ITrackerShape)realShape.v1));
        }
        oos.writeInt(7);
        oos.writeFloat(agent.getOcc().maxVel);
        int options = 0;
        if (OccVisWriter.isControlled(agent)) {
            options |= 1;
        }
        if (options != 0) {
            oos.writeInt(6);
            oos.writeInt(options);
        }
        oos.writeInt(9);
        oos.writeInt(OccVisWriter.getVisFlags(vehicle, agent, vehicleBody));
        if (vehicle) {
            oos.writeInt(10);
            oos.writeInt(occ.id);
        }
        oos.writeInt(0);
    }

    private static int getVisFlags(boolean forVehicle, OccAgent agent, VehicleBody vehicleBody) {
        boolean hasAvatar = agent.getOcc().avatar != null;
        boolean hasVehicleAvatar = vehicleBody != null && vehicleBody.avatar != null;
        return OccVisWriter.getVisFlags(!forVehicle, hasAvatar, hasVehicleAvatar);
    }

    public static void writeAgentsRemoved(DataOutputStream oos, OccTracker tracker, Collection<? extends OccAgent> removed) throws IOException {
        oos.writeInt(OccVisWriter.getNumOccIds(removed));
        for (OccAgent occAgent : removed) {
            Occupant occ = occAgent.getOcc();
            oos.writeInt(occ.id);
            Integer vehicleId = tracker.getVehicleId(occAgent);
            assert (vehicleId == null == (OccVisWriter.getVehicle(occAgent) == null));
            if (vehicleId == null) continue;
            oos.writeInt(vehicleId);
        }
    }

    public static void writeRelationsAdded(DataOutputStream oos, Collection<? extends Relation> added) throws IOException {
        oos.writeInt(added.size());
        for (Relation relation : added) {
            oos.writeByte(relation.type);
            oos.writeInt(relation.occ1.getId());
            oos.writeInt(relation.occ2.getId());
        }
    }

    public static void writeRelationsRemoved(DataOutputStream oos, Collection<? extends Relation> removed) throws IOException {
        oos.writeInt(removed.size());
        for (Relation relation : removed) {
            oos.writeByte(relation.type);
            oos.writeInt(relation.occ1.getId());
            oos.writeInt(relation.occ2.getId());
        }
    }

    private static boolean isControlled(OccAgent agent) {
        for (IGoal goal : agent.getOcc().behavior) {
            if (!(goal instanceof ControlledOccGoal)) continue;
            return true;
        }
        return false;
    }

    public static void writeAgentUpdate(DataOutputStream oos, OccTracker tracker, Collection<? extends OccAgent> agents) throws IOException {
        oos.writeInt(OccVisWriter.getNumOccIds(agents));
        for (OccAgent occAgent : agents) {
            OccVisWriter.writeAgentFrame(oos, tracker, occAgent, false);
            if (OccVisWriter.getVehicle(occAgent) == null) continue;
            OccVisWriter.writeAgentFrame(oos, tracker, occAgent, true);
        }
    }

    private static float calcSpeed(OccAgent agent, boolean vehicle) {
        OccAnim anim;
        Occupant occ = agent.getOcc();
        OccAnim occAnim = anim = vehicle && agent.hasVehicle() ? agent.getVehicle().getAnim() : occ.anim;
        if (anim.isIdle()) {
            return 0.0f;
        }
        float speed = anim == OccAnim.MOVEFLAT ? (float)Math.sqrt(occ.vel.x * occ.vel.x + occ.vel.y * occ.vel.y) : (float)occ.vel.length();
        if (speed >= occ.terrainSpeed) {
            return speed - occ.terrainSpeed;
        }
        return 0.0f;
    }

    private static void write(DataOutputStream oos, Tuple3f t) throws IOException {
        oos.writeFloat(t.x);
        oos.writeFloat(t.y);
        oos.writeFloat(t.z);
    }

    private static void write(DataOutputStream oos, float x, float y, float z) throws IOException {
        oos.writeFloat(x);
        oos.writeFloat(y);
        oos.writeFloat(z);
    }

    private static void writef(DataOutputStream oos, Tuple3d dir) throws IOException {
        oos.writeFloat((float)dir.x);
        oos.writeFloat((float)dir.y);
        oos.writeFloat((float)dir.z);
    }

    private static void writef(DataOutputStream oos, Quat4d dir) throws IOException {
        oos.writeFloat((float)dir.x);
        oos.writeFloat((float)dir.y);
        oos.writeFloat((float)dir.z);
        oos.writeFloat((float)dir.w);
    }

    public static Quat4d convertRotation(Vector3d dir, Vector3d ref) {
        if (theUtil.eq0(dir.lengthSquared(), 1.0E-12)) {
            dir = ref;
        } else {
            dir = new Vector3d(dir);
            dir.z = 0.0;
            double ilen = 1.0 / Math.sqrt(dir.x * dir.x + dir.y * dir.y);
            dir.x *= ilen;
            dir.y *= ilen;
        }
        return Util3D.shortestArcN(ref, dir, GeomConstants.VEC3D_ZPOS, 1.0E-5);
    }

    private static void writeColorB(DataOutputStream oos, Object c) throws IOException {
        if (c instanceof Color3b) {
            Color3b c3b = (Color3b)c;
            oos.writeByte(c3b.x);
            oos.writeByte(c3b.y);
            oos.writeByte(c3b.z);
        } else if (c instanceof Point3f) {
            Point3f c3b = (Point3f)c;
            oos.writeByte(theUtil.toCCb(c3b.x));
            oos.writeByte(theUtil.toCCb(c3b.y));
            oos.writeByte(theUtil.toCCb(c3b.z));
        } else if (c instanceof Color) {
            Color c3b = (Color)c;
            oos.writeByte(c3b.getRed());
            oos.writeByte(c3b.getGreen());
            oos.writeByte(c3b.getBlue());
        }
    }

    private static void writeColorB(DataOutputStream oos, Object c, Color3b backupColor) throws IOException {
        if (c == null) {
            assert (backupColor != null);
            OccVisWriter.writeColorB(oos, backupColor);
            return;
        }
        OccVisWriter.writeColorB(oos, c);
    }

    protected static void writeAgentFrame(DataOutputStream oos, OccTracker tracker, OccAgent agent, boolean vehicle) throws IOException {
        Occupant occ = agent.getOcc();
        int id = vehicle ? tracker.getVehicleId(agent) : occ.id;
        oos.writeInt(id);
        Point3d loc = occ.getDisplayLoc();
        OccVisWriter.writef(oos, loc);
        Vector3d dir = new Vector3d(occ.displayOrient);
        if (dir.length() > 0.01) {
            dir.normalize();
        }
        Quat4d orient = OccVisWriter.convertRotation(dir, OCC_ROT_REF);
        OccVisWriter.writef(oos, orient);
        oos.writeFloat(occ.terrainSpeed);
        oos.writeFloat(OccVisWriter.calcSpeed(agent, vehicle));
        OccAnim anim = occ.anim;
        VehicleBody vehicleBody = OccVisWriter.getVehicle(agent);
        oos.writeByte((byte)anim.ordinal());
        int status = 0;
        if (agent.isAwaitingAssistance()) {
            status = (byte)(status | 1);
        }
        oos.writeByte(status);
        OccVisWriter.writeColorB(oos, occ.occupantGroup != null ? occ.occupantGroup.color : occ.visColor, occ.visColor);
        OccVisWriter.writeColorB(oos, occ.occupantGroup != null ? occ.occupantGroup.templateColor : occ.visColor, occ.visColor);
        OccVisWriter.writeColorB(oos, OccVisWriter.getCurrentBehavior((Occupant)occ).color, occ.visColor);
        OccVisWriter.writeColorB(oos, occ.parentProfile.getProperty(OccProfileSim.PROP_COLOR), occ.visColor);
        OccVisWriter.writeColorB(oos, occ.visColor, occ.visColor);
        Pair<OccTracker.ITrackerShape, Boolean> collShape = OccTracker.getTrackerShape(agent, vehicle, false);
        Pair<OccTracker.ITrackerShape, Boolean> realShape = OccTracker.getTrackerShape(agent, vehicle, true);
        oos.writeBoolean(vehicle ? false : (Boolean)realShape.v2);
        oos.writeInt(tracker.getShapeId((OccTracker.ITrackerShape)collShape.v1));
        oos.writeInt(tracker.getShapeId((OccTracker.ITrackerShape)realShape.v1));
        oos.writeShort((short)OccVisWriter.getVisFlags(vehicle, agent, vehicleBody));
        oos.writeFloat(occ.socialDist);
    }

    private static BehaviorSim getCurrentBehavior(Occupant occ) {
        return !occ.behaviorStack.isEmpty() ? occ.behaviorStack.peek().behavior : occ.behavior;
    }

    public static Set<Relation> getRelations(Collection<OccAgent> agents) {
        LinkedHashSet<Relation> relations = new LinkedHashSet<Relation>();
        for (OccAgent agent : agents) {
            for (IRelation rel : agent.getRelations()) {
                IRelation ab;
                if (rel instanceof IRelation.AssistedBy) {
                    ab = (IRelation.AssistedBy)rel;
                    relations.add(new Relation(0, ab.agentHelping, agent));
                    continue;
                }
                if (!(rel instanceof IRelation.Assisting)) continue;
                ab = (IRelation.Assisting)rel;
                relations.add(new Relation(0, agent, ((IRelation.Assisting)ab).agentBeingHelped));
            }
        }
        return relations;
    }

    public static class RelationTracker
    extends ObjectTracker<Relation> {
        public RelationTracker() {
            super(false);
        }
    }

    public static class Relation
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final byte OCCRELATION_ASSISTING = 0;
        public byte type;
        public OccAgent occ1;
        public OccAgent occ2;

        public Relation(byte type, OccAgent occ1, OccAgent occ2) {
            this.type = type;
            this.occ1 = occ1;
            this.occ2 = occ2;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Relation && ((Relation)obj).type == this.type && ((Relation)obj).occ1 == this.occ1 && ((Relation)obj).occ2 == this.occ2;
        }

        public int hashCode() {
            return 153239546 + this.type + System.identityHashCode(this.occ1) + System.identityHashCode(this.occ2);
        }
    }

    private static enum ShapeType {
        POLY,
        CYL,
        REALISTIC;

    }

    public static enum ViewType {
        VT_MD5_GENERIC,
        VT_MD5_CASUAL,
        VT_SIMPLE_DISKS,
        VT_SIMPLE_SPHERES,
        VT_SIMPLE_CYL,
        VT_MARKER_DIAMOND,
        VT_MARKER_FLAG;

    }
}

