/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.ANode;
import inferno.sim.BehaviorSim;
import inferno.sim.IOccGroup;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccGroup;
import inferno.sim.OccProfileSim;
import inferno.sim.SizeConstrainedKMeans;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import org.jscience.physics.units.Unit;
import thunderheadeng.legacy.v1.util.LinkedIdentityHashMap;
import thunderheadeng.util.stat.ICurve;

public class OccGroupType
implements IOccGroup,
Serializable {
    static final long serialVersionUID = 1L;
    private final int groupTypeID;
    public final String groupTypeName;
    public BehaviorSim behavior;
    public final double maxDistance;
    public final double slowdownTime;
    public final boolean requiresLeader;
    public final boolean respectSocialDist;
    public final ICurve minNumberOfMembers;
    public final ICurve prefNumberOfMembers;
    public final boolean allowSmallerGroups;
    private List<OccAgent> newDynamicMembers = new ArrayList<OccAgent>();
    private Random rnd;
    public final boolean useExactDistCalc;
    public final double heightMultiplier;
    public final boolean restrictRoom;
    public final Map<OccProfileSim, GroupCreationData> profileMap;
    private final boolean useProfileDist;
    public final OccProfileSim leaderProfile;
    private Integer oldMembersHash = null;
    private OpenGroups openGroups;
    private Color color;
    public final boolean isNoGroupType;

    public OccGroupType(int groupTypeID, String groupTypeName, double maxDistance, double slowdownTime, boolean requiresLeader, ICurve minNumberOfMembers, ICurve prefNumberOfMembers, boolean allowSmallerGroups, boolean useExactCalc, double heightMultiplier, boolean specifyProfileDist, Map<OccProfileSim, GroupCreationData> profileMap, OccProfileSim leaderProfile, boolean restrictRoom, Color color, boolean isNoGroupType, boolean respectSocialDist) {
        this.groupTypeID = groupTypeID;
        this.groupTypeName = groupTypeName;
        this.maxDistance = maxDistance;
        this.slowdownTime = slowdownTime;
        this.requiresLeader = requiresLeader;
        this.minNumberOfMembers = minNumberOfMembers;
        this.prefNumberOfMembers = prefNumberOfMembers;
        this.allowSmallerGroups = allowSmallerGroups;
        this.useExactDistCalc = useExactCalc;
        this.heightMultiplier = heightMultiplier;
        this.useProfileDist = specifyProfileDist;
        this.profileMap = profileMap;
        this.leaderProfile = leaderProfile;
        this.restrictRoom = restrictRoom;
        this.openGroups = new OpenGroups(restrictRoom);
        this.rnd = new Random();
        this.rnd.setSeed(1L);
        this.color = color;
        this.isNoGroupType = isNoGroupType;
        this.respectSocialDist = respectSocialDist;
    }

    @Override
    public void update(KB kb) {
        if (this.isNoGroupType) {
            return;
        }
        this.cluster(kb);
    }

    @Override
    public synchronized void joinDynamically(OccAgent agent) {
        this.newDynamicMembers.add(agent);
    }

    private void cluster(KB kb) {
        this.newDynamicMembers.sort((a1, a2) -> (int)Math.signum(a1.getOcc().priority - a2.getOcc().priority));
        LinkedList<OccAgent> newMembers = new LinkedList<OccAgent>(this.newDynamicMembers);
        this.openGroups.update();
        LinkedHashMap<ANode, LinkedList<OccAgent>> roomMap = new LinkedHashMap<ANode, LinkedList<OccAgent>>();
        if (this.restrictRoom) {
            for (OccAgent a : newMembers) {
                roomMap.compute(a.getOcc().curNode, (k, v) -> {
                    LinkedList list = v == null ? new LinkedList() : v;
                    list.add(a);
                    return list;
                });
            }
        }
        if (!this.restrictRoom) {
            this.assignToOpenGroups(newMembers, null);
        } else {
            this.assignToOpenGroups(roomMap);
        }
        int newMembersHash = newMembers.hashCode();
        if (this.oldMembersHash == null || this.oldMembersHash != newMembersHash) {
            this.oldMembersHash = newMembersHash;
            this.newDynamicMembers.clear();
            if (!this.restrictRoom) {
                this.clusterKMeans(kb, newMembers);
            } else {
                for (ANode room : roomMap.keySet()) {
                    this.clusterKMeans(kb, (List)roomMap.get(room));
                }
            }
        }
    }

    private void assignToOpenGroups(Map<ANode, LinkedList<OccAgent>> roomMap) {
        for (ANode room : roomMap.keySet()) {
            this.assignToOpenGroups(roomMap.get(room), room);
        }
    }

    private void assignToOpenGroups(LinkedList<OccAgent> newMembers, ANode room) {
        Iterator<OccGroup> it = this.openGroups.getIterator(room);
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            OccGroup openGroup = it.next();
            ArrayList<OccAgent> addBack = new ArrayList<OccAgent>();
            while (!openGroup.isReady() && !newMembers.isEmpty()) {
                OccAgent member = newMembers.poll();
                if (openGroup.canJoin(member)) {
                    member.getOcc().occupantGroup = openGroup;
                    openGroup.joinInstantly(member);
                    if (openGroup.leaderProfile == null || openGroup.hasLeader() || openGroup.leaderProfile != member.getOcc().parentProfile) continue;
                    member.getOcc().isGroupLeader = true;
                    openGroup.setLeader(member);
                    continue;
                }
                addBack.add(member);
            }
            newMembers.addAll(addBack);
        }
    }

    private void clusterKMeans(KB kb, List<OccAgent> newMembers) {
        if (newMembers.isEmpty()) {
            return;
        }
        SizeConstrainedKMeans kmeans = new SizeConstrainedKMeans(kb, newMembers, this.minNumberOfMembers, this.prefNumberOfMembers, this.allowSmallerGroups, this.useExactDistCalc, this.heightMultiplier, this.rnd, this.useProfileDist, this.profileMap);
        SizeConstrainedKMeans.ClusteringResult result = kmeans.cluster();
        Set<SizeConstrainedKMeans.Cluster> clusters = result.clusters;
        this.newDynamicMembers.addAll(result.unClusteredOccs);
        LinkedHashSet<OccGroup> newGroups = new LinkedHashSet<OccGroup>();
        int groupID = kb.getOccupantGroups().size();
        for (SizeConstrainedKMeans.Cluster c : clusters) {
            OccGroup newGroup = this.createGroup(c, kb, groupID++);
            if (!newGroup.isReady()) {
                this.openGroups.add(newGroup);
            }
            newGroups.add(newGroup);
        }
        kb.addOccupantGroups(newGroups);
    }

    private OccGroup createGroup(SizeConstrainedKMeans.Cluster c, KB kb, int groupID) {
        OccAgent leader;
        List<OccAgent> groupMembers = c.getMembers();
        LinkedHashMap<OccProfileSim, Integer> minSizes = null;
        LinkedHashMap<OccProfileSim, Integer> prefSizes = null;
        Integer minSize = null;
        if (!this.useProfileDist) {
            minSize = this.allowSmallerGroups ? c.getMinSize() : c.getPrefSize();
        } else {
            minSizes = new LinkedHashMap<OccProfileSim, Integer>();
            prefSizes = new LinkedHashMap<OccProfileSim, Integer>();
            for (OccProfileSim prof : c.profileMap.keySet()) {
                SizeConstrainedKMeans.ClusterProfileData clusterProfileData = c.profileMap.get(prof);
                int min = clusterProfileData.allowSmallerGroups ? clusterProfileData.minNumberOfMembers : clusterProfileData.prefNumberOfMembers;
                minSizes.put(prof, min);
                prefSizes.put(prof, clusterProfileData.prefNumberOfMembers);
            }
        }
        Color color = new Color(this.rnd.nextInt(256), this.rnd.nextInt(256), this.rnd.nextInt(256));
        OccGroup group = new OccGroup(groupID, "", this.maxDistance, this.slowdownTime, this.requiresLeader, this.respectSocialDist, minSize, minSizes, prefSizes, this.leaderProfile, color, this.color);
        group.type = this;
        if (this.requiresLeader && (leader = this.findLeader(groupMembers, kb)) != null) {
            leader.getOcc().isGroupLeader = true;
            group.setLeader(leader);
        }
        for (OccAgent member : groupMembers) {
            member.getOcc().occupantGroup = group;
            group.joinDynamically(member);
        }
        group.update(kb);
        return group;
    }

    public OccGroup createEmptyGroup(KB kb) {
        OccGroup group;
        Color color = new Color(this.rnd.nextInt(256), this.rnd.nextInt(256), this.rnd.nextInt(256));
        if (this.useProfileDist) {
            int numMembers = 0;
            LinkedIdentityHashMap<OccProfileSim, Integer> profCountMap = new LinkedIdentityHashMap<OccProfileSim, Integer>();
            for (OccProfileSim prof : this.profileMap.keySet()) {
                GroupCreationData data = this.profileMap.get(prof);
                int profMemberCount = (int)Math.round(data.prefNumberOfMembers.getValue(this.rnd).getValue(Unit.ONE));
                if (profMemberCount <= 0) continue;
                numMembers += profMemberCount;
                profCountMap.put(prof, profMemberCount);
            }
            group = new OccGroup(kb.getOccupantGroups().size(), "", this.maxDistance, this.slowdownTime, this.requiresLeader, this.respectSocialDist, numMembers, profCountMap, profCountMap, this.leaderProfile, color, this.color);
        } else {
            int prefMemberCount = (int)Math.round(this.prefNumberOfMembers.getValue(this.rnd).getValue(Unit.ONE));
            group = new OccGroup(kb.getOccupantGroups().size(), "", this.maxDistance, this.slowdownTime, this.requiresLeader, this.respectSocialDist, color, this.color);
            group.setMinSize(prefMemberCount);
        }
        group.type = this;
        kb.addOccupantGroups(Collections.singleton(group));
        return group;
    }

    private OccAgent findLeader(List<OccAgent> groupMembers, KB kb) {
        OccAgent leader = null;
        double maxPrior = -1.7976931348623157E308;
        for (OccAgent a : groupMembers) {
            if (!(a.getPriority(kb) > maxPrior) || this.leaderProfile != null && a.getOcc().parentProfile != this.leaderProfile) continue;
            leader = a;
        }
        return leader;
    }

    @Override
    public int getID() {
        return this.groupTypeID;
    }

    @Override
    public boolean requiresLeader() {
        return this.requiresLeader;
    }

    @Override
    public boolean respectSocialDist() {
        return this.respectSocialDist;
    }

    @Override
    public BehaviorSim getBehavior() {
        return this.behavior;
    }

    @Override
    public double getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public double getCurrentMaxDist() {
        return this.maxDistance;
    }

    @Override
    public double getSlowdownTime() {
        return this.slowdownTime;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public static class OpenGroups
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final Set<OccGroup> openGroups;
        public final LinkedHashMap<ANode, Set<OccGroup>> openGroupsMap;
        private final boolean restrictRoom;

        public OpenGroups(boolean restrictRoom) {
            this.restrictRoom = restrictRoom;
            if (!restrictRoom) {
                this.openGroups = new LinkedHashSet<OccGroup>();
                this.openGroupsMap = null;
            } else {
                this.openGroups = null;
                this.openGroupsMap = new LinkedHashMap();
            }
        }

        public void add(OccGroup newGroup) {
            if (!this.restrictRoom) {
                this.openGroups.add(newGroup);
            } else {
                ANode room = newGroup.getMembers().iterator().next().getOcc().curNode;
                this.openGroupsMap.compute(room, (k, v) -> {
                    Set set = v != null ? v : new LinkedHashSet();
                    set.add(newGroup);
                    return set;
                });
            }
        }

        private void update() {
            Consumer<Set> updateGroups = groups -> {
                ArrayList<OccGroup> toRemove = new ArrayList<OccGroup>();
                for (OccGroup openGroup : groups) {
                    if (!openGroup.isReady()) continue;
                    toRemove.add(openGroup);
                }
                groups.removeAll(toRemove);
            };
            if (!this.restrictRoom) {
                updateGroups.accept(this.openGroups);
            } else {
                for (ANode room : this.openGroupsMap.keySet()) {
                    updateGroups.accept(this.openGroupsMap.get(room));
                }
            }
        }

        public Iterator<OccGroup> getIterator(ANode room) {
            if (room == null) {
                return this.openGroups.iterator();
            }
            if (this.openGroupsMap.containsKey(room)) {
                return this.openGroupsMap.get(room).iterator();
            }
            return null;
        }
    }

    public static class GroupCreationData
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final ICurve prefNumberOfMembers;
        public final boolean allowSmallerGroups;
        public final ICurve minNumberOfMembers;

        public GroupCreationData(ICurve prefNumberOfMembers, boolean allowSmallerGroups, ICurve minNumberOfMembers) {
            this.prefNumberOfMembers = prefNumberOfMembers;
            this.allowSmallerGroups = allowSmallerGroups;
            this.minNumberOfMembers = minNumberOfMembers;
        }
    }
}

