/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.ANode;
import inferno.data2.Blockage;
import inferno.data2.DoorDir;
import inferno.data2.ITimeEstimate;
import inferno.data2.OccAnim;
import inferno.data2.Occupant;
import inferno.data2.SpeedModifier;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.geom.SeekCurve;
import inferno.sim.DoorQueue;
import inferno.sim.Engine;
import inferno.sim.IRelation;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Param;
import inferno.sim.TsvOutput;
import inferno.sim.ai.IAiCore;
import inferno.sim.steering.Steer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Pair;

public interface EngineOp
extends Serializable {
    public void run(Engine var1);

    public static class DumpAgentsTsv
    implements EngineOp {
        private String q(String str) {
            return "\"" + str + "\"";
        }

        @Override
        public void run(Engine e) {
            ArrayList<Pair<String, Function<Occupant, Object>>> cols = new ArrayList<Pair<String, Function<Occupant, Object>>>();
            cols.add(new Pair<String, Function<Occupant, Object>>("simid", occ -> this.q(engine.getKB().getParams().input)));
            cols.add(new Pair<String, Function<Occupant, Object>>("id", occ -> String.format("%d", occ.id)));
            cols.add(new Pair<String, Function<Occupant, Object>>("name", occ -> this.q(occ.name)));
            cols.add(new Pair<String, Function<Occupant, Object>>("profile", occ -> this.q(occ.parentProfile.getName())));
            cols.add(new Pair<String, Function<Occupant, Object>>("behavior", occ -> this.q(occ.behavior.name)));
            cols.add(new Pair<String, Function<Occupant, Object>>("maxVel", occ -> String.format("%.2f", Float.valueOf(occ.maxVel))));
            cols.add(new Pair<String, Function<Occupant, Object>>("occupantRadius", occ -> String.format("%.2f", occ.bodyShape.getOccRadius())));
            cols.add(new Pair<String, Function<Occupant, Object>>("geometryRadius", occ -> String.format("%.2f", occ.bodyShape.getGeomRadius())));
            cols.add(new Pair<String, Function<Occupant, Object>>("height", occ -> String.format("%.2f", occ.bodyShape.getHeight())));
            cols.add(new Pair<String, Function<Occupant, Object>>("room", occ -> this.q(occ.curNode.name)));
            cols.add(new Pair<String, Function<Occupant, Object>>("x", occ -> String.format("%.2f", occ.loc.x)));
            cols.add(new Pair<String, Function<Occupant, Object>>("y", occ -> String.format("%.2f", occ.loc.y)));
            cols.add(new Pair<String, Function<Occupant, Object>>("z", occ -> String.format("%.2f", occ.loc.z)));
            TsvOutput tsv = new TsvOutput();
            tsv.addRow((String[])cols.stream().map(pair -> (String)pair.v1).toArray(String[]::new));
            for (Occupant occ2 : e.getKB().getOccs()) {
                tsv.addRow((String[])cols.stream().map(pair -> ((Function)pair.v2).apply(occ2)).toArray(String[]::new));
            }
            String dest = System.getProperty("ex_print_occupant_params");
            if ("".equals(dest)) {
                System.out.println("ex_print_occupant_params enabled, printing to console");
                System.out.println(tsv.toString());
            } else {
                File f = new File(e.getKB().getParams().dir, dest);
                System.out.println("ex_print_occupant_params enabled, printing to " + this.q(f.getPath()));
                try (PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));){
                    String data = tsv.toString();
                    data = data.trim();
                    if (f.length() == 0L) {
                        pw.println(data);
                    } else {
                        String[] lines = data.split("\n");
                        for (int i = 1; i < lines.length; ++i) {
                            pw.println(lines[i]);
                        }
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static class Leave
    implements EngineOp {
        public final OccAgent occ;
        public final ANode door;

        public Leave(OccAgent occ, ANode door) {
            this.occ = occ;
            this.door = door;
        }

        @Override
        public void run(Engine e) {
            this.occ.setUpdator(new LeaveViaDoorUpdator(this.door));
        }
    }

    public static class LeaveViaDoorUpdator
    implements OccAgent.IUpdator,
    Serializable {
        static final long serialVersionUID = 1L;
        private final ANode d_door;

        public LeaveViaDoorUpdator(ANode door) {
            this.d_door = door;
        }

        @Override
        public OccAgent.UpdatePacket calcUpdate(KB kb, Param p, double dt, OccAgent agent, Steer steer, SeekCurve seekCurve) {
            OccAgent.UpdatePacket packet = new OccAgent.UpdatePacket(agent.getOcc());
            packet.anim = OccAnim.STANDIDLE;
            packet.steer = steer;
            packet.seek = seekCurve;
            DoorQueue queue = this.d_door.doorQueue;
            DoorDir dir = queue.getDir(null);
            packet.crossedDoors.add(new Pair<ANode, DoorDir>(this.d_door, dir));
            return packet;
        }
    }

    public static class PauseEngine
    implements EngineOp {
        @Override
        public void run(Engine e) {
            if (!e.isPaused()) {
                e.pause();
            }
        }
    }

    public static class SetForceIdle
    implements EngineOp {
        public final boolean d_flag;

        public SetForceIdle(boolean flag) {
            this.d_flag = flag;
        }

        @Override
        public void run(Engine e) {
            e.getKB().setForceIdle(this.d_flag);
        }
    }

    public static class SetSpeedModifier
    implements EngineOp {
        public final List<Tri> tris;
        public final SpeedModifier modifier;

        public SetSpeedModifier(List<Tri> tris, SpeedModifier modifier) {
            this.tris = tris;
            this.modifier = modifier;
        }

        @Override
        public void run(Engine e) {
            boolean modified = false;
            for (Tri tri : this.tris) {
                modified = modified || !tri.getSpeedModifier().equals(this.modifier);
                tri.setSpeedModifier(this.modifier);
            }
            if (modified) {
                e.getKB().getPathEstimates().resetDoors();
            }
        }
    }

    public static class SetDoorState
    implements EngineOp {
        public final ANode door;
        public final ITimeEstimate est;
        public final Vector2d onewayVec;
        public final boolean openOrClose;
        public final boolean setDirection;

        public static SetDoorState openDoor(ANode door) {
            return new SetDoorState(door, null, null, true, false);
        }

        public static SetDoorState closeDoor(ANode door, ITimeEstimate est) {
            return new SetDoorState(door, est, null, true, false);
        }

        public static SetDoorState openAndSetDirection(ANode door, Vector2d onewayVec) {
            return new SetDoorState(door, null, onewayVec, false, true);
        }

        private SetDoorState(ANode door, ITimeEstimate est, Vector2d onewayVec, boolean openOrClose, boolean setDirection) {
            this.door = door;
            this.est = est;
            this.onewayVec = onewayVec;
            this.openOrClose = openOrClose;
            this.setDirection = setDirection;
            assert (openOrClose ^ setDirection);
        }

        @Override
        public void run(Engine e) {
            if (this.openOrClose) {
                this.door.setClosed(this.est);
                if (this.est == null) {
                    this.door.setDoorDir(null);
                }
            }
            if (this.setDirection) {
                DoorDir dir = null;
                if (this.onewayVec != null) {
                    boolean isExit = false;
                    List<WingedEdge> edges = this.door.getDoorEdges();
                    for (WingedEdge edge : edges) {
                        if (!edge.isExit()) continue;
                        isExit = true;
                        break;
                    }
                    if (!edges.isEmpty() && !isExit) {
                        WingedEdge wedge = edges.get(0);
                        dir = wedge.getDir(new Vector3d(this.onewayVec.x, this.onewayVec.y, 0.0));
                    }
                }
                this.door.setDoorDir(dir);
                if (dir != null) {
                    this.door.setClosed(null);
                }
            }
            e.getKB().getPathEstimates().resetDoors();
        }
    }

    public static class SetAi
    implements EngineOp {
        private final List<OccAgent> d_agents;
        private final Function<OccAgent, ? extends IAiCore> d_getAiCore;

        public SetAi(Function<OccAgent, ? extends IAiCore> newAiCore, List<OccAgent> agents) {
            this.d_agents = agents;
            this.d_getAiCore = newAiCore;
        }

        @Override
        public void run(Engine e) {
            KB kb = e.getKB();
            for (OccAgent agent : this.d_agents) {
                try {
                    IAiCore thoughts = this.d_getAiCore.apply(agent);
                    thoughts.init(kb, agent);
                    agent.setAiCore(thoughts);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static class RemoveRelation
    implements EngineOp {
        OccAgent d_agent;
        IRelation d_relation;

        public RemoveRelation(OccAgent agent, IRelation relation) {
            this.d_agent = agent;
            this.d_relation = relation;
        }

        @Override
        public void run(Engine e) {
            this.d_agent.removeRelation(this.d_relation);
        }
    }

    public static class AddRelation
    implements EngineOp {
        OccAgent d_agent;
        IRelation d_relation;

        public AddRelation(OccAgent agent, IRelation relation) {
            this.d_agent = agent;
            this.d_relation = relation;
        }

        @Override
        public void run(Engine e) {
            this.d_agent.addRelation(this.d_relation);
        }
    }

    public static class AddAgent
    implements EngineOp {
        public final Occupant occ;
        public final boolean controllable;

        public AddAgent(Occupant occ, boolean controllable) {
            this.occ = occ;
            this.controllable = controllable;
        }

        @Override
        public void run(Engine e) {
            KB kb = e.getKB();
            kb.addOcc(this.occ);
            kb.createAgent(this.occ, false);
        }
    }

    public static class RemoveBlockage
    implements EngineOp {
        public final Blockage b;

        public RemoveBlockage(Blockage blkgId) {
            this.b = blkgId;
        }

        @Override
        public void run(Engine e) {
            KB kb = e.getKB();
            this.b.deactivate(kb.getMesh());
            kb.getPathEstimates().resetDoors();
        }
    }

    public static class AddBlockage
    implements EngineOp {
        public final Blockage b;

        public AddBlockage(Blockage blkgId) {
            this.b = blkgId;
        }

        @Override
        public void run(Engine e) {
            KB kb = e.getKB();
            this.b.activate(kb.getMesh());
            kb.getPathEstimates().resetDoors();
        }
    }

    public static class MultiOp
    implements EngineOp {
        public final List<EngineOp> ops;

        public MultiOp(EngineOp ... ops) {
            this.ops = new ArrayList<EngineOp>(Arrays.asList(ops));
        }

        @Override
        public void run(Engine e) {
            for (int m = 0; m < this.ops.size(); ++m) {
                this.ops.get(m).run(e);
            }
        }
    }
}

