/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.io.SerializedOutputStream;
import inferno.sim.DoorQueue;
import inferno.sim.DoorUsageSnapshot;
import inferno.sim.KB;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.WriterIntl;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;

public class DoorUsageWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private static final int MIN_FLD_LEN = 6;
    private final List<DoorUsageSnapshot> d_sortedSnapshots;
    private final List<ANode> d_sortedNodes;
    private int d_initialOccupants;
    private double d_tPrevFrame;
    private KB d_kb;
    private final SerializedOutputStream d_doorUsageStream;
    private transient PrintStream out;

    public DoorUsageWriter(KB kb) {
        this.d_kb = kb;
        ArrayList<ANode> nodes = new ArrayList<ANode>(kb.getDoorNodes());
        Collections.sort(nodes, new Comparator<ANode>(){

            @Override
            public int compare(ANode o1, ANode o2) {
                return o1.name.compareToIgnoreCase(o2.name);
            }
        });
        this.d_sortedNodes = nodes;
        ArrayList<DoorUsageSnapshot> snapshots = new ArrayList<DoorUsageSnapshot>(kb.getDoorNodes().size() * 2);
        for (ANode node : kb.getDoorNodes()) {
            DoorUsageWriter.getSnapshots(node, snapshots);
        }
        snapshots.trimToSize();
        Collections.sort(snapshots, new Comparator<DoorUsageSnapshot>(){

            @Override
            public int compare(DoorUsageSnapshot o1, DoorUsageSnapshot o2) {
                return o1.name.compareToIgnoreCase(o2.name);
            }
        });
        this.d_sortedSnapshots = snapshots;
        this.d_initialOccupants = kb.getAgents().size();
        this.d_tPrevFrame = Double.NaN;
        this.d_doorUsageStream = new SerializedOutputStream(kb.getParams().out_door_usage);
    }

    public void open(Param params) throws FileNotFoundException {
        this.out = Output.openTxtStream(this.d_doorUsageStream);
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            Output.close(this.out);
        }
    }

    public void writeHeader() {
        Consumer<Object> headers = header -> {
            String headerStr = '\"' + header.toString() + '\"';
            this.out.printf(Locale.ENGLISH, "%s,", headerStr);
        };
        headers.accept(Header.TIME);
        headers.accept(Header.REMAINING_TOTAL);
        headers.accept(Header.EXITED_TOTAL);
        HashSet<ANode> metaPrinted = new HashSet<ANode>();
        for (DoorUsageSnapshot us : this.d_sortedSnapshots) {
            String s = us.name;
            headers.accept(s);
            if (metaPrinted.contains(us.node)) continue;
            headers.accept(String.format("%s %s", s, Header.WIDTH));
            headers.accept(String.format("%s %s", s, Header.TOTAL_BOUNDARY));
            metaPrinted.add(us.node);
        }
        if (this.d_kb.hasQueueingDoors()) {
            for (ANode n : this.d_sortedNodes) {
                if (!this.d_kb.isQueueingDoor(n)) continue;
                headers.accept(n.name.concat(" " + Header.Q.val.fileStr));
            }
        }
        this.out.println();
        this.out.flush();
    }

    public void writeFrame(double t) {
        String s;
        int exitCount = 0;
        for (ANode n : this.d_sortedNodes) {
            exitCount += n.getExitedVia();
        }
        this.out.printf(Locale.ENGLISH, "%9.4f, ", t);
        this.out.printf(Locale.ENGLISH, "%19d, ", this.d_kb.getAllAgentsEver().size() - exitCount);
        this.out.printf(Locale.ENGLISH, "%16d, ", exitCount);
        HashSet<ANode> metaPrinted = new HashSet<ANode>();
        for (DoorUsageSnapshot us : this.d_sortedSnapshots) {
            s = us.name;
            int usage = us.updateUsage();
            int fldLen = Math.max(6, s.length() + 2);
            this.out.printf(Locale.ENGLISH, "%" + fldLen + "d, ", usage);
            if (metaPrinted.contains(us.node)) continue;
            double fullWidth = 0.0;
            for (WingedEdge doorEdge : us.node.getDoorEdges()) {
                fullWidth += doorEdge.base.n1.p.distance(doorEdge.base.n2.p);
            }
            double totalBoundary = fullWidth - us.node.doorQueue.getEffWidth();
            fldLen = Math.max(6, s.length() + 2 + 9);
            this.out.printf(Locale.ENGLISH, "%" + fldLen + ".3f, ", fullWidth);
            fldLen = Math.max(6, s.length() + 2 + 18);
            this.out.printf(Locale.ENGLISH, "%" + fldLen + ".3f, ", totalBoundary);
            metaPrinted.add(us.node);
        }
        if (this.d_kb.hasQueueingDoors()) {
            for (ANode n : this.d_sortedNodes) {
                if (!this.d_kb.isQueueingDoor(n)) continue;
                s = n.name.concat(" " + Header.Q.val.fileStr);
                int fldLen = Math.max(6, s.length() + 2);
                this.out.printf(Locale.ENGLISH, "%" + fldLen + "d, ", n.getNumOccupants());
            }
        }
        this.out.println();
        this.out.flush();
        this.d_tPrevFrame = t;
    }

    private static void getSnapshots(ANode node, List<DoorUsageSnapshot> snapshots) {
        DoorQueue dq = node.doorQueue;
        List<WingedEdge> edges = node.getDoorEdges();
        if (dq == null || edges.isEmpty()) {
            return;
        }
        WingedEdge we = edges.get(0);
        if (!we.isExit()) {
            assert (dq.getR1() != null && dq.getR2() != null);
            Vector3d edir = Util3D.vector(we.base.n1.p, we.base.n2.p);
            Vector3d normal = Util3D.cross(GeomConstants.VEC3D_ZPOS, edir);
            String pLbl = DoorUsageWriter.getLabel(normal);
            normal.negate();
            String nLbl = DoorUsageWriter.getLabel(normal);
            Tri pTri = we.getDestTri(DoorDir.POSITIVE);
            if (pTri == we.t2) {
                String temp = pLbl;
                pLbl = nLbl;
                nLbl = temp;
            }
            String pName = String.format("%s %s", node.name, pLbl);
            String nName = String.format("%s %s", node.name, nLbl);
            String tName = node.name;
            snapshots.add(new DoorUsageSnapshot(node, pName, DoorDir.POSITIVE));
            snapshots.add(new DoorUsageSnapshot(node, nName, DoorDir.NEGATIVE));
            snapshots.add(new DoorUsageSnapshot(node, tName, null));
        } else {
            DoorDir dir = we.getExitDir();
            snapshots.add(new DoorUsageSnapshot(node, node.name, dir));
        }
    }

    private static String getLabel(Vector3d dir) {
        Vector2d vec = new Vector2d(dir.x, dir.y);
        vec.normalize();
        if (vec.x >= 0.5) {
            return Header.XP.val.fileStr;
        }
        if (vec.x < -0.5) {
            return Header.XN.val.fileStr;
        }
        if (vec.y >= 0.5) {
            return Header.YP.val.fileStr;
        }
        return Header.YN.val.fileStr;
    }

    public static enum Header implements Supplier<WriterIntl.ColHeader>
    {
        TIME(WriterIntl.intl("time(s)")),
        REMAINING_TOTAL(WriterIntl.intl("Remaining (Total)")),
        EXITED_TOTAL(WriterIntl.intl("Exited (Total)")),
        WIDTH(WriterIntl.intl("width(m)")),
        TOTAL_BOUNDARY(WriterIntl.intl("total boundary(m)")),
        Q(WriterIntl.intl("(Q)")),
        XN(WriterIntl.intl("[-X]")),
        XP(WriterIntl.intl("[+X]")),
        YN(WriterIntl.intl("[-Y]")),
        YP(WriterIntl.intl("[+Y]"));

        public final WriterIntl.ColHeader val;

        private Header(WriterIntl.ColHeader val) {
            this.val = val;
        }

        public String toString() {
            return this.val.toString();
        }

        @Override
        public WriterIntl.ColHeader get() {
            return this.val;
        }
    }
}

