/*
 * Decompiled with CFR 0.152.
 */
package inferno.io.fdsout;

import inferno.io.fdsout.DataFinder;
import inferno.io.fdsout.DataFinderCommon;
import inferno.io.fdsout.QData;
import inferno.io.fdsout.XyzData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import vtk.vtkDataObject;
import vtk.vtkFloatArray;
import vtk.vtkMultiPieceDataSet;
import vtk.vtkRectilinearGrid;

public class DataFinderSmvPlot3d
implements DataFinder,
Serializable {
    private static final long serialVersionUID = 1L;
    private File d_smvFile;
    private Float[] d_times;
    private Map<Float, List<Pl3dMeta>> d_metaAtTimes;
    private XyzData[] d_xyzForMesh;

    public DataFinderSmvPlot3d(File f) {
        this.d_smvFile = f;
        this.d_times = new Float[0];
        this.d_metaAtTimes = new HashMap<Float, List<Pl3dMeta>>();
        this.d_xyzForMesh = new XyzData[0];
    }

    @Override
    public String getSourceFile() {
        return this.d_smvFile.getPath();
    }

    @Override
    public long getLastModified() {
        return this.d_smvFile.lastModified();
    }

    public boolean hasMeshData() {
        return this.d_xyzForMesh != null && this.d_xyzForMesh.length != 0;
    }

    @Override
    public void update() throws IOException {
        boolean STATE_SEARCH = false;
        boolean STATE_COLLECT_PL3D = true;
        int STATE_COLLECT_XYZ = 2;
        int state = 0;
        ArrayDeque plt3dSections = new ArrayDeque();
        ArrayDeque xyzSections = new ArrayDeque();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.d_smvFile.toString()), "Windows-1252"));
        String line = reader.readLine();
        while (line != null) {
            if (state != 0 && !line.startsWith(" ")) {
                state = 0;
            }
            switch (state) {
                case 0: {
                    if (line.startsWith("PL3D")) {
                        plt3dSections.addLast(new ArrayDeque());
                        ((Deque)plt3dSections.getLast()).add(line.trim());
                        state = 1;
                        break;
                    }
                    if (!line.startsWith("XYZ")) break;
                    xyzSections.addLast(new ArrayDeque());
                    ((Deque)xyzSections.getLast()).add(line.trim());
                    state = 2;
                    break;
                }
                case 1: {
                    ((Deque)plt3dSections.getLast()).add(line.trim());
                    break;
                }
                case 2: {
                    ((Deque)xyzSections.getLast()).add(line.trim());
                }
            }
            line = reader.readLine();
        }
        reader.close();
        this.d_xyzForMesh = new XyzData[xyzSections.size()];
        int xyzId = 0;
        for (Deque deque : xyzSections) {
            String filename = (String)deque.toArray()[1];
            this.d_xyzForMesh[xyzId++] = DataFinderSmvPlot3d.loadXyz(new File(this.d_smvFile.getParentFile(), filename));
        }
        this.d_metaAtTimes = new HashMap<Float, List<Pl3dMeta>>();
        for (Deque deque : plt3dSections) {
            String[] lines = deque.toArray(new String[deque.size()]);
            String[] toks = lines[0].split(" +");
            if (toks.length != 3) {
                System.err.println("Invalid format of SMV:PL3D. Skipping section.");
                continue;
            }
            float t = Float.parseFloat(toks[1]);
            int mesh = Integer.parseInt(toks[2]);
            String fn = lines[1];
            ArrayList<DataFinder.Quantity> params = new ArrayList<DataFinder.Quantity>();
            for (int lineNo = 2; lineNo <= lines.length - 3; lineNo += 3) {
                params.add(new DataFinder.Quantity(lines[lineNo], lines[lineNo + 1], lines[lineNo + 2]));
            }
            if (!this.d_metaAtTimes.containsKey(Float.valueOf(t))) {
                this.d_metaAtTimes.put(Float.valueOf(t), new ArrayList());
            }
            this.d_metaAtTimes.get(Float.valueOf(t)).add(new Pl3dMeta(t, mesh, fn, params));
        }
        this.d_times = new Float[this.d_metaAtTimes.size()];
        this.d_metaAtTimes.keySet().toArray(this.d_times);
        Arrays.sort((Object[])this.d_times);
    }

    private static ByteBuffer readFortBlock(FileChannel srcFile) throws IOException {
        ByteBuffer szBuff = DataFinderCommon.readBytes(srcFile, 4);
        int sz = szBuff.getInt();
        ByteBuffer data = DataFinderCommon.readBytes(srcFile, sz);
        ByteBuffer szTailBuff = DataFinderCommon.readBytes(srcFile, 4);
        assert (sz == szTailBuff.getInt());
        return data;
    }

    public static XyzData loadXyz(File f) throws IOException {
        FileInputStream strm = new FileInputStream(f);
        FileChannel chn = strm.getChannel();
        ByteBuffer bb = DataFinderSmvPlot3d.readFortBlock(chn);
        assert (bb.limit() == 12);
        int ibar1 = bb.getInt();
        int jbar1 = bb.getInt();
        int kbar1 = bb.getInt();
        bb.clear();
        bb = DataFinderSmvPlot3d.readFortBlock(chn);
        float[] xs = new float[ibar1];
        for (int k = 0; k < kbar1; ++k) {
            for (int j = 0; j < jbar1; ++j) {
                for (int i = 0; i < ibar1; ++i) {
                    xs[i] = bb.getFloat();
                }
            }
        }
        float[] ys = new float[jbar1];
        float y = Float.NaN;
        for (int k = 0; k < kbar1; ++k) {
            for (int j = 0; j < jbar1; ++j) {
                for (int i = 0; i < ibar1; ++i) {
                    y = bb.getFloat();
                }
                ys[j] = y;
            }
        }
        float[] zs = new float[kbar1];
        float z = Float.NaN;
        for (int k = 0; k < kbar1; ++k) {
            for (int j = 0; j < jbar1; ++j) {
                for (int i = 0; i < ibar1; ++i) {
                    z = bb.getFloat();
                }
            }
            zs[k] = z;
        }
        int[][][] blanks = new int[ibar1][jbar1][kbar1];
        for (int k = 0; k < kbar1; ++k) {
            for (int j = 0; j < jbar1; ++j) {
                for (int i = 0; i < ibar1; ++i) {
                    blanks[i][j][k] = bb.getInt();
                }
            }
        }
        strm.close();
        return new XyzData(ibar1, jbar1, kbar1, xs, ys, zs, blanks);
    }

    public static QData loadQ(Pl3dMeta meta, XyzData xyz, File f) throws IOException {
        FileInputStream strm = new FileInputStream(f);
        FileChannel chn = strm.getChannel();
        ByteBuffer bb = DataFinderSmvPlot3d.readFortBlock(chn);
        assert (bb.limit() == 12);
        int ibar1 = bb.getInt();
        int jbar1 = bb.getInt();
        int kbar1 = bb.getInt();
        bb.clear();
        bb = DataFinderSmvPlot3d.readFortBlock(chn);
        assert (bb.limit() == 16);
        bb = DataFinderSmvPlot3d.readFortBlock(chn);
        assert (bb.limit() == ibar1 * jbar1 * kbar1 * 5 * 4);
        float[] values = new float[ibar1 * jbar1 * kbar1 * 5];
        bb.asFloatBuffer().get(values);
        strm.close();
        return new QData(ibar1, jbar1, kbar1, values);
    }

    @Override
    public DataFinder.Quantity[] getQuantities() {
        if (this.d_times.length == 0) {
            return new DataFinder.Quantity[0];
        }
        List<Pl3dMeta> metas = this.d_metaAtTimes.get(this.d_times[0]);
        if (metas.isEmpty()) {
            return new DataFinder.Quantity[0];
        }
        Pl3dMeta meta = metas.get(0);
        return meta.params.toArray(new DataFinder.Quantity[meta.params.size()]);
    }

    @Override
    public Float[] getTimes() {
        return this.d_times;
    }

    @Override
    public vtkDataObject getVtkDataAt(int timeIndex) {
        List<Pl3dMeta> metas = this.d_metaAtTimes.get(this.d_times[timeIndex]);
        vtkMultiPieceDataSet data = new vtkMultiPieceDataSet();
        data.SetNumberOfPieces(metas.size());
        int pieceId = 0;
        for (Pl3dMeta meta : metas) {
            XyzData xyz = null;
            try {
                xyz = this.d_xyzForMesh[meta.mesh - 1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new Error("XYZ data not found. FDS parameter WRITE_XYZ=.TRUE. required.", e);
            }
            QData qdata = null;
            try {
                qdata = DataFinderSmvPlot3d.loadQ(meta, xyz, new File(this.d_smvFile.getParentFile(), meta.fn));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (qdata == null) continue;
            vtkFloatArray xCoords = new vtkFloatArray();
            xCoords.SetJavaArray(xyz.xs);
            vtkFloatArray yCoords = new vtkFloatArray();
            yCoords.SetJavaArray(xyz.ys);
            vtkFloatArray zCoords = new vtkFloatArray();
            zCoords.SetJavaArray(xyz.zs);
            vtkRectilinearGrid grid = new vtkRectilinearGrid();
            grid.SetDimensions(xyz.xs.length, xyz.ys.length, xyz.zs.length);
            grid.SetXCoordinates(xCoords);
            grid.SetYCoordinates(yCoords);
            grid.SetZCoordinates(zCoords);
            for (int iq = 0; iq < 5; ++iq) {
                DataFinder.Quantity param = meta.params.get(iq);
                vtkFloatArray q = new vtkFloatArray();
                q.SetName(String.format("%s (%s)", param.friendlyName, param.unit));
                int nflat = qdata.kbar1 * qdata.jbar1 * qdata.ibar1;
                float[] jArr = new float[nflat];
                System.arraycopy(qdata.valuesIJKQ, iq * nflat, jArr, 0, nflat);
                q.SetJavaArray(jArr);
                grid.GetPointData().AddArray(q);
            }
            data.SetPiece(pieceId++, grid);
        }
        return data;
    }

    private static class Pl3dMeta
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final float t;
        public final int mesh;
        public final String fn;
        public final List<DataFinder.Quantity> params;

        public Pl3dMeta(float t, int mesh, String fn, List<DataFinder.Quantity> params) {
            this.t = t;
            this.mesh = mesh;
            this.fn = fn;
            this.params = params;
        }

        public String toString() {
            return String.format("Pl3dMeta[t=%s,mesh=%s,fn=%s,params=%s]", Float.valueOf(this.t), this.mesh, this.fn, this.params);
        }
    }
}

