/*
 * Decompiled with CFR 0.152.
 */
package inferno.io;

import inferno.sim.Engine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import merlin.Intl;

public class InfernoOIS
extends ObjectInputStream {
    private final File d_readFilename;
    private final int d_version;

    public InfernoOIS(InputStream in, File readFilename) throws IOException {
        super(in);
        int version;
        this.d_readFilename = readFilename;
        this.d_version = version = this.readInt();
        this.enableResolveObject(true);
    }

    public String getReadDir() {
        return this.d_readFilename.getParent();
    }

    public boolean canOpenVersion() {
        return true;
    }

    public int getVersion() {
        return this.d_version;
    }

    public Engine readSnapshot() throws IOException, ClassNotFoundException {
        System.out.println("Loading snapshot (v " + this.d_version + ")...");
        if (!this.canOpenVersion()) {
            throw new IOException(String.format(Intl.intl("[%s] Unsupported model version."), this.getClass().getName()));
        }
        Engine engine = (Engine)this.readObject();
        return engine;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        return super.resolveClass(osc);
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        return super.resolveObject(obj);
    }

    public static String adjustOutputPath(ObjectInputStream in, String serPath) {
        String readDir;
        if (in instanceof InfernoOIS && (readDir = ((InfernoOIS)in).getReadDir()) != null) {
            File file = new File(serPath);
            File tempFile = new File(readDir, file.getName());
            return tempFile.getAbsolutePath();
        }
        return serPath;
    }
}

