/*
 * Decompiled with CFR 0.152.
 */
package inferno.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Locale;

public class CSVWriter
implements Serializable,
Closeable,
Flushable {
    static final long serialVersionUID = 1L;
    private transient PrintStream d_out;
    private int d_row = 0;
    private int d_col = 0;
    private int d_maxCol = 0;

    public static String strFormatValue(String printfStr, String nanStr, Double value) {
        return value.isNaN() ? nanStr : String.format(Locale.ENGLISH, printfStr, value);
    }

    public static String strFormatValue(String printfStr, String nanStr, Float value) {
        return value.isNaN() ? nanStr : String.format(Locale.ENGLISH, printfStr, value);
    }

    public static String format(boolean v) {
        return v ? "1" : "0";
    }

    public static String format(String s) {
        return CSVWriter.escape(s);
    }

    public static String format(int s) {
        return Integer.toString(s);
    }

    public static String format(Number n) {
        return n.toString();
    }

    public static String format(Double v) {
        return CSVWriter.strFormatValue("%f", " ", v);
    }

    public static String format(Float v) {
        return CSVWriter.strFormatValue("%f", " ", v);
    }

    public static String format(Object o) {
        if (o instanceof Double) {
            return CSVWriter.format((Double)o);
        }
        if (o instanceof Float) {
            return CSVWriter.format((Float)o);
        }
        if (o instanceof Number) {
            return CSVWriter.format((Number)o);
        }
        if (o instanceof Boolean) {
            return CSVWriter.format((Boolean)o);
        }
        if (o instanceof String) {
            return CSVWriter.format((String)o);
        }
        if (o == null) {
            return "";
        }
        return CSVWriter.format(o.toString());
    }

    public static String escape(String s) {
        String escaped = s.replace("\"", "\"\"");
        return "\"" + escaped + "\"";
    }

    public void open(PrintStream out) {
        this.d_out = out;
    }

    @Override
    public void close() {
        if (this.d_out != null) {
            this.d_out.close();
        }
    }

    @Override
    public void flush() {
        if (this.d_out != null) {
            this.d_out.flush();
        }
    }

    public void add(Object o) {
        this.addAsIs(CSVWriter.format(o));
    }

    public void addAsIs(String val) {
        if (this.d_col != 0) {
            this.d_out.append(',');
        }
        this.d_out.append(val);
        ++this.d_col;
        this.d_maxCol = Math.max(this.d_maxCol, this.d_col);
    }

    public void nextRow() {
        this.d_out.println();
        ++this.d_row;
        this.d_col = 0;
    }

    public PrintStream getStream() {
        return this.d_out;
    }

    public int getCol() {
        return this.d_col;
    }

    public int getMaxNumCols() {
        return this.d_maxCol;
    }

    public int getRow() {
        return this.d_row;
    }
}

