/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import java.math.BigDecimal;
import java.math.MathContext;
import thunderheadeng.delaunay.GeomTests;

public class PreciseGeom
extends GeomTests {
    public static boolean isectLineLine(double l1ax, double l1ay, double l1bx, double l1by, double l2ax, double l2ay, double l2bx, double l2by, double[] st) {
        double denom;
        double v2y;
        double v2x;
        double v1y;
        double v1x;
        block4: {
            assert (st.length >= 2);
            v1x = l1bx - l1ax;
            v1y = l1by - l1ay;
            v2x = l2bx - l2ax;
            v2y = l2by - l2ay;
            double detleft = v2y * v1x;
            double detright = v2x * v1y;
            denom = detleft - detright;
            if (!(PreciseGeom.testDiff(l1bx, l1ax, v1x, ccwerrboundA) && PreciseGeom.testDiff(l1by, l1ay, v1y, ccwerrboundA) && PreciseGeom.testDiff(l2bx, l2ax, v2x, ccwerrboundA) && PreciseGeom.testDiff(l2by, l2ay, v2y, ccwerrboundA) && PreciseGeom.testDiff(detleft, detright, denom, ccwerrboundA))) {
                try {
                    return PreciseGeom.isectLineLineBig(l1ax, l1ay, l1bx, l1by, l2ax, l2ay, l2bx, l2by, st);
                }
                catch (Throwable t) {
                    if (denom != 0.0) break block4;
                    return false;
                }
            }
        }
        double idenom = 1.0 / denom;
        double ydiff = l1ay - l2ay;
        double xdiff = l1ax - l2ax;
        double t1 = (v2x * ydiff - v2y * xdiff) * idenom;
        double t2 = (v1x * ydiff - v1y * xdiff) * idenom;
        st[0] = t1;
        st[1] = t2;
        return true;
    }

    public static boolean isectLineLineBig(double l1ax, double l1ay, double l1bx, double l1by, double l2ax, double l2ay, double l2bx, double l2by, double[] st) throws ArithmeticException {
        MathContext mc = MathContext.UNLIMITED;
        BigDecimal l1bxd = BigDecimal.valueOf(l1bx);
        BigDecimal l1byd = BigDecimal.valueOf(l1by);
        BigDecimal l2bxd = BigDecimal.valueOf(l2bx);
        BigDecimal l2byd = BigDecimal.valueOf(l2by);
        BigDecimal l1axd = BigDecimal.valueOf(l1ax);
        BigDecimal l1ayd = BigDecimal.valueOf(l1ay);
        BigDecimal l2axd = BigDecimal.valueOf(l2ax);
        BigDecimal p2yd = BigDecimal.valueOf(l2ay);
        BigDecimal v1xd = l1bxd.subtract(l1axd, mc);
        BigDecimal v1yd = l1byd.subtract(l1ayd, mc);
        BigDecimal v2xd = l2bxd.subtract(l2axd, mc);
        BigDecimal v2yd = l2byd.subtract(p2yd, mc);
        BigDecimal denom = v2yd.multiply(v1xd, mc).subtract(v2xd.multiply(v1yd, mc), mc);
        if (denom.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        BigDecimal ydiff = l1ayd.subtract(p2yd, mc);
        BigDecimal xdiff = l1axd.subtract(l2axd, mc);
        BigDecimal t1 = v2xd.multiply(ydiff, mc).subtract(v2yd.multiply(xdiff, mc), mc);
        BigDecimal t2 = v1xd.multiply(ydiff, mc).subtract(v1yd.multiply(xdiff, mc), mc);
        t1 = t1.divide(denom, MathContext.DECIMAL128);
        t2 = t2.divide(denom, MathContext.DECIMAL128);
        st[0] = t1.doubleValue();
        st[1] = t2.doubleValue();
        return true;
    }
}

