/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.geom.IValueField;
import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class NaiveDistanceField
implements Serializable,
IValueField<Vector3d> {
    private static final long serialVersionUID = 2533441525863686389L;
    private WingedEdge d_goal;

    public NaiveDistanceField(WingedEdge goal) {
        assert (goal != null);
        this.d_goal = goal;
    }

    @Override
    public Vector3d getValue(TriPoint tp) {
        Point3d pNear;
        double dx = this.d_goal.base.n2.p.x - this.d_goal.base.n1.p.x;
        double dy = this.d_goal.base.n2.p.y - this.d_goal.base.n1.p.y;
        if (theUtil.eq0(dx * dx + dy * dy, 1.0E-9)) {
            pNear = this.d_goal.base.n2.p;
        } else {
            double t = Inter2D.nearestTOnLine(this.d_goal.base.n1.p.x, this.d_goal.base.n1.p.y, dx, dy, tp.p.x, tp.p.y);
            if (t < 0.0) {
                t = 0.0;
            } else if (t > 1.0) {
                t = 1.0;
            }
            pNear = Util3D.linesegPoint(this.d_goal.base.n1.p, this.d_goal.base.n2.p, t);
        }
        return Util3D.vector(tp.p, pNear);
    }
}

