/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.TriPoint;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.PathGen;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.RegroupPlanner;
import inferno.sim.steering.Shortest;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.Seek;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import inferno.sim.steering.locallyquickest.PointTarget;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import thunderheadeng.util.theUtil;

public class PointGoal
implements ISeekGoal,
Serializable {
    static final long serialVersionUID = 1L;
    public final ITpSource ptSrc;
    public final double radius;
    private boolean useShortestPlanner = false;

    public PointGoal(ITpSource ptSrc, double radius) {
        this.ptSrc = ptSrc;
        this.radius = radius;
    }

    public PointGoal(TriPoint tp, double r) {
        this(new ITpSource.ConstTpSource(tp), r);
    }

    public PointGoal(ITpSource ptSrc, double radius, boolean useShortestPlanner) {
        this(ptSrc, radius);
        this.useShortestPlanner = useShortestPlanner;
    }

    public int hashCode() {
        return 1714717917 + this.ptSrc.getTriPoint().hashCode() + theUtil.hashCode(this.radius);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PointGoal)) {
            return false;
        }
        PointGoal pg = (PointGoal)obj;
        return this.ptSrc.getTriPoint().equals(pg.ptSrc.getTriPoint()) && this.radius == pg.radius;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public ISeekGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    public static class Instance
    implements ISeekGoalInstance {
        private PointGoal pointGoal;
        private transient IProgressNote d_progress;

        public Instance(PointGoal pointGoal) {
            this.pointGoal = pointGoal;
        }

        @Override
        public ISeekGoal getGoal() {
            return this.pointGoal;
        }

        @Override
        public boolean isUrgent(KB kb, OccAgent occ) {
            return false;
        }

        @Override
        public TriPoint getSeekPoint(KB kb, OccAgent occ) {
            return this.pointGoal.ptSrc.getTriPoint();
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            IPathPlanner pathPlanner;
            if (this.pointGoal.useShortestPlanner) {
                PathGen.PointGoal pg = new PathGen.PointGoal(this.pointGoal.ptSrc);
                pathPlanner = new Shortest(pg);
            } else {
                pathPlanner = new LocallyQuickest(agent, new LocalTimeEstimate.QueueSizes(), new PointTarget(this.pointGoal.ptSrc));
            }
            return SteerUtil.newSeekSteer(kb, agent, pathPlanner);
        }

        @Override
        public void end(KB kb, OccAgent agent) {
        }

        @Override
        public boolean isReached(KB kb, OccAgent agent) {
            if (this.contains(kb, agent, agent.getLoc())) {
                return !kb.getMesh().isPathObstructed(agent.getLoc(), this.pointGoal.ptSrc.getTriPoint(), 0.0, EdgeFilters.acceptAll());
            }
            return false;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue crossedDoor) {
        }

        @Override
        public boolean contains(KB kb, OccAgent occ, TriPoint p) {
            return p.p.distanceSquared(this.pointGoal.ptSrc.getTriPoint().p) <= this.pointGoal.radius * this.pointGoal.radius;
        }

        @Override
        public ISeekCalc getIdleSeek(KB kb, OccAgent agent) {
            PathGen.PointGoal pg = new PathGen.PointGoal(this.getSeekPoint(kb, agent));
            Shortest planner = new Shortest(Arrays.asList(pg));
            if (agent.getOcc().occupantGroup != null) {
                RegroupPlanner regroupPlanner = RegroupPlanner.createRegroupPlanner(agent, kb, planner);
                return new Seek(kb, agent, regroupPlanner, this.pointGoal.radius);
            }
            return new Seek(kb, agent, planner, this.pointGoal.radius);
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            this.d_progress = GoalUtil.getSeekProgress(kb, occ, this.d_progress);
            return this.d_progress;
        }

        @Override
        public Collection<ANode> getDestinationRooms() {
            return Collections.emptySet();
        }

        @Override
        public boolean shouldFillRoomOnDetach(KB kb, OccAgent agent) {
            return false;
        }
    }
}

