/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.RoomGoal;
import inferno.sim.DoorQueue;
import inferno.sim.IOccGroup;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccGroup;
import inferno.sim.OccGroupType;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.SteerUtil;
import java.io.Serializable;
import java.util.Collections;

public class JoinOccGroupGoal
implements IIdleGoal,
Serializable {
    public final IOccGroup group;

    public JoinOccGroupGoal(IOccGroup occGroup) {
        this.group = occGroup;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        if (this.group instanceof OccGroup) {
            agent.getOcc().occupantGroup = (OccGroup)this.group;
        }
        this.group.joinDynamically(agent);
        return new Instance(this);
    }

    public static class Instance
    implements IIdleGoalInstance {
        private JoinOccGroupGoal joinOccGroup;
        private ISteeringBehavior waitGoalBehavior;

        public Instance(JoinOccGroupGoal joinOccGroup) {
            this.joinOccGroup = joinOccGroup;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            if (this.waitGoalBehavior == null) {
                this.waitGoalBehavior = SteerUtil.newIdleSteer(kb, occ, () -> new RoomGoal(Collections.singleton(occAgent.getOcc().curNode)).begin(kb, occ).getIdleSeek(kb, occ), () -> new ITpSource.ConstTpSource(occ.getLoc()));
            }
            return this.waitGoalBehavior;
        }

        @Override
        public void end(KB kb, OccAgent occ) {
            IIdleGoalInstance.super.end(kb, occ);
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            OccGroup group = occ.getOcc().occupantGroup;
            if (group == null) {
                return false;
            }
            if (this.joinOccGroup.group instanceof OccGroup) {
                return group == this.joinOccGroup.group;
            }
            if (this.joinOccGroup.group instanceof OccGroupType) {
                return group.type == this.joinOccGroup.group;
            }
            assert (false);
            return true;
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            return occ.getOcc().occupantGroup != null ? IProgressNote.PROGRESSING : IProgressNote.NOT_PROGRESSING;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public IIdleGoal getGoal() {
            return this.joinOccGroup;
        }

        @Override
        public double getEndTime(KB kb) {
            return kb.getCurrentSimTime();
        }
    }
}

