/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.data2.ai.RoomGoal;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.AiUtil;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.SteerUtil;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;

public class FillRoomGoal
implements IIdleGoal,
Serializable {
    static final long serialVersionUID = 1L;
    private static final double SETTLE_TIME = 2.0;
    private static final double MIN_ROOM_TIME = 5.0;
    public static final FillRoomGoal ALWAYS = new FillRoomGoal(false);
    public static final FillRoomGoal ONLY_IF_NECESSARY = new FillRoomGoal(true);
    public final boolean onlyIfNeeded;

    private FillRoomGoal(boolean onlyIfNeeded) {
        this.onlyIfNeeded = onlyIfNeeded;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.onlyIfNeeded) {
            return ONLY_IF_NECESSARY;
        }
        return ALWAYS;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this, kb, agent);
    }

    private static class Instance
    implements IIdleGoalInstance,
    Serializable {
        static final long serialVersionUID = 1L;
        public final FillRoomGoal goal;
        public final ANode node;
        private double d_tEnter;
        private double d_tMax = Double.NaN;
        private Double d_basicTimeEstimate;
        private double d_tStopped = Double.POSITIVE_INFINITY;
        private State d_state;

        public Instance(FillRoomGoal goal, KB kb, OccAgent agent) {
            this.goal = goal;
            this.node = agent.getOcc().curNode;
            this.d_tEnter = kb.getCurrentSimTime();
            this.d_state = State.UNKNOWN;
        }

        @Override
        public void end(KB kb, OccAgent occ) {
        }

        @Override
        public FillRoomGoal getGoal() {
            return this.goal;
        }

        @Override
        public boolean wasImmediate() {
            return this.d_state == State.IMMEDIATELY_FINISHED;
        }

        private void initState(KB kb, OccAgent agent) {
            if (this.d_state == State.UNKNOWN) {
                if (!(!this.goal.onlyIfNeeded || agent.getAssistedEvacClientModule().isPresent() && AiUtil.getCurrentSeek(agent).shouldFillRoomOnDetach(kb, agent))) {
                    this.d_state = State.IMMEDIATELY_FINISHED;
                    return;
                }
                this.d_state = State.FILLING;
            }
        }

        @Override
        public void preMove(KB kb, OccAgent agent, double dt) {
            IIdleGoalInstance.super.preMove(kb, agent, dt);
            this.initState(kb, agent);
            if (this.d_state == State.IMMEDIATELY_FINISHED) {
                return;
            }
            if (this.calcIsReached(kb, agent)) {
                this.d_state = State.FINISHED;
            }
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            this.initState(kb, agent);
            if (this.d_state == State.IMMEDIATELY_FINISHED) {
                return IIdleGoalInstance.super.generateSteeringBehavior(kb, agent);
            }
            return SteerUtil.newIdleSteer(kb, agent, () -> {
                RoomGoal rg = new RoomGoal(Collections.singleton(occAgent.getOcc().curNode));
                return rg.begin(kb, agent).getIdleSeek(kb, agent);
            }, () -> {
                ISeekGoalInstance seekGoal = AiUtil.getCurrentSeek(agent);
                return new ITpSource.ConstTpSource(seekGoal.getSeekPoint(kb, agent));
            });
        }

        private double getBasicTimeEstimate(KB kb, OccAgent agent) {
            if (this.d_basicTimeEstimate == null) {
                AABox roomBounds = this.node.getGeometryBounds();
                double roomDist = Util3D.to2d(roomBounds.getMin()).distance(Util3D.to2d(roomBounds.getMax()));
                double maxSpeed = OccAgent.getMaxVel(kb, agent.getOcc(), null);
                this.d_basicTimeEstimate = roomDist / maxSpeed * 2.0;
            }
            return this.d_basicTimeEstimate;
        }

        private boolean calcIsReached(KB kb, OccAgent occ) {
            boolean stopped;
            double timeLimit = occ.getSteeringBehavior().getTimeLimit(kb, occ) * 2.0;
            if (timeLimit == 0.0 || Double.isInfinite(timeLimit)) {
                timeLimit = this.getBasicTimeEstimate(kb, occ);
            }
            if (Double.isNaN(this.d_tMax)) {
                this.d_tMax = Math.max(5.0, timeLimit);
            } else if (timeLimit > this.d_tMax) {
                this.d_tMax = timeLimit;
            }
            if (occ.getOcc().curNode != this.node) {
                this.d_tEnter = Double.NaN;
                return false;
            }
            if (Double.isNaN(this.d_tEnter)) {
                this.d_tEnter = kb.getCurrentSimTime();
            }
            double t = kb.getCurrentSimTime();
            double settleTime = 2.0;
            double tGiveUp = this.d_tEnter + this.d_tMax;
            if (kb.getCurrentSimTime() >= tGiveUp) {
                settleTime = 0.0;
            }
            boolean bl = stopped = occ.getLastSteer().vel.lengthSquared() <= 1.0E-6 || occ.getVel().lengthSquared() <= 1.0E-6;
            if (stopped && (occ.getAvoidOcc() == null || occ.getAvoidOcc().isWaiting(kb))) {
                this.d_tStopped = Math.min(this.d_tStopped, t);
                double tStopElapsed = t - this.d_tStopped;
                if (tStopElapsed >= settleTime) {
                    return true;
                }
            } else {
                this.d_tStopped = Double.POSITIVE_INFINITY;
            }
            return false;
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            return this.d_state.finished;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public boolean isSeeking(KB kb, OccAgent agent) {
            return false;
        }

        @Override
        public double getEndTime(KB kb) {
            if (this.d_state == State.IMMEDIATELY_FINISHED) {
                return kb.getCurrentSimTime();
            }
            return Double.POSITIVE_INFINITY;
        }

        private static enum State {
            UNKNOWN(false),
            FILLING(false),
            IMMEDIATELY_FINISHED(true),
            FINISHED(true);

            public final boolean finished;

            private State(boolean finished) {
                this.finished = finished;
            }
        }
    }
}

