/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ai.AssistedEvacTeam;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

public class DetachGoal
implements IIdleGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final DetachGoal DETACH_ALL = new DetachGoal(Collections.emptyList());
    public final Collection<AssistedEvacTeam> teams;

    public DetachGoal(Collection<AssistedEvacTeam> teams) {
        this.teams = teams;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DetachGoal && GoalUtil.setsEqual(this.teams, ((DetachGoal)obj).teams);
    }

    public int hashCode() {
        return 0x9FA8D3 ^ GoalUtil.setHashCode(this.teams);
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent occ) {
        Collection<AssistedEvacTeam> teams = this.teams;
        if (teams.isEmpty()) {
            teams = kb.getAssistedEvacTeams();
        }
        for (AssistedEvacTeam team : teams) {
            team.removeClient(occ);
        }
        return new Instance(this);
    }

    public static class Instance
    implements IIdleGoalInstance {
        static final long serialVersionUID = 1L;
        private final DetachGoal detachGoal;

        public Instance(DetachGoal detachGoal) {
            this.detachGoal = detachGoal;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.detachGoal;
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            if (occ.getAssistedEvacClientModule().isPresent()) {
                return occ.getAssistedEvacClientModule().get().isUnoccupied();
            }
            return true;
        }

        @Override
        public void end(KB kb, OccAgent occ) {
            IIdleGoalInstance.super.end(kb, occ);
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public double getEndTime(KB kb) {
            return kb.getCurrentSimTime();
        }
    }
}

