/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Edge;
import inferno.data2.EdgeData;
import inferno.data2.ElevatorLevel;
import inferno.data2.IIdentifiable;
import inferno.data2.Tri;
import inferno.data2.Vertex;
import inferno.geom.PreciseGeom;
import inferno.sim.DoorQueue;
import java.io.Serializable;
import java.util.Optional;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class WingedEdge
implements Serializable,
IIdentifiable {
    static final long serialVersionUID = 1L;
    public final int id;
    public final EdgeData data;
    public final Edge base;
    public final Tri t1;
    public final Tri t2;

    public WingedEdge(int id, EdgeData data, Edge edge, Tri t1, Tri t2) {
        this.id = id;
        this.data = data;
        this.base = edge;
        this.t1 = t1;
        this.t2 = t2;
    }

    public Point3d p1() {
        return this.base.n1.p;
    }

    public Vertex v1() {
        return this.base.n1;
    }

    public Point3d p2() {
        return this.base.n2.p;
    }

    public Vertex v2() {
        return this.base.n2;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public Tri triForPt(Point3d p) {
        double side = this.whichSide(p, 0.0);
        return side >= 0.0 ? this.t1 : this.t2;
    }

    public double whichSide(Point3d p, double tol) {
        if (tol == 0.0) {
            return PreciseGeom.orient2d(this.base.n1.p.x, this.base.n1.p.y, this.base.n2.p.x, this.base.n2.p.y, p.x, p.y);
        }
        double cross = Util2D.cross(this.base.n2.p.x - this.base.n1.p.x, this.base.n2.p.y - this.base.n1.p.y, p.x - this.base.n1.p.x, p.y - this.base.n1.p.y);
        return theUtil.eq0(cross, tol) ? 0.0 : cross;
    }

    public double whichSide(Vector3d dir, double tol) {
        double cross = Util2D.cross(this.base.n2.p.x - this.base.n1.p.x, this.base.n2.p.y - this.base.n1.p.y, dir.x, dir.y);
        return theUtil.eq0(cross, tol) ? 0.0 : cross;
    }

    public Tri getTri(double side) {
        return side >= 0.0 ? this.t1 : this.t2;
    }

    public Tri getTri(ANode node) {
        assert (!this.isInternal());
        ANode node1 = this.getNode1();
        return node == node1 ? this.t1 : this.t2;
    }

    public Point3d get(double t) {
        return this.base.get(t);
    }

    public boolean isBoundary() {
        return this.data.type == 4;
    }

    public boolean isExit() {
        return this.data.type == 3;
    }

    public boolean isDoor() {
        return (this.data.type & 1) > 0;
    }

    public boolean isOnewayDoor() {
        return this.isDoor() && this.data.node.getOnewayDir() != null;
    }

    public boolean isInternal() {
        return this.getNode1() == this.getNode2();
    }

    public boolean isElevatorDoor() {
        if (!this.isDoor()) {
            return false;
        }
        boolean node1El = this.getNode1() != null && this.getNode1().getElevatorLevel() != null;
        boolean node2El = this.getNode2() != null && this.getNode2().getElevatorLevel() != null;
        return node1El != node2El;
    }

    public Optional<ElevatorLevel> getElevatorLevel() {
        if (this.getNode1() != null && this.getNode1().getElevatorLevel() != null) {
            return Optional.of(this.getNode1().getElevatorLevel());
        }
        if (this.getNode2() != null && this.getNode2().getElevatorLevel() != null) {
            return Optional.of(this.getNode2().getElevatorLevel());
        }
        return Optional.empty();
    }

    public ANode getNode1() {
        return this.t1 == null ? null : this.t1.node;
    }

    public ANode getNode2() {
        return this.t2 == null ? null : this.t2.node;
    }

    public Tri getDestTri(DoorDir dir) {
        if (this.isDoor() && !this.data.node.isInternalDoor()) {
            ANode node = this.data.node.doorQueue.dest(dir);
            return node == this.getNode1() ? this.t1 : this.t2;
        }
        return dir == DoorDir.POSITIVE ? this.t1 : this.t2;
    }

    public Tri getSrcTri(DoorDir dir) {
        return this.getAdjTri(this.getDestTri(dir));
    }

    public ANode getDestNode(DoorDir dir) {
        Tri tri = this.getDestTri(dir);
        return tri != null ? tri.node : null;
    }

    public ANode getAdjNode(ANode node) {
        ANode node1 = this.getNode1();
        return node1 == node ? this.getNode2() : node1;
    }

    public ANode getSrcNode(DoorDir dir) {
        Tri tri = this.getSrcTri(dir);
        return tri != null ? tri.node : null;
    }

    public DoorDir getDir(Tri destTri) {
        if (this.isDoor()) {
            return DoorDir.get(this.data.node, destTri);
        }
        return destTri == this.t1 ? DoorDir.POSITIVE : DoorDir.NEGATIVE;
    }

    public DoorDir getExitDir(Tri destTri) {
        if (this.isExit()) {
            return DoorDir.getExitDir(this.data.node);
        }
        return this.getDir(destTri);
    }

    public DoorDir getExitDir() {
        assert (this.isExit());
        return DoorDir.getExitDir(this.data.node);
    }

    public DoorDir getDir(ANode destNode) {
        assert (this.getNode1() != this.getNode2());
        return destNode == this.getNode1() ? this.getDir(this.t1) : this.getDir(this.t2);
    }

    public DoorDir getDir(Vector3d v) {
        Vector3d eDir = Util3D.vectorN(this.base.n1.p, this.base.n2.p);
        eDir.cross(eDir, v);
        Tri t = eDir.z >= 0.0 ? this.t1 : this.t2;
        return this.getDir(t);
    }

    public DoorQueue getDoorQueue() {
        assert (this.isDoor());
        return this.data.node.doorQueue;
    }

    public Tri getAdjTri(Tri t) {
        return t == this.t1 ? this.t2 : this.t1;
    }

    public Tri[] getAdjTris() {
        if (this.t1 != null && this.t2 != null && this.t1 != this.t2) {
            return new Tri[]{this.t1, this.t2};
        }
        if (this.t1 != null) {
            return new Tri[]{this.t1};
        }
        if (this.t2 != null) {
            return new Tri[]{this.t2};
        }
        return new Tri[0];
    }

    public boolean isValid() {
        Vector3d toT2;
        Vector3d toT1;
        double dir;
        if (this.t1 != null && this.getTri(dir = this.whichSide(toT1 = Util3D.vector(this.base.midpoint(), this.t1.center), 1.0E-9)) != this.t1) {
            return false;
        }
        return this.t2 == null || this.getTri(dir = this.whichSide(toT2 = Util3D.vector(this.base.midpoint(), this.t2.center), 1.0E-9)) == this.t2;
    }

    public String toString() {
        return String.format("WingedEdge[node=%s, (%s) -> (%s)] : %d (%d, %d)", this.data.node != null ? this.data.node.name : null, this.base.n1.p.toString(), this.base.n2.p.toString(), this.data.type, this.t1 != null ? this.t1.id : -1, this.t2 != null ? this.t2.id : -1);
    }

    public boolean isTransportDoor() {
        return this.isElevatorDoor();
    }
}

