/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.IAnimSrc;
import inferno.data2.Material;
import inferno.data2.Mesh;
import inferno.data2.SpeedModifier;
import inferno.data2.Tri;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Blockage
implements Serializable,
IAnimSrc {
    static final long serialVersionUID = 1L;
    private final int d_id;
    private final String d_name;
    private final double d_velFactor;
    private final int[] d_triIds;
    private boolean d_active;
    private final Material d_display;
    private List<SpeedModifier> d_oldSpeedModifiers;

    public Blockage(int id, String name, Material display, double velFactor, int ... triIds) {
        this.d_id = id;
        this.d_display = display;
        this.d_name = name;
        this.d_velFactor = velFactor;
        this.d_triIds = triIds;
        this.d_active = false;
        this.d_oldSpeedModifiers = null;
    }

    public int getId() {
        return this.d_id;
    }

    public String getName() {
        return this.d_name;
    }

    public Material getDisplay() {
        return this.d_display;
    }

    public int[] getTriIds() {
        return this.d_triIds;
    }

    public double getVelFactor() {
        return this.d_velFactor;
    }

    public void activate(Mesh m) {
        double factor = Math.max(this.d_velFactor, 0.01);
        SpeedModifier modifier = new SpeedModifier(SpeedModifier.Type.FACTOR, factor);
        this.d_oldSpeedModifiers = new ArrayList<SpeedModifier>(this.getTriIds().length);
        for (int id : this.getTriIds()) {
            Tri t = m.getTris()[id];
            this.d_oldSpeedModifiers.add(t.getSpeedModifier());
            t.setSpeedModifier(modifier);
        }
        this.d_active = true;
    }

    public void deactivate(Mesh m) {
        int[] tids = this.getTriIds();
        for (int i = 0; i < tids.length; ++i) {
            int id = tids[i];
            SpeedModifier mod = this.d_oldSpeedModifiers.get(i);
            Tri t = m.getTris()[id];
            t.setSpeedModifier(mod);
        }
        this.d_active = false;
    }

    public boolean isActive() {
        return this.d_active;
    }
}

