/*
 * Decompiled with CFR 0.152.
 */
package fpserver;

import fpserver.IPacket;
import fpserver.IServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class ServerUdp
implements IServer {
    private DatagramSocket d_socket;
    private Deque<IPacket> d_msgQueue;
    private int d_port;
    private int d_nextClientId;
    private Map<InetSocketAddress, Integer> d_clientMap;

    public ServerUdp(int port) {
        this.d_port = port;
        this.d_msgQueue = new ArrayDeque<IPacket>();
        this.d_clientMap = new HashMap<InetSocketAddress, Integer>();
        this.d_nextClientId = 0;
        try {
            this.d_socket = new DatagramSocket(this.d_port);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ServerUdp.this.listen(ServerUdp.this.d_port);
            }
        });
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen(int port) {
        System.out.println("Listening on port: " + port);
        while (true) {
            byte[] buffer = new byte[512];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            try {
                this.d_socket.receive(packet);
                InetSocketAddress addr = (InetSocketAddress)packet.getSocketAddress();
                if (!this.d_clientMap.containsKey(addr)) {
                    this.d_clientMap.put(addr, this.d_nextClientId++);
                }
                int clientId = this.d_clientMap.get(addr);
                Deque<IPacket> deque = this.d_msgQueue;
                synchronized (deque) {
                    this.d_msgQueue.add(new UdpPacket(clientId, packet));
                    this.d_msgQueue.notify();
                    continue;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public Deque<IPacket> getMessageQueue() {
        return this.d_msgQueue;
    }

    @Override
    public void addClient(InetSocketAddress client) {
        if (!this.d_clientMap.containsKey(client)) {
            this.d_clientMap.put(client, this.d_nextClientId++);
        }
    }

    @Override
    public void broadcast(byte[] msg, int offset, int length, Object mergeId) {
    }

    @Override
    public void asyncSend(IPacket recvPacket, byte[] msg, int offset, int length, Object mergeId) {
    }

    private void send(IPacket recvPacket, byte[] data) {
        SocketAddress sktAdr = ((UdpPacket)recvPacket).getSocket();
        try {
            DatagramPacket dp = new DatagramPacket(data, data.length, sktAdr);
            this.d_socket.send(dp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class UdpPacket
    implements IPacket {
        private String d_msg;
        private DatagramPacket d_packet;
        private int d_clientId;

        public UdpPacket(int clientId, DatagramPacket dp) {
            this.d_packet = dp;
            this.d_msg = new String(this.d_packet.getData(), 0, this.d_packet.getLength());
            this.d_clientId = clientId;
        }

        @Override
        public String getMsg() {
            return this.d_msg;
        }

        public SocketAddress getSocket() {
            return this.d_packet.getSocketAddress();
        }

        @Override
        public int getClientId() {
            return this.d_clientId;
        }
    }

    private class SendOnFlushOutputStream
    extends ByteArrayOutputStream {
        private UdpPacket d_recvPacket;

        public SendOnFlushOutputStream(UdpPacket recvPacket) {
            this.d_recvPacket = recvPacket;
        }

        @Override
        public void flush() throws IOException {
            ServerUdp.this.send(this.d_recvPacket, this.toByteArray());
            this.reset();
        }
    }
}

