/*
 * Decompiled with CFR 0.152.
 */
package fpserver;

import fpserver.IPacket;
import fpserver.IServer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Deque;

public class ServerConsole
implements IServer,
Runnable {
    private Deque<IPacket> d_msgQueue = new ArrayDeque<IPacket>();

    public ServerConsole() {
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(final String line) {
        IPacket pkt = new IPacket(){

            @Override
            public String getMsg() {
                return line;
            }

            @Override
            public int getClientId() {
                return 0;
            }
        };
        Deque<IPacket> deque = this.d_msgQueue;
        synchronized (deque) {
            this.d_msgQueue.add(pkt);
            this.d_msgQueue.notify();
        }
    }

    @Override
    public void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        try {
            line = reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (line != null) {
            this.exec(line);
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Deque<IPacket> getMessageQueue() {
        return this.d_msgQueue;
    }

    @Override
    public void addClient(InetSocketAddress client) {
    }

    @Override
    public void broadcast(byte[] msg, int offset, int length, Object mergeId) {
        System.out.println(new String(msg, offset, length));
    }

    @Override
    public void asyncSend(IPacket recvPacket, byte[] msg, int offset, int length, Object mergeId) {
        this.broadcast(msg, offset, length, mergeId);
    }

    private class SendOnFlushOutputStream
    extends ByteArrayOutputStream {
        private SendOnFlushOutputStream() {
        }

        @Override
        public void flush() throws IOException {
            System.out.println(this.toString());
        }
    }
}

